/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VolumeAction
extends CompoundAction {
    public static final float DEGTORAD = (float)Math.PI / 180;
    private static final int DEFAULT_RADIUS = 2;
    protected boolean autoOrient;
    protected int radius;
    protected int radiusSquared;
    protected int currentRadius;
    protected float centerProbability;
    protected float outerProbability;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int thickness;
    protected int yStart;
    protected int yEnd;
    private int xOffset;
    private int zOffset;
    private int dy;
    private int dx;
    private int dz;
    private int xDirection;
    private int zDirection;
    private int startRadius;
    private boolean checked;
    private Vector min;
    private Vector max;
    private VolumeType volumeType;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getInt("radius", 2);
        this.xSize = parameters.getInt("x_size", this.radius);
        this.ySize = parameters.getInt("y_size", this.radius);
        this.zSize = parameters.getInt("z_size", this.radius);
        this.thickness = parameters.getInt("thickness", 0);
        this.autoOrient = parameters.getBoolean("orient", false);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
        String typeString = parameters.getString("volume_type");
        if (typeString != null) {
            try {
                this.volumeType = VolumeType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.volumeType = VolumeType.SPIRAL;
            }
        } else {
            this.volumeType = VolumeType.SPIRAL;
        }
        this.calculateSize(context);
    }

    protected void calculateSize(CastContext context) {
        boolean centerY = this.parameters.getBoolean("center_y", true);
        boolean centerX = this.parameters.getBoolean("center_x", true);
        boolean centerZ = this.parameters.getBoolean("center_z", true);
        if (this.parameters.getBoolean("use_brush_size", false)) {
            MaterialBrush brush = context.getBrush();
            if (!brush.isReady()) {
                long timeout = System.currentTimeMillis() + 10000L;
                while (System.currentTimeMillis() < timeout) {
                    try {
                        Thread.sleep(500L);
                        if (!brush.isReady()) continue;
                        break;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (brush.isReady()) {
                Vector bounds = brush.getSize();
                this.xSize = (int)Math.ceil(bounds.getX() / 2.0) + 1;
                this.ySize = (int)Math.ceil(bounds.getY() / 2.0) + 1;
                this.zSize = (int)Math.ceil(bounds.getZ() / 2.0) + 1;
                if (this.volumeType == VolumeType.SPIRAL) {
                    this.xSize = Math.max(this.xSize, this.zSize);
                    this.zSize = Math.max(this.xSize, this.zSize);
                }
                centerY = false;
            }
        } else {
            this.xSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.xSize);
            this.ySize = (int)(context.getMage().getRadiusMultiplier() * (float)this.ySize);
            this.zSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.zSize);
        }
        if (this.volumeType == VolumeType.SPIRAL && this.xSize != this.zSize) {
            this.volumeType = VolumeType.YZX;
        }
        if (centerY) {
            this.yStart = -this.ySize;
            this.yEnd = this.ySize;
        } else {
            this.yStart = 0;
            this.yEnd = this.ySize * 2;
        }
        this.xOffset = !centerX ? this.xSize : 0;
        this.zOffset = !centerZ ? this.zSize : 0;
        if (this.volumeType != VolumeType.SPIRAL) {
            this.min = new Vector(-this.xSize, this.yStart, -this.zSize);
            this.max = new Vector(this.xSize, this.yEnd, this.zSize);
        }
        this.radius = Math.max(this.xSize, this.zSize);
        this.radiusSquared = this.radius * this.radius;
        this.startRadius = this.getStartRadius();
    }

    protected int getStartRadius() {
        return 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
        if (this.volumeType == VolumeType.SPIRAL) {
            this.currentRadius = this.startRadius;
            this.dx = -Math.min(this.startRadius, this.xSize);
            this.dy = this.yStart;
            this.dz = -Math.min(this.startRadius, this.zSize);
            this.xDirection = 1;
            this.zDirection = 0;
        } else {
            this.dx = this.min.getBlockX();
            this.dy = this.min.getBlockY();
            this.dz = this.min.getBlockZ();
        }
        this.checked = false;
        MaterialBrush brush = context.getBrush();
        brush.setTarget(context.getTargetLocation());
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        x += 0.5;
        y += 0.5;
        z += 0.5;
        float angle = -yaw * ((float)Math.PI / 180);
        double sinYaw = Math.sin(angle);
        double cosYaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        double pitchedZ = y * sinPitch + z * cosPitch;
        double finalX = x * cosYaw + pitchedZ * sinYaw;
        double finalY = y * cosPitch - z * sinPitch;
        double finalZ = -x * sinYaw + pitchedZ * cosYaw;
        return new Vector(finalX, finalY, finalZ);
    }

    protected SpellResult checkPoint(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        if (!this.checked) {
            this.checked = this.containsPoint(this.dx, this.dy, this.dz);
            float probability = this.centerProbability;
            if (this.centerProbability != this.outerProbability) {
                float weight = Math.abs((float)this.dx + (float)this.dz) / ((float)this.radius * 2.0f);
                probability = RandomUtils.lerp(Float.valueOf(this.centerProbability), Float.valueOf(this.outerProbability), weight).floatValue();
            }
            boolean bl = this.checked = this.checked && (probability >= 1.0f || context.getRandom().nextDouble() <= (double)probability);
        }
        if (this.checked) {
            Block block = context.getTargetBlock();
            Vector offset = new Vector();
            if (this.autoOrient) {
                Location location = this.actionContext.getLocation();
                offset.setX(this.dx + this.xOffset);
                offset.setY(this.dy);
                offset.setZ(this.dz + this.zOffset);
                Block originalBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
                this.actionContext.setTargetSourceLocation(originalBlock.getRelative(-this.xOffset, 0, -this.zOffset).getLocation());
                offset = VolumeAction.rotate(location.getYaw(), location.getPitch(), offset.getX(), offset.getY(), offset.getZ());
            } else {
                offset.setX(this.dx);
                offset.setY(this.dy);
                offset.setZ(this.dz);
            }
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            this.actionContext.setTargetLocation(targetBlock.getLocation());
            SpellResult actionResult = super.perform(this.actionContext);
            result = result.min(actionResult);
        } else {
            this.skippedActions(context);
        }
        return result;
    }

    protected SpellResult performYZX(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        while (this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ() && !(result = result.min(this.checkPoint(context))).isStop()) {
            ++this.dy;
            if (this.dy > this.max.getBlockY()) {
                this.dy = this.min.getBlockY();
                ++this.dz;
                if (this.dz > this.max.getBlockZ()) {
                    this.dz = this.min.getBlockZ();
                    ++this.dx;
                }
            }
            this.checked = false;
            super.reset(context);
        }
        return result;
    }

    protected SpellResult performYXZ(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        while (this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ() && !(result = result.min(this.checkPoint(context))).isStop()) {
            ++this.dy;
            if (this.dy > this.max.getBlockY()) {
                this.dy = this.min.getBlockY();
                ++this.dx;
                if (this.dx > this.max.getBlockX()) {
                    this.dx = this.min.getBlockX();
                    ++this.dz;
                }
            }
            this.checked = false;
            super.reset(context);
        }
        return result;
    }

    protected SpellResult performSpiral(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        while (this.currentRadius <= this.radius && !(result = result.min(this.checkPoint(context))).isStop()) {
            ++this.dy;
            if (this.dy > this.yEnd) {
                this.dy = this.yStart;
                int nextX = this.dx + this.xDirection;
                int nextZ = this.dz + this.zDirection;
                int endX = Math.min(this.currentRadius, this.xSize);
                int endZ = Math.min(this.currentRadius, this.zSize);
                if (this.xDirection == 0 && this.zDirection == -1 && nextX <= -endX && nextZ <= -endZ || this.currentRadius == 0) {
                    ++this.currentRadius;
                    this.dx = -this.currentRadius;
                    this.dz = -this.currentRadius;
                    this.xDirection = 1;
                    this.zDirection = 0;
                } else if (nextX > this.currentRadius || nextZ > endZ || nextX < -endX || nextZ < -endZ) {
                    if (this.xDirection == 1 && this.zDirection == 0) {
                        this.xDirection = 0;
                        this.zDirection = 1;
                        this.dz += this.zDirection;
                    } else if (this.xDirection == 0 && this.zDirection == 1) {
                        this.xDirection = -1;
                        this.zDirection = 0;
                        this.dx += this.xDirection;
                    } else {
                        this.xDirection = 0;
                        this.zDirection = -1;
                        this.dz += this.zDirection;
                    }
                } else {
                    this.dx = nextX;
                    this.dz = nextZ;
                }
            }
            this.checked = false;
            super.reset(context);
        }
        return result;
    }

    public SpellResult performSingle(CastContext context) {
        if (!this.checked && this.centerProbability < 1.0f && context.getRandom().nextDouble() <= (double)this.centerProbability) {
            return SpellResult.NO_ACTION;
        }
        Block block = context.getTargetBlock();
        this.checked = true;
        this.actionContext.setTargetLocation(block.getLocation());
        return super.perform(this.actionContext);
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.radius < 1 && this.ySize < 1) {
            return this.performSingle(context);
        }
        SpellResult result = SpellResult.NO_ACTION;
        switch (this.volumeType) {
            case SPIRAL: {
                result = this.performSpiral(context);
                break;
            }
            case YZX: {
                result = this.performYZX(context);
                break;
            }
            case YXZ: {
                result = this.performYXZ(context);
            }
        }
        return result;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    protected boolean containsPoint(int x, int y, int z) {
        return this.thickness == 0 || x > this.radius - this.thickness || y > this.radius - this.thickness || z > this.radius - this.thickness;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
        parameters.add("use_brush_size");
        parameters.add("thickness");
        parameters.add("orient");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("radius") || parameterKey.equals("thickness")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else if (parameterKey.equals("orient") || parameterKey.equals("use_brush_size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public int getActionCount() {
        int volume = (1 + this.xSize * 2) * (1 + this.ySize * 2) * (1 + this.zSize * 2);
        return volume * this.actions.getActionCount();
    }

    private static enum VolumeType {
        SPIRAL,
        YZX,
        YXZ;

    }
}

