/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundEntityAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AllEntitiesAction
extends CompoundEntityAction {
    private boolean targetAllWorlds;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetAllWorlds = parameters.getBoolean("target_all_worlds", false);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location sourceLocation = context.getLocation();
        if (sourceLocation == null && !this.targetAllWorlds) {
            return SpellResult.LOCATION_REQUIRED;
        }
        return super.perform(context);
    }

    @Override
    public void addEntities(CastContext context, List<WeakReference<Entity>> entities) {
        Spell spell = context.getSpell();
        Entity sourceEntity = context.getMage().getEntity();
        Location sourceLocation = context.getLocation();
        if (sourceLocation == null && !this.targetAllWorlds) {
            return;
        }
        Class<Player> targetType = Player.class;
        if (spell instanceof TargetingSpell) {
            targetType = ((TargetingSpell)spell).getTargetEntityType();
        }
        if (targetType == Player.class) {
            Collection players = context.getPlugin().getServer().getOnlinePlayers();
            for (Player player : players) {
                if (!this.targetSelf && player == sourceEntity || !this.targetAllWorlds && (sourceLocation == null || !sourceLocation.getWorld().equals(player.getWorld())) || !spell.canTarget((Entity)player)) continue;
                entities.add(new WeakReference<Player>(player));
            }
        } else {
            ArrayList<World> worlds;
            if (this.targetAllWorlds) {
                worlds = Bukkit.getWorlds();
            } else {
                worlds = new ArrayList<World>();
                worlds.add(sourceLocation.getWorld());
            }
            for (World world : worlds) {
                List candidates = world.getEntities();
                for (Entity entity : candidates) {
                    if (!spell.canTarget(entity) || !this.targetSelf && entity == sourceEntity) continue;
                    entities.add(new WeakReference<Entity>(entity));
                }
            }
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_all_worlds");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_all_worlds")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

