/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.TriggeredCompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileAction
extends TriggeredCompoundAction {
    private int defaultSize = 1;
    private static Field lifeField = null;
    private static boolean reflectionInitialized = false;
    private int count;
    private int undoInterval;
    private int size;
    private double damage;
    private float speed;
    private float spread;
    private boolean useFire;
    private boolean breakBlocks;
    private int tickIncrease;
    private String projectileTypeName;
    private int startDistance;
    private static Class<?> projectileClass;
    private static Class<?> fireballClass;
    private static Class<?> arrowClass;
    private static Class<?> worldClass;
    private static Class<?> entityClass;
    private static Class<?> craftArrowClass;

    private void checkReflection(MageController controller) {
        if (!reflectionInitialized) {
            try {
                projectileClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityProjectile");
                fireballClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityFireball");
                arrowClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityArrow");
                worldClass = NMSUtils.getBukkitClass("net.minecraft.server.World");
                entityClass = NMSUtils.getBukkitClass("net.minecraft.server.Entity");
                craftArrowClass = NMSUtils.getBukkitClass("org.bukkit.craftbukkit.entity.CraftArrow");
                try {
                    try {
                        lifeField = arrowClass.getDeclaredField("ar");
                    }
                    catch (Throwable ignore3) {
                        try {
                            lifeField = arrowClass.getDeclaredField("ap");
                        }
                        catch (Throwable ignore2) {
                            try {
                                lifeField = arrowClass.getDeclaredField("at");
                            }
                            catch (Throwable ignore) {
                                lifeField = arrowClass.getDeclaredField("j");
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    lifeField = null;
                    controller.getLogger().log(Level.WARNING, "Failed to create short-lived arrow. Set tick_increase to 0 to avoid this message", ex);
                }
                if (lifeField != null) {
                    lifeField.setAccessible(true);
                }
            }
            catch (Throwable failure) {
                controller.getLogger().log(Level.WARNING, "Failed to bind to NMS projectile objects, ProjectileAction will not work", failure);
            }
            reflectionInitialized = true;
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.count = parameters.getInt("count", 1);
        this.undoInterval = parameters.getInt("undo_interval", 200);
        this.size = parameters.getInt("size", this.defaultSize);
        this.damage = parameters.getDouble("damage", 0.0);
        this.speed = (float)parameters.getDouble("speed", (double)0.6f);
        this.spread = (float)parameters.getDouble("spread", 12.0);
        this.useFire = parameters.getBoolean("fire", false);
        this.tickIncrease = parameters.getInt("tick_increase", 1180);
        this.projectileTypeName = parameters.getString("projectile", "Arrow");
        this.breakBlocks = parameters.getBoolean("break_blocks", true);
        this.startDistance = parameters.getInt("start", 0);
    }

    @Override
    public SpellResult perform(CastContext context) {
        MageController controller = context.getController();
        this.checkReflection(controller);
        Mage mage = context.getMage();
        int size = (int)(mage.getRadiusMultiplier() * (float)this.size);
        float damageMultiplier = mage.getDamageMultiplier();
        double damage = (double)damageMultiplier * this.damage;
        float spread = this.spread / damageMultiplier;
        Random random = context.getRandom();
        if (projectileClass == null || worldClass == null || fireballClass == null || arrowClass == null || craftArrowClass == null) {
            return SpellResult.FAIL;
        }
        Class<?> projectileType = NMSUtils.getBukkitClass("net.minecraft.server.Entity" + this.projectileTypeName);
        if (projectileType == null || !arrowClass.isAssignableFrom(projectileType) && !projectileClass.isAssignableFrom(projectileType) && !fireballClass.isAssignableFrom(projectileType)) {
            controller.getLogger().warning("Bad projectile class: " + this.projectileTypeName);
            return SpellResult.FAIL;
        }
        Constructor<?> constructor = null;
        Method shootMethod = null;
        Method setPositionRotationMethod = null;
        Field projectileSourceField = null;
        Field dirXField = null;
        Field dirYField = null;
        Field dirZField = null;
        Method addEntityMethod = null;
        try {
            constructor = projectileType.getConstructor(worldClass);
            if (fireballClass.isAssignableFrom(projectileType)) {
                dirXField = projectileType.getField("dirX");
                dirYField = projectileType.getField("dirY");
                dirZField = projectileType.getField("dirZ");
            }
            if (projectileClass.isAssignableFrom(projectileType) || arrowClass.isAssignableFrom(projectileType)) {
                shootMethod = projectileType.getMethod("shoot", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            }
            setPositionRotationMethod = projectileType.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            addEntityMethod = worldClass.getMethod("addEntity", entityClass);
            projectileSourceField = projectileType.getField("projectileSource");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return SpellResult.FAIL;
        }
        Location location = context.getEyeLocation();
        Vector direction = context.getDirection().normalize();
        if (this.startDistance > 0) {
            location = location.clone().add(direction.clone().multiply(this.startDistance));
        }
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        Object nmsWorld = NMSUtils.getHandle(location.getWorld());
        LivingEntity shootingEntity = context.getLivingEntity();
        LivingEntity source = null;
        if (shootingEntity != null && shootingEntity instanceof ProjectileSource) {
            source = shootingEntity;
        }
        for (int i = 0; i < this.count; ++i) {
            try {
                Projectile projectile;
                block30: {
                    Entity entity;
                    Object nmsProjectile = null;
                    nmsProjectile = constructor.newInstance(nmsWorld);
                    if (nmsProjectile == null) {
                        throw new Exception("Failed to spawn projectile of class " + this.projectileTypeName);
                    }
                    if (dirXField != null && dirYField != null && dirZField != null) {
                        double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                        double dx = (double)this.speed * (direction.getX() + random.nextGaussian() * spreadWeight);
                        double dy = (double)this.speed * (direction.getY() + random.nextGaussian() * spreadWeight);
                        double dz = (double)this.speed * (direction.getZ() + random.nextGaussian() * spreadWeight);
                        dirXField.set(nmsProjectile, dx * 0.1);
                        dirYField.set(nmsProjectile, dy * 0.1);
                        dirZField.set(nmsProjectile, dz * 0.1);
                    }
                    Vector modifiedLocation = location.toVector().clone();
                    if (i > 0 && fireballClass.isAssignableFrom(projectileType) && spread > 0.0f) {
                        modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                        modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                        modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
                    }
                    setPositionRotationMethod.invoke(nmsProjectile, modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                    if (shootMethod != null) {
                        shootMethod.invoke(nmsProjectile, direction.getX(), direction.getY(), direction.getZ(), Float.valueOf(this.speed), Float.valueOf(spread));
                    }
                    if ((entity = NMSUtils.getBukkitEntity(nmsProjectile)) == null || !(entity instanceof Projectile)) {
                        throw new Exception("Got invalid bukkit entity from projectile of class " + this.projectileTypeName);
                    }
                    projectile = (Projectile)entity;
                    if (shootingEntity != null) {
                        projectile.setShooter((ProjectileSource)shootingEntity);
                    }
                    if (source != null) {
                        Object projectileEntity = NMSUtils.getHandle((Entity)projectile);
                        projectileSourceField.set(projectileEntity, source);
                    }
                    projectiles.add(projectile);
                    addEntityMethod.invoke(nmsWorld, nmsProjectile);
                    if (projectile instanceof Fireball) {
                        Fireball fireball = (Fireball)projectile;
                        fireball.setIsIncendiary(this.useFire);
                        fireball.setYield((float)size);
                    }
                    if (projectile instanceof Arrow) {
                        Arrow arrow = (Arrow)projectile;
                        if (this.useFire) {
                            arrow.setFireTicks(300);
                        }
                        try {
                            if (arrowClass == null || craftArrowClass == null) {
                                controller.getLogger().warning("Can not access NMS EntityArrow class");
                                break block30;
                            }
                            Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                            Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                            Field fromPlayerField = arrowClass.getField("fromPlayer");
                            fromPlayerField.setInt(handle, 2);
                            if (damage > 0.0) {
                                Field damageField = arrowClass.getDeclaredField("damage");
                                damageField.setAccessible(true);
                                damageField.set(handle, damage);
                            }
                            if (lifeField == null) break block30;
                            try {
                                int currentLife = (Integer)lifeField.get(handle);
                                if (currentLife < this.tickIncrease) {
                                    lifeField.set(handle, this.tickIncrease);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                Collection<EffectPlayer> projectileEffects = context.getEffects("projectile");
                for (EffectPlayer effectPlayer : projectileEffects) {
                    effectPlayer.start(projectile.getLocation(), (Entity)projectile, null, null);
                }
                context.registerForUndo((Entity)projectile);
                if (this.breakBlocks) continue;
                projectile.setMetadata("cancel_explosion", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (projectiles.size() > 0) {
            this.registerProjectiles(projectiles, this.actions, context, this.parameters, this.undoInterval);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    protected void registerProjectiles(final Collection<Projectile> projectiles, ActionHandler actions, CastContext context, ConfigurationSection parameters, int undoInterval) {
        for (Projectile projectile : projectiles) {
            ActionHandler.setActions((Entity)projectile, actions, context, parameters, "indirect_player_message");
            ActionHandler.setEffects((Entity)projectile, context, "hit");
        }
        if (undoInterval > 0) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(context.getController().getPlugin(), new Runnable(){

                @Override
                public void run() {
                    ProjectileAction.this.checkProjectiles(projectiles);
                }
            }, (long)undoInterval);
        }
    }

    protected void checkProjectiles(Collection<Projectile> projectiles) {
        for (Projectile projectile : projectiles) {
            projectile.remove();
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("count");
        parameters.add("check_frequency");
        parameters.add("size");
        parameters.add("damage");
        parameters.add("speed");
        parameters.add("spread");
        parameters.add("start");
        parameters.add("projectile");
        parameters.add("fire");
        parameters.add("tick_increase");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("undo_interval")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("count") || parameterKey.equals("size") || parameterKey.equals("speed") || parameterKey.equals("spread") || parameterKey.equals("tick_increase") || parameterKey.equals("damage") || parameterKey.equals("start")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("fire")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("projectile")) {
            examples.add("LargeFireball");
            examples.add("SmallFireball");
            examples.add("WitherSkull");
            examples.add("Arrow");
            examples.add("Snowball");
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

