/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class DropSpell
extends BlockSpell {
    private static final int DEFAULT_MAX_RECURSION = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        Set<Material> dropMaterials = this.controller.getMaterialSet(parameters.getString("drop"));
        if (!dropMaterials.contains(target.getType())) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBreakPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int maxRecursion = parameters.getInt("recursion_depth", 16);
        this.drop(target, dropMaterials, drops, maxRecursion);
        for (ItemStack drop : drops) {
            target.getWorld().dropItemNaturally(target.getLocation(), drop);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void drop(Block block, Set<Material> dropTypes, Collection<ItemStack> drops, int maxRecursion) {
        this.drop(block, dropTypes, drops, maxRecursion, 0);
    }

    protected void drop(Block block, Set<Material> dropTypes, Collection<ItemStack> drops, int maxRecursion, int rDepth) {
        this.registerForUndo(block);
        drops.addAll(block.getDrops());
        block.setType(Material.AIR);
        if (rDepth < maxRecursion) {
            this.tryDrop(block.getRelative(BlockFace.NORTH), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.WEST), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.SOUTH), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.EAST), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.UP), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.DOWN), dropTypes, drops, maxRecursion, rDepth + 1);
        }
    }

    protected void tryDrop(Block target, Set<Material> dropTypes, Collection<ItemStack> drops, int maxRecursion, int rDepth) {
        if (!dropTypes.contains(target.getType()) || this.contains(target)) {
            return;
        }
        this.drop(target, dropTypes, drops, maxRecursion, rDepth);
    }
}

