/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BlockSpell
extends UndoableSpell {
    private Set<Material> indestructible;
    private Set<Material> destructible;
    protected boolean checkDestructible = true;
    public static final String[] BLOCK_PARAMETERS = new String[]{"indestructible", "destructible", "check_destructible", "bypass_undo", "undo"};

    public boolean isIndestructible(Block block) {
        if (this.mage.isSuperPowered()) {
            return false;
        }
        if (this.indestructible == null) {
            return this.mage.isIndestructible(block);
        }
        return this.indestructible.contains(block.getType()) || this.mage.isIndestructible(block);
    }

    public boolean isDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.targetBreakables > 0.0 && block.hasMetadata("breakable")) {
            return true;
        }
        if (this.destructible == null) {
            return this.mage.isDestructible(block);
        }
        return this.destructible.contains(block.getType());
    }

    public boolean areAnyDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.targetBreakables > 0.0 && block.hasMetadata("breakable")) {
            return true;
        }
        Set<Material> allDestructible = this.destructible;
        if (allDestructible == null) {
            allDestructible = this.controller.getDestructibleMaterials();
        }
        if (allDestructible == null) {
            return true;
        }
        if (allDestructible.contains(block.getType())) {
            return true;
        }
        BlockData blockData = UndoList.getBlockData(block.getLocation());
        return blockData != null && blockData.containsAny(allDestructible);
    }

    protected void setDestructible(Set<Material> materials) {
        this.checkDestructible = true;
        this.destructible = materials;
    }

    protected void addDestructible(Material material) {
        if (this.destructible == null) {
            this.destructible = new HashSet<Material>(this.controller.getDestructibleMaterials());
        }
        this.destructible.add(material);
    }

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.indestructible = null;
        if (parameters.contains("indestructible")) {
            this.indestructible = this.controller.getMaterialSet(parameters.getString("indestructible"));
        }
        if (parameters.contains("id")) {
            this.indestructible = this.controller.getMaterialSet(parameters.getString("id"));
        }
        this.destructible = null;
        if (parameters.contains("destructible")) {
            this.destructible = this.controller.getMaterialSet(parameters.getString("destructible"));
        }
        this.checkDestructible = parameters.getBoolean("check_destructible", true);
        this.checkDestructible = parameters.getBoolean("cd", this.checkDestructible);
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.getModifiedCount()));
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BLOCK_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("undo")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("indestructible") || parameterKey.equals("destructible")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("check_destructible") || parameterKey.equals("bypass_undo")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresBreakPermission() {
        return false;
    }
}

