/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.effect.EffectLibManager;
import com.elmakers.mine.bukkit.effect.EffectLibPlay;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class EffectPlayer
implements com.elmakers.mine.bukkit.api.effect.EffectPlayer {
    private static final String EFFECT_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.effect.builtin";
    private static final int PARTICLE_RANGE = 32;
    private static EffectLibManager effectLib = null;
    private ConfigurationSection effectLibConfig = null;
    private Collection<EffectPlay> currentEffects = null;
    public static boolean SOUNDS_ENABLED = true;
    protected Plugin plugin;
    protected Location origin;
    protected Location target;
    protected Vector originOffset;
    protected Vector targetOffset;
    protected WeakReference<Entity> originEntity;
    protected WeakReference<Entity> targetEntity;
    protected boolean playAtOrigin = true;
    protected boolean playAtTarget = false;
    protected boolean playAtAllTargets = false;
    protected Color color = null;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material;
    protected int delayTicks = 0;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material1;
    protected Color color1 = null;
    protected Color color2 = null;
    protected EntityEffect entityEffect = null;
    protected Effect effect = null;
    protected Integer effectData = null;
    protected Sound sound = null;
    protected String customSound = null;
    protected float soundVolume = 0.7f;
    protected float soundPitch = 1.5f;
    protected boolean hasFirework = false;
    protected FireworkEffect.Type fireworkType;
    protected int fireworkPower = 1;
    protected Boolean fireworkFlicker;
    protected FireworkEffect fireworkEffect;
    protected ParticleEffect particleType = null;
    protected ParticleEffect particleOverride = null;
    protected String useParticleOverride = null;
    protected String useColorOverride = null;
    protected String particleSubType = "";
    protected float particleData = 0.0f;
    protected float particleXOffset = 0.3f;
    protected float particleYOffset = 0.3f;
    protected float particleZOffset = 0.3f;
    protected int particleCount = 1;
    protected boolean useWandLocation = true;
    protected boolean useHitLocation = true;
    protected float scale = 1.0f;
    protected Vector offset = new Vector(0, 0, 0);

    public static boolean initialize(Plugin plugin) {
        effectLib = EffectLibManager.initialize(plugin);
        return effectLib != null;
    }

    public static void debugEffects(boolean debug) {
        if (effectLib != null) {
            effectLib.enableDebug(debug);
        }
    }

    public EffectPlayer() {
    }

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void load(Plugin plugin, ConfigurationSection configuration) {
        String typeName;
        String effectName;
        this.plugin = plugin;
        if (effectLib != null && configuration.contains("effectlib")) {
            this.effectLibConfig = configuration.getConfigurationSection("effectlib");
            if (this.effectLibConfig == null) {
                Object rawConfig = configuration.get("effectlib");
                if (rawConfig instanceof Map) {
                    this.effectLibConfig = new MemoryConfiguration();
                    Map map = (Map)rawConfig;
                    for (Map.Entry entry : map.entrySet()) {
                        this.effectLibConfig.set((String)entry.getKey(), entry.getValue());
                    }
                } else {
                    plugin.getLogger().warning("Could not load effectlib node of type " + rawConfig.getClass());
                }
            }
        } else {
            this.effectLibConfig = null;
        }
        this.useParticleOverride = configuration.getString("particle_override", null);
        this.useColorOverride = configuration.getString("color_override", null);
        this.originOffset = ConfigurationUtils.getVector(configuration, "origin_offset");
        this.targetOffset = ConfigurationUtils.getVector(configuration, "target_offset");
        this.delayTicks = configuration.getInt("delay", this.delayTicks) * 20 / 1000;
        this.material1 = ConfigurationUtils.getMaterialAndData(configuration, "material");
        this.color1 = ConfigurationUtils.getColor(configuration, "color", null);
        this.color2 = ConfigurationUtils.getColor(configuration, "color2", null);
        if (configuration.contains("effect")) {
            effectName = configuration.getString("effect");
            try {
                this.effect = Effect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.effect == null) {
                plugin.getLogger().warning("Unknown effect type " + effectName);
            } else {
                this.effectData = ConfigurationUtils.getInteger(configuration, "effect_data", this.effectData);
            }
        }
        if (configuration.contains("entity_effect")) {
            effectName = configuration.getString("entity_effect");
            try {
                this.entityEffect = EntityEffect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.entityEffect == null) {
                plugin.getLogger().warning("Unknown entity effect type " + effectName);
            }
        }
        if (configuration.contains("sound")) {
            String soundName = configuration.getString("sound");
            try {
                this.sound = Sound.valueOf((String)soundName.toUpperCase());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.sound == null) {
                plugin.getLogger().warning("Unknown sound type " + soundName);
            } else {
                this.soundVolume = (float)configuration.getDouble("sound_volume", (double)this.soundVolume);
                this.soundPitch = (float)configuration.getDouble("sound_pitch", (double)this.soundPitch);
            }
        }
        this.customSound = configuration.getString("custom_sound");
        if (configuration.contains("firework") || configuration.contains("firework_power")) {
            this.hasFirework = true;
            this.fireworkType = null;
            if (configuration.contains("firework")) {
                typeName = configuration.getString("firework");
                try {
                    this.fireworkType = FireworkEffect.Type.valueOf((String)typeName.toUpperCase());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.fireworkType == null) {
                    plugin.getLogger().warning("Unknown firework type " + typeName);
                }
            }
            this.fireworkPower = configuration.getInt("firework_power", this.fireworkPower);
            this.fireworkFlicker = ConfigurationUtils.getBoolean(configuration, "firework_flicker", this.fireworkFlicker);
        }
        if (configuration.contains("particle")) {
            typeName = configuration.getString("particle");
            try {
                this.particleType = ParticleEffect.valueOf(typeName.toUpperCase());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.particleType == null) {
                plugin.getLogger().warning("Unknown particle type " + typeName);
            } else {
                this.particleSubType = configuration.getString("particle_sub_type", this.particleSubType);
                this.particleData = (float)configuration.getDouble("particle_data", (double)this.particleData);
                this.particleXOffset = (float)configuration.getDouble("particle_offset_x", (double)this.particleXOffset);
                this.particleYOffset = (float)configuration.getDouble("particle_offset_y", (double)this.particleYOffset);
                this.particleZOffset = (float)configuration.getDouble("particle_offset_z", (double)this.particleZOffset);
                this.particleCount = configuration.getInt("particle_count", this.particleCount);
            }
        }
        this.setLocationType(configuration.getString("location", "origin"));
        this.useWandLocation = configuration.getBoolean("use_wand_location", true);
        this.useHitLocation = configuration.getBoolean("use_hit_location", true);
    }

    public void setLocationType(String locationType) {
        if (locationType.equals("target")) {
            this.playAtOrigin = false;
            this.playAtTarget = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("origin")) {
            this.playAtTarget = false;
            this.playAtOrigin = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("both")) {
            this.playAtTarget = true;
            this.playAtOrigin = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("targets")) {
            this.playAtTarget = true;
            this.playAtOrigin = false;
            this.playAtAllTargets = true;
        }
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Random rand = new Random();
        if (color1 == null) {
            color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (color2 == null) {
            color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setEntityEffect(EntityEffect entityEffect) {
        this.entityEffect = entityEffect;
    }

    public void setParticleType(ParticleEffect particleType) {
        this.particleType = particleType;
    }

    @Override
    public void setParticleOverride(String particleType) {
        if (particleType == null || particleType.isEmpty()) {
            this.particleOverride = null;
            return;
        }
        try {
            this.particleOverride = ParticleEffect.valueOf(particleType.toUpperCase());
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Error setting particle override: " + ex.getMessage());
            this.particleOverride = null;
        }
    }

    public void setParticleSubType(String particleSubType) {
        this.particleSubType = particleSubType;
    }

    @Override
    public void setEffectData(int data) {
        this.effectData = data;
    }

    protected com.elmakers.mine.bukkit.block.MaterialAndData getWorkingMaterial() {
        if (this.material1 != null) {
            return this.material1;
        }
        com.elmakers.mine.bukkit.block.MaterialAndData result = this.material;
        if (result == null && this.target != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(this.target.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null && this.origin != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(this.origin.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
        }
        return result;
    }

    protected void playEffect(Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity) {
        if (this.playAtOrigin && sourceLocation != null) {
            this.performEffect(sourceLocation, sourceEntity, targetLocation, targetEntity);
        }
        if (this.playAtTarget && targetLocation != null) {
            this.performEffect(targetLocation, targetEntity, sourceLocation, sourceEntity);
        }
    }

    private void performEffect(Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity) {
        if (this.offset != null) {
            if (sourceLocation != null) {
                sourceLocation = sourceLocation.clone();
                sourceLocation.add(this.offset);
            }
            if (targetLocation != null) {
                targetLocation = targetLocation.clone();
                targetLocation.add(this.offset);
            }
        }
        if (effectLib != null && this.effectLibConfig != null) {
            EffectLibPlay play = new EffectLibPlay(effectLib.play(this.effectLibConfig, this, sourceLocation, sourceEntity, targetLocation, targetEntity));
            if (this.currentEffects != null) {
                this.currentEffects.add(play);
            }
        }
        if (this.effect != null) {
            int data;
            int n = data = this.effectData == null ? 0 : this.effectData;
            if (this.effect == Effect.STEP_SOUND && this.effectData == null) {
                Material material = this.getWorkingMaterial().getMaterial();
                if (!material.isSolid()) {
                    return;
                }
                data = material.getId();
            }
            sourceLocation.getWorld().playEffect(sourceLocation, this.effect, data);
        }
        if (this.entityEffect != null && sourceEntity != null) {
            sourceEntity.playEffect(this.entityEffect);
        }
        if (this.sound != null) {
            sourceLocation.getWorld().playSound(sourceLocation, this.sound, this.soundVolume, this.soundPitch);
        }
        if (this.customSound != null) {
            double range = (double)this.soundVolume > 1.0 ? 16.0 * (double)this.soundVolume : 16.0;
            Collection<Player> players = CompatibilityUtils.getOnlinePlayers(this.plugin.getServer());
            for (Player player : players) {
                Location location = player.getLocation();
                if (!location.getWorld().equals(sourceLocation.getWorld()) || !(location.distanceSquared(sourceLocation) <= range)) continue;
                player.playSound(sourceLocation, this.customSound, this.soundVolume, this.soundPitch);
            }
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(this.plugin.getServer(), sourceLocation, this.fireworkEffect, this.fireworkPower);
        }
        if (this.particleType != null) {
            ParticleEffect useEffect = this.overrideParticle(this.particleType);
            ParticleEffect.ParticleData data = null;
            if ((useEffect == ParticleEffect.BLOCK_CRACK || useEffect == ParticleEffect.ITEM_CRACK || useEffect == ParticleEffect.BLOCK_DUST) && this.particleSubType.length() == 0) {
                Material material = this.getWorkingMaterial().getMaterial();
                data = useEffect == ParticleEffect.ITEM_CRACK ? new ParticleEffect.ItemData(material, this.getWorkingMaterial().getBlockData()) : new ParticleEffect.BlockData(material, this.getWorkingMaterial().getBlockData());
            }
            try {
                useEffect.display(data, sourceLocation, this.getColor1(), 32.0, this.particleXOffset, this.particleYOffset, this.particleZOffset, this.particleData, this.particleCount);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public ParticleEffect overrideParticle(ParticleEffect particle) {
        return this.useParticleOverride != null && !this.useParticleOverride.isEmpty() && this.particleOverride != null ? this.particleOverride : particle;
    }

    public String getParticleOverrideName() {
        return this.useParticleOverride;
    }

    public String getColorOverrideName() {
        return this.useColorOverride;
    }

    public void setParticleData(float effectData) {
        this.particleData = effectData;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.particleXOffset = xOffset;
        this.particleYOffset = yOffset;
        this.particleZOffset = zOffset;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void setSound(Sound sound) {
        this.sound = sound;
    }

    @Override
    public void setSound(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.soundVolume = volume;
        this.soundPitch = pitch;
    }

    @Override
    public void setDelayTicks(int ticks) {
        this.delayTicks = ticks;
    }

    @Override
    public void start(Entity originEntity, Entity targetEntity) {
        this.start(originEntity == null ? null : originEntity.getLocation(), originEntity, targetEntity == null ? null : targetEntity.getLocation(), targetEntity);
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity) {
        this.originEntity = new WeakReference<Entity>(originEntity);
        this.targetEntity = new WeakReference<Entity>(targetEntity);
        this.start(origin, target);
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity, Collection<Entity> targets) {
        if (this.shouldPlayAtAllTargets()) {
            this.start(origin, originEntity, targets);
        } else {
            this.start(origin, originEntity, target, targetEntity);
        }
    }

    public void start(Location origin, Entity originEntity, Collection<Entity> targets) {
        if (targets == null || targets.size() == 0) {
            return;
        }
        this.originEntity = new WeakReference<Entity>(originEntity);
        for (Entity targetEntity : targets) {
            if (targetEntity == null) continue;
            this.targetEntity = new WeakReference<Entity>(targetEntity);
            this.start(origin, targetEntity.getLocation());
        }
    }

    @Override
    public void start(Location origin, Location target) {
        this.startEffects(origin, target);
    }

    public void startEffects(Location origin, Location target) {
        if (target != null && origin != null && !origin.getWorld().equals(target.getWorld())) {
            target.setWorld(origin.getWorld());
        }
        this.origin = origin;
        this.target = target;
        this.fireworkEffect = this.hasFirework ? this.getFireworkEffect(this.getColor1(), this.getColor2(), this.fireworkType, this.fireworkFlicker, false) : null;
        if (this.delayTicks > 0 && this.plugin != null) {
            final EffectPlayer player = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.startPlay();
                }
            }, (long)this.delayTicks);
        } else {
            this.startPlay();
        }
    }

    protected void checkLocations() {
        if (this.origin != null && this.originOffset != null) {
            this.origin = this.origin.clone().add(this.originOffset);
        }
        if (this.target != null && this.targetOffset != null) {
            this.target = this.target.clone().add(this.targetOffset);
        }
    }

    protected void startPlay() {
        this.checkLocations();
        this.play();
    }

    protected Vector getDirection() {
        if (this.origin == null) {
            return new Vector(0, 1, 0);
        }
        Vector direction = this.target == null ? this.origin.getDirection() : this.target.toVector().subtract(this.origin.toVector());
        return direction.normalize();
    }

    @Override
    public void setMaterial(MaterialAndData material) {
        this.material = new com.elmakers.mine.bukkit.block.MaterialAndData(material);
    }

    @Override
    public void setMaterial(Block block) {
        this.material = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor1() {
        return this.color1 != null ? this.color1 : this.color;
    }

    public Color getColor2() {
        return this.color2 != null ? this.color2 : this.color;
    }

    @Override
    public void setOffset(float x, float y, float z) {
        this.offset.setX(x);
        this.offset.setY(y);
        this.offset.setZ(z);
    }

    public abstract void play();

    public Entity getOriginEntity() {
        return this.originEntity == null ? null : (Entity)this.originEntity.get();
    }

    public Entity getTargetEntity() {
        return this.targetEntity == null ? null : (Entity)this.targetEntity.get();
    }

    public void cancel() {
        if (this.currentEffects != null) {
            for (EffectPlay effect : this.currentEffects) {
                effect.cancel();
            }
            this.currentEffects.clear();
        }
    }

    public static Collection<EffectPlayer> loadEffects(Plugin plugin, ConfigurationSection root, String key) {
        ArrayList<EffectPlayer> players = new ArrayList<EffectPlayer>();
        Collection<ConfigurationSection> effectNodes = ConfigurationUtils.getNodeList(root, key);
        if (effectNodes != null) {
            for (ConfigurationSection effectValues : effectNodes) {
                if (!effectValues.contains("class")) continue;
                String effectClass = effectValues.getString("class");
                try {
                    Class<?> genericClass;
                    if (!effectClass.contains(".")) {
                        effectClass = "com.elmakers.mine.bukkit.effect.builtin." + effectClass;
                    }
                    if (!EffectPlayer.class.isAssignableFrom(genericClass = Class.forName(effectClass))) {
                        throw new Exception("Must extend EffectPlayer");
                    }
                    Class<?> playerClass = genericClass;
                    EffectPlayer player = (EffectPlayer)playerClass.newInstance();
                    player.load(plugin, effectValues);
                    players.add(player);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    plugin.getLogger().info("Error creating effect class: " + effectClass + " " + ex.getMessage());
                }
            }
        }
        return players;
    }

    public boolean shouldPlayAtAllTargets() {
        return this.playAtAllTargets;
    }

    @Override
    public void setEffectPlayList(Collection<EffectPlay> plays) {
        this.currentEffects = plays;
    }

    @Override
    public boolean shouldUseHitLocation() {
        return this.useHitLocation;
    }

    @Override
    public boolean shouldUseWandLocation() {
        return this.useWandLocation;
    }
}

