/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.spell.Spell;

public class ActionBatch
implements SpellBatch {
    private final int actionCount;
    private final CastContext context;
    private final ActionHandler handler;

    public ActionBatch(CastContext context, ActionHandler handler) {
        this.context = context;
        this.handler = (ActionHandler)handler.clone();
        this.actionCount = handler.getActionCount();
    }

    @Override
    public int process(int maxBlocks) {
        this.context.setWorkAllowed(maxBlocks);
        this.handler.perform(this.context);
        if (this.handler.isFinished()) {
            this.handler.finish(this.context);
            this.context.finish();
        }
        return maxBlocks - this.context.getWorkAllowed();
    }

    @Override
    public boolean isFinished() {
        return this.handler.isFinished();
    }

    @Override
    public void finish() {
        this.handler.cancel(this.context);
        this.handler.finish(this.context);
        this.context.finish();
    }

    @Override
    public int size() {
        return this.actionCount;
    }

    @Override
    public int remaining() {
        return Math.max(0, this.actionCount - this.context.getActionsPerformed());
    }

    @Override
    public Spell getSpell() {
        return this.context.getSpell();
    }
}

