/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class BrushAction
extends CompoundAction {
    private List<MaterialBrush> brushes = new ArrayList<MaterialBrush>();
    private boolean sample = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        List brushList;
        super.prepare(context, parameters);
        this.brushes.clear();
        Mage mage = context.getMage();
        Location location = context.getLocation();
        String materialKey = parameters.getString("brush", null);
        if (materialKey != null) {
            this.addBrush(mage, location, materialKey);
        }
        if ((brushList = parameters.getStringList("brushes")) != null) {
            for (String brushKey : brushList) {
                this.addBrush(mage, location, brushKey);
            }
        }
        this.sample = parameters.getBoolean("sample");
    }

    protected void addBrush(Mage mage, Location location, String brushKey) {
        this.brushes.add(new MaterialBrush(mage, location, brushKey));
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.brushes.size() == 0 && !this.sample) {
            return super.perform(context);
        }
        this.createActionContext(context);
        if (this.sample) {
            Block targetBlock = context.getTargetBlock();
            if (targetBlock != null) {
                Mage mage = context.getMage();
                MaterialBrush brush = new MaterialBrush(mage, targetBlock);
                this.actionContext.setBrush(brush);
            }
        } else {
            MaterialBrush brush = this.brushes.get(context.getRandom().nextInt(this.brushes.size()));
            this.actionContext.setBrush(brush);
        }
        return super.perform(this.actionContext);
    }

    @Override
    public boolean usesBrush() {
        return false;
    }
}

