/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.logging.Level;
import net.dandielo.citizens.traders_v3.core.exceptions.InvalidItemException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeInvalidValueException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Attribute(name="Magic Wand", key="magic_wand", priority=5)
public class WandAttr
extends ItemAttr {
    private String wandData;

    public WandAttr(String key) {
        super(key);
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        MagicAPI api = MagicPlugin.getAPI();
        if (!api.isWand(itemStack)) {
            throw new AttributeValueNotFoundException();
        }
        Wand wand = new Wand(TradersController.getController(), itemStack);
        YamlConfiguration saveData = new YamlConfiguration();
        wand.saveProperties((ConfigurationSection)saveData);
        this.wandData = saveData.saveToString();
        this.item.addFlag(".nostack");
    }

    public void onLoad(String itemData) throws AttributeInvalidValueException {
        if (itemData == null || itemData.isEmpty()) {
            throw new AttributeInvalidValueException(this.info, "No data");
        }
        this.wandData = itemData.replace("{sp}", " ").replace("{co}", ":").replace("{cr}", "\n");
    }

    public String onSave() {
        if (this.wandData == null) {
            this.wandData = "";
        }
        String escaped = this.wandData.replace(" ", "{sp}").replace(":", "{co}").replace("\n", "{cr}");
        return escaped;
    }

    public void onAssign(ItemStack itemStack) throws InvalidItemException {
        this.onReturnAssign(itemStack, false);
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        if (this.wandData != null && !this.wandData.isEmpty()) {
            Wand wand = Wand.createWand(TradersController.getController(), itemStack);
            YamlConfiguration saveData = new YamlConfiguration();
            try {
                ItemMeta meta = itemStack.getItemMeta();
                saveData.loadFromString(this.wandData);
                wand.loadProperties((ConfigurationSection)saveData);
                wand.save();
                itemStack = wand.getItem();
                if (!endItem && meta != null) {
                    ItemMeta newMeta = itemStack.getItemMeta();
                    newMeta.setLore(meta.getLore());
                    itemStack.setItemMeta(newMeta);
                }
            }
            catch (InvalidConfigurationException ex) {
                TradersController.getController().getLogger().log(Level.WARNING, "Error deserializing wand data", ex);
            }
        }
        return itemStack;
    }

    public boolean equalsWeak(ItemAttr other) {
        if (other instanceof WandAttr) {
            return this.wandData.equals(((WandAttr)other).wandData);
        }
        return false;
    }

    public boolean equalsStrong(ItemAttr other) {
        if (other instanceof WandAttr) {
            return this.wandData.equals(((WandAttr)other).wandData);
        }
        return false;
    }
}

