/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;

public class GrowSpell
extends BlockSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasEntity()) {
            return SpellResult.NO_TARGET;
        }
        Entity targetEntity = target.getEntity();
        if (this.controller.isElemental(targetEntity)) {
            double elementalSize = this.controller.getElementalScale(targetEntity);
            this.controller.setElementalScale(targetEntity, elementalSize *= 1.2);
            return SpellResult.CAST;
        }
        if (!(targetEntity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity li = (LivingEntity)targetEntity;
        if (li instanceof Ageable && !((Ageable)li).isAdult() && !(li instanceof Player)) {
            this.registerModified((Entity)li);
            ((Ageable)li).setAdult();
        } else if (li instanceof Zombie) {
            this.registerModified((Entity)li);
            Zombie zombie = (Zombie)li;
            if (!zombie.isBaby()) {
                Location targetLocation = li.getLocation();
                li.remove();
                Entity giant = targetLocation.getWorld().spawnEntity(targetLocation, EntityType.GIANT);
                this.registerForUndo(giant);
            } else {
                ((Zombie)li).setBaby(false);
            }
        } else if (li instanceof PigZombie && ((PigZombie)li).isBaby()) {
            this.registerModified((Entity)li);
            ((PigZombie)li).setBaby(false);
        } else if (li instanceof Slime) {
            this.registerModified((Entity)li);
            Slime slime = (Slime)li;
            slime.setSize(slime.getSize() + 1);
        } else {
            return SpellResult.NO_TARGET;
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

