/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.FillBatch;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class FillSpell
extends BrushSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean singleBlock;
        Block targetBlock = this.getTargetBlock();
        boolean bl = singleBlock = this.getTargetType() != TargetType.SELECT;
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getBrush();
        if (singleBlock) {
            this.deactivate();
            if (this.isIndestructible(targetBlock)) {
                return SpellResult.NO_TARGET;
            }
            this.registerForUndo(targetBlock);
            buildWith.setTarget(targetBlock.getLocation());
            buildWith.update(this.mage, targetBlock.getLocation());
            buildWith.modify(targetBlock);
            this.controller.updateBlock(targetBlock);
            this.registerForUndo();
            return SpellResult.CAST;
        }
        if (this.targetLocation2 != null) {
            this.targetBlock = this.targetLocation2.getBlock();
        }
        if (this.targetBlock != null) {
            Location centerLocation = targetBlock.getLocation();
            Location secondLocation = this.targetBlock.getLocation();
            centerLocation.setX(Math.floor((centerLocation.getX() + secondLocation.getX()) / 2.0));
            centerLocation.setY(Math.floor((centerLocation.getY() + secondLocation.getY()) / 2.0));
            centerLocation.setZ(Math.floor((centerLocation.getZ() + secondLocation.getZ()) / 2.0));
            buildWith.setTarget(this.targetBlock.getLocation(), centerLocation);
            FillBatch batch = new FillBatch(this, secondLocation, targetBlock.getLocation(), buildWith);
            int maxDimension = parameters.getInt("max_dimension", 128);
            maxDimension = parameters.getInt("md", maxDimension);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                return SpellResult.FAIL;
            }
            boolean success = this.mage.addBatch(batch);
            this.deactivate();
            return success ? SpellResult.CAST : SpellResult.FAIL;
        }
        this.targetBlock = targetBlock;
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.targetBlock = null;
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }
}

