/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class GridLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int rows = 5;
    public int columns = 10;
    public float widthCell = 1.0f;
    public float heightCell = 1.0f;
    public int particlesWidth = 4;
    public int particlesHeight = 3;
    public double rotation = 0.0;

    public GridLocationEffect(EffectManager effectManager, Location location) {
        super(effectManager, location);
        this.type = EffectType.INSTANT;
        this.period = 5;
        this.iterations = 50;
    }

    @Override
    public void onRun() {
        int j;
        int i;
        Vector v = new Vector();
        for (i = 0; i <= this.rows + 1; ++i) {
            for (j = 0; j < this.particlesWidth * (this.columns + 1); ++j) {
                v.setY((float)i * this.heightCell);
                v.setX((float)j * this.widthCell / (float)this.particlesWidth);
                this.addParticle(v);
            }
        }
        for (i = 0; i <= this.columns + 1; ++i) {
            for (j = 0; j < this.particlesHeight * (this.rows + 1); ++j) {
                v.setX((float)i * this.widthCell);
                v.setY((float)j * this.heightCell / (float)this.particlesHeight);
                this.addParticle(v);
            }
        }
    }

    protected void addParticle(Vector v) {
        v.setZ(0);
        VectorUtils.rotateAroundAxisY(v, this.rotation);
        this.location.add(v);
        this.particle.display(this.location, (double)this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 0);
        this.location.subtract(v);
    }
}

