/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import java.lang.reflect.Method;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LocketteManager {
    private boolean enabled = false;
    private Method isOwnerMethod = null;
    private Method isProtectedMethod = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.isOwnerMethod != null && this.isProtectedMethod != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            Plugin lockettePlugin = plugin.getServer().getPluginManager().getPlugin("Lockette");
            if (lockettePlugin != null) {
                try {
                    Class<?> locketteClass = Class.forName("org.yi.acru.bukkit.Lockette.Lockette");
                    this.isOwnerMethod = locketteClass.getMethod("isOwner", Block.class, String.class);
                    this.isProtectedMethod = locketteClass.getMethod("isProtected", Block.class);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                if (this.isOwnerMethod == null || this.isProtectedMethod == null) {
                    plugin.getLogger().info("Lockette integration failed, will not integrate.");
                } else {
                    plugin.getLogger().info("Lockette found, will check block protection.");
                }
            } else {
                plugin.getLogger().info("Lockette not found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("Lockette integration disabled");
        }
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.isOwnerMethod != null && this.isProtectedMethod != null) {
            try {
                if (player == null) {
                    return (Boolean)this.isProtectedMethod.invoke(null, block);
                }
                return (Boolean)this.isOwnerMethod.invoke(null, block, player.getName());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

