/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Schematic
implements com.elmakers.mine.bukkit.api.block.Schematic {
    private final Vector size;
    private final Vector center;
    private final com.elmakers.mine.bukkit.api.block.MaterialAndData[][][] blocks;
    private final Collection<com.elmakers.mine.bukkit.api.entity.EntityData> entities;
    private final Vector offset;
    private final Vector origin;

    public Schematic(short width, short height, short length, short[] blockTypes, byte[] data, Collection<Object> tileEntityData, Collection<Object> entityData, Vector origin, Vector offset) {
        this.size = new Vector(width, height, length);
        this.center = new Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
        this.blocks = new com.elmakers.mine.bukkit.api.block.MaterialAndData[width][height][length];
        this.entities = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
        this.origin = origin;
        this.offset = offset;
        for (Object entity : entityData) {
            String type = NMSUtils.getMeta(entity, "id");
            Vector position = NMSUtils.getPosition(entity, "Pos");
            position = position.subtract(origin).subtract(this.center);
            if (type == null || position == null) continue;
            if (type.equals("Painting")) {
                String motive = NMSUtils.getMeta(entity, "Motive");
                motive = motive.toLowerCase();
                Art art = Art.ALBAN;
                for (Art test : Art.values()) {
                    if (!test.name().toLowerCase().replace("_", "").equals(motive)) continue;
                    art = test;
                    break;
                }
                byte facing = NMSUtils.getMetaByte(entity, "Facing");
                EntityData painting = EntityData.loadPainting(position, art, this.getFacing(facing));
                this.entities.add(painting);
                continue;
            }
            if (!type.equals("ItemFrame")) continue;
            byte facing = NMSUtils.getMetaByte(entity, "Facing");
            byte rotation = NMSUtils.getMetaByte(entity, "ItemRotation");
            Rotation rot = Rotation.NONE;
            if (rotation < Rotation.values().length) {
                rot = Rotation.values()[rotation];
            }
            ItemStack item = NMSUtils.getItem(NMSUtils.getNode(entity, "Item"));
            EntityData itemFrame = EntityData.loadItemFrame(position, item, this.getFacing(facing), rot);
            this.entities.add(itemFrame);
        }
        HashMap<BlockVector, Object> tileEntityMap = new HashMap<BlockVector, Object>();
        for (Object tileEntity : tileEntityData) {
            try {
                Integer x = NMSUtils.getMetaInt(tileEntity, "x");
                Integer y = NMSUtils.getMetaInt(tileEntity, "y");
                Integer z = NMSUtils.getMetaInt(tileEntity, "z");
                if (x == null || y == null || z == null) continue;
                BlockVector location = new BlockVector(x.intValue(), y.intValue(), z.intValue());
                tileEntityMap.put(location, tileEntity);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    int index = x + (y * length + z) * width;
                    Material material = null;
                    try {
                        material = Material.getMaterial((int)blockTypes[index]);
                    }
                    catch (Exception ex) {
                        material = null;
                        ex.printStackTrace();
                    }
                    if (material == null) continue;
                    MaterialAndData block = new MaterialAndData(material, data[index]);
                    BlockVector blockLocation = new BlockVector(x, y, z);
                    Object tileEntity = tileEntityMap.get(blockLocation);
                    if (tileEntity != null) {
                        try {
                            if (material == Material.COMMAND) {
                                String customName = NMSUtils.getMeta(tileEntity, "CustomName");
                                if (!customName.isEmpty()) {
                                    block.setCustomName(customName);
                                }
                                block.setCommandLine(NMSUtils.getMeta(tileEntity, "Command"));
                            } else {
                                block.setRawData(tileEntity);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.blocks[x][y][z] = block;
                }
            }
        }
    }

    protected BlockFace getFacing(byte dir) {
        switch (dir) {
            case 0: {
                return BlockFace.SOUTH;
            }
            case 1: {
                return BlockFace.WEST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.UP;
    }

    @Override
    public boolean contains(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.MaterialAndData getBlock(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        if (x < 0 || x >= this.blocks.length || y < 0 || y >= this.blocks[x].length || z < 0 || z >= this.blocks[x][y].length) {
            return null;
        }
        return this.blocks[x][y][z];
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities(Location center) {
        ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData> translated = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
        for (com.elmakers.mine.bukkit.api.entity.EntityData data : this.entities) {
            com.elmakers.mine.bukkit.api.entity.EntityData relative = data == null ? null : data.getRelativeTo(center);
            if (relative == null) continue;
            translated.add(relative);
        }
        return translated;
    }

    @Override
    public Vector getSize() {
        return this.size;
    }
}

