/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HatAction
extends BaseSpellAction {
    private MaterialAndData material;
    private boolean useItem;
    private Map<Enchantment, Integer> enchantments;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("enchantments")) {
            this.enchantments = new HashMap<Enchantment, Integer>();
            ConfigurationSection enchantConfig = parameters.getConfigurationSection("enchantments");
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                try {
                    Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                    this.enchantments.put(enchantment, enchantConfig.getInt(enchantKey));
                }
                catch (Exception ex) {
                    spell.getController().getLogger().warning("Invalid enchantment: " + enchantKey);
                }
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.material = ConfigurationUtils.getMaterialAndData(parameters, "material");
        this.useItem = parameters.getBoolean("use_item", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        ItemStack itemStack;
        Material baseMaterial;
        Block targetBlock;
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            entity = context.getEntity();
        }
        if (entity == null || !(entity instanceof Player)) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        MaterialAndData material = this.material;
        com.elmakers.mine.bukkit.api.magic.Mage mage = context.getMage();
        if (this.useItem) {
            ItemStack itemInHand;
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.deactivate();
            }
            if ((itemInHand = player.getItemInHand()) == null || itemInHand.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            ItemStack currentItem = player.getInventory().getHelmet();
            player.getInventory().setHelmet(itemInHand);
            player.setItemInHand(currentItem);
            if (mage instanceof Mage) {
                ((Mage)mage).armorUpdated();
            }
            return SpellResult.CAST;
        }
        if (material == null && (context.getSpell().usesBrush() || context.getSpell().hasBrushOverride())) {
            material = context.getBrush();
        }
        if (material == null && (targetBlock = context.getTargetBlock()) != null && ((baseMaterial = (material = new com.elmakers.mine.bukkit.block.MaterialAndData(targetBlock)).getMaterial()).getId() == 176 || baseMaterial.getId() == 177)) {
            ((com.elmakers.mine.bukkit.block.MaterialAndData)material).setMaterialId(425);
        }
        if (entity == null || !(entity instanceof Player) || material == null || material.getMaterial() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        ItemStack hatItem = material.getItemStack(1);
        ItemMeta meta = hatItem.getItemMeta();
        String hatName = context.getMessage("hat_name", "");
        String materialName = material.getName();
        if (materialName == null || materialName.isEmpty()) {
            materialName = "?";
        }
        if (hatName != null && !hatName.isEmpty()) {
            meta.setDisplayName(hatName.replace("$hat", materialName));
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(context.getMessage("hat_lore"));
        meta.setLore(lore);
        hatItem.setItemMeta(meta);
        hatItem = InventoryUtils.makeReal(hatItem);
        NMSUtils.makeTemporary(hatItem, context.getMessage("removed").replace("$hat", materialName));
        if (this.enchantments != null) {
            hatItem.addUnsafeEnchantments(this.enchantments);
        }
        if ((itemStack = player.getInventory().getHelmet()) != null && itemStack.getType() != Material.AIR) {
            if (NMSUtils.isTemporary(itemStack)) {
                itemStack = NMSUtils.getReplacement(itemStack);
            }
            if (itemStack != null) {
                NMSUtils.setReplacement(hatItem, itemStack);
            }
        }
        player.getInventory().setHelmet(hatItem);
        context.registerForUndo(new HatUndoAction(mage));
        if (mage instanceof Mage) {
            ((Mage)mage).armorUpdated();
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("material");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("material")) {
            examples.addAll(MagicPlugin.getAPI().getBrushes());
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class HatUndoAction
    implements Runnable {
        private final com.elmakers.mine.bukkit.api.magic.Mage mage;

        public HatUndoAction(com.elmakers.mine.bukkit.api.magic.Mage mage) {
            this.mage = mage;
        }

        @Override
        public void run() {
            Player player = this.mage.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack helmetItem = player.getInventory().getHelmet();
            if (NMSUtils.isTemporary(helmetItem)) {
                ItemStack replacement = NMSUtils.getReplacement(helmetItem);
                player.getInventory().setHelmet(replacement);
            }
            if (this.mage instanceof Mage) {
                ((Mage)this.mage).armorUpdated();
            }
        }
    }
}

