/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class HeroesSkillsSelector
implements GUIAction {
    private int page;
    private List<String> allSkills;
    private final MagicAPI api;
    private final Player player;

    public HeroesSkillsSelector(MagicAPI api, Player player) {
        this.api = api;
        this.player = player;
    }

    public void show(int page) {
        this.page = page;
        MageController apiController = this.api.getController();
        if (!(apiController instanceof MagicController)) {
            return;
        }
        MagicController controller = (MagicController)apiController;
        HeroesManager heroes = controller.getHeroes();
        if (heroes == null) {
            this.player.sendMessage(ChatColor.RED + "This command requires Heroes");
            return;
        }
        this.allSkills = heroes.getSkillList(this.player, true, true);
        if (this.allSkills.size() == 0) {
            this.player.sendMessage(ChatColor.RED + "You have no skills");
            return;
        }
        this.openInventory();
    }

    protected void openInventory() {
        MageController apiController = this.api.getController();
        if (!(apiController instanceof MagicController)) {
            return;
        }
        MagicController controller = (MagicController)apiController;
        HeroesManager heroes = controller.getHeroes();
        if (heroes == null) {
            return;
        }
        int inventorySize = 9 * controller.getSkillInventoryRows();
        int numPages = (int)Math.ceil((float)this.allSkills.size() / (float)inventorySize);
        if (this.page < 1) {
            this.page = numPages;
        } else if (this.page > numPages) {
            this.page = 1;
        }
        Mage mage = controller.getMage(this.player);
        int pageIndex = this.page - 1;
        int startIndex = pageIndex * inventorySize;
        int maxIndex = (pageIndex + 1) * inventorySize - 1;
        ArrayList<String> skills = new ArrayList<String>();
        for (int i = startIndex; i <= maxIndex && i < this.allSkills.size(); ++i) {
            skills.add(this.allSkills.get(i));
        }
        if (skills.size() == 0) {
            this.player.sendMessage(ChatColor.RED + "No skills on page " + this.page);
            return;
        }
        String classString = heroes.getClassName(this.player);
        String class2String = heroes.getSecondaryClassName(this.player);
        String messageKey = class2String != null && !class2String.isEmpty() ? "skills.inventory_title_secondary" : "skills.inventory_title";
        String inventoryTitle = this.api.getMessages().get(messageKey, "Skills ($page/$pages)");
        inventoryTitle = inventoryTitle.replace("$pages", Integer.toString(numPages)).replace("$page", Integer.toString(this.page)).replace("$class2", class2String).replace("$class", classString);
        int invSize = (int)Math.ceil((float)skills.size() / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (String skill : skills) {
            ItemStack skillItem = this.api.createItem("skill:heroes*" + skill, mage);
            if (skillItem == null) continue;
            if (!heroes.canUseSkill(this.player, skill)) {
                String nameTemplate = controller.getMessages().get("skills.item_name_unavailable", "$skill");
                CompatibilityUtils.setDisplayName(skillItem, nameTemplate.replace("$skill", skill));
                InventoryUtils.setCount(skillItem, 0);
            }
            displayInventory.addItem(new ItemStack[]{skillItem});
        }
        mage.deactivateGUI();
        mage.activateGUI(this);
        this.player.openInventory(displayInventory);
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.NOTHING) {
            int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
            this.page += direction;
            this.openInventory();
            event.setCancelled(true);
            return;
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
    }
}

