/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

@Deprecated
public class FlingSpell
extends UndoableSpell
implements Listener {
    private long safetyLength = 20000L;
    private long lastFling = 0L;
    protected int defaultMaxSpeedAtElevation = 64;
    protected double defaultMinMagnitude = 1.5;
    protected double defaultMaxMagnitude = 4.0;
    private static final int minRingEffectRange = 2;
    private static final int maxRingEffectRange = 15;
    private static final int maxDamageAmount = 200;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        int height;
        Block playerBlock = this.getLocation().getBlock();
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return SpellResult.LIVING_ENTITY_REQUIRED;
        }
        int maxSpeedAtElevation = parameters.getInt("cruising_altitude", this.defaultMaxSpeedAtElevation);
        double minMagnitude = parameters.getDouble("min_speed", this.defaultMinMagnitude);
        double maxMagnitude = parameters.getDouble("max_speed", this.defaultMaxMagnitude);
        this.safetyLength = parameters.getLong("safety", this.safetyLength);
        for (height = 0; height < maxSpeedAtElevation && playerBlock.getType() == Material.AIR; ++height) {
            playerBlock = playerBlock.getRelative(BlockFace.DOWN);
        }
        double heightModifier = maxSpeedAtElevation > 0 ? (double)height / (double)maxSpeedAtElevation : 1.0;
        double magnitude = minMagnitude + (maxMagnitude - minMagnitude) * heightModifier;
        Vector velocity = this.getDirection();
        if (this.mage.getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        }
        velocity.multiply(magnitude);
        this.registerVelocity((Entity)entity);
        this.registerMoved((Entity)entity);
        entity.setVelocity(velocity);
        if (this.safetyLength > 0L) {
            this.mage.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        }
        this.lastFling = System.currentTimeMillis();
        this.registerForUndo();
        return SpellResult.CAST;
    }

    @Override
    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.mage.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.lastFling == 0L) {
            return;
        }
        if (this.lastFling + this.safetyLength > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastFling = 0L;
            int ringEffectRange = (int)Math.ceil(13.0 * event.getDamage() / 200.0 + 2.0);
            ringEffectRange = Math.min(15, ringEffectRange);
            this.playEffects("land", ringEffectRange);
        }
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.add("cruising_altitude");
        parameters.add("min_speed");
        parameters.add("max_speed");
        parameters.add("safety");
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.MaterialAndData getEffectMaterial() {
        Block block = this.mage.getEntity().getLocation().getBlock();
        block = block.getRelative(BlockFace.DOWN);
        return new MaterialAndData(block);
    }
}

