/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PreciousStonesManager {
    private boolean enabled = false;
    private boolean override = true;
    private PreciousStones preciousStones = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isEnabled() {
        return this.enabled && this.preciousStones != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin psPlugin = plugin.getServer().getPluginManager().getPlugin("PreciousStones");
                if (psPlugin instanceof PreciousStones) {
                    this.preciousStones = (PreciousStones)psPlugin;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.preciousStones == null) {
                plugin.getLogger().info("PreciousStones not found, region protection and pvp checks will not be used.");
            } else {
                plugin.getLogger().info("PreciousStones found, will respect build permissions for construction spells");
            }
        } else {
            plugin.getLogger().info("PreciousStones manager disabled, region protection and pvp checks will not be used.");
            this.preciousStones = null;
        }
    }

    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || this.preciousStones == null || location == null) {
            return true;
        }
        List fields = PreciousStones.API().getFieldsProtectingArea(FieldFlag.PREVENT_PVP, location);
        return fields.size() == 0;
    }

    public boolean hasBuildPermission(Player player, Block block) {
        boolean allowed = true;
        if (this.enabled && block != null && this.preciousStones != null) {
            Location location = block.getLocation();
            if (PreciousStones.API().isFieldProtectingArea(FieldFlag.ALL, location)) {
                if (player == null) {
                    return false;
                }
                allowed = allowed && PreciousStones.API().canBreak(player, location);
                allowed = allowed && PreciousStones.API().canPlace(player, location);
                return allowed;
            }
        }
        return allowed;
    }

    public Boolean getCastPermission(Player player, SpellTemplate spell, Location location) {
        Boolean overridePermission = null;
        if (this.override && this.enabled && location != null && this.preciousStones != null && PreciousStones.API().isFieldProtectingArea(FieldFlag.ALL, location)) {
            if (player == null) {
                return null;
            }
            if (PreciousStones.API().canBreak(player, location) && PreciousStones.API().canPlace(player, location)) {
                overridePermission = true;
            }
        }
        return overridePermission;
    }
}

