/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.maps.URLMap;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class MagicMapExecutor
extends MagicTabExecutor {
    public MagicMapExecutor(MagicAPI api) {
        super(api);
    }

    protected void onMapList(CommandSender sender, String keyword) {
        Pattern pattern = null;
        boolean positive = true;
        if (!keyword.isEmpty()) {
            if (keyword.startsWith("-")) {
                keyword = keyword.substring(1);
                positive = false;
            }
            pattern = Pattern.compile(keyword);
        }
        int shown = 0;
        boolean limited = false;
        Collection<URLMap> maps = this.api.getController().getMaps().getAll();
        for (URLMap map : maps) {
            Matcher matcher;
            Short mapId = map.getId();
            if (map == null || mapId == null) continue;
            String source = map.getName() + " " + map.getURL() + " " + map.getId();
            Matcher matcher2 = matcher = pattern == null ? null : pattern.matcher(source);
            if (matcher != null && matcher.find() != positive) continue;
            String name = map.getName();
            name = name == null ? "(None)" : name;
            sender.sendMessage(ChatColor.AQUA + "" + mapId + ChatColor.WHITE + ": " + name + " => " + ChatColor.GRAY + map.getURL());
            if (++shown <= 100) continue;
            limited = true;
            break;
        }
        if (shown == 0) {
            sender.sendMessage("No maps found" + (keyword.length() > 0 ? " matching " + keyword : "") + ", use /mmap load to add more maps");
        } else if (keyword.isEmpty()) {
            if (limited) {
                sender.sendMessage("Results limited to 100, use /mmap list <keyword> to narrow your search");
            } else {
                sender.sendMessage(shown + " maps found");
            }
        } else {
            String limitedMessage = limited ? " (+ more)" : "";
            sender.sendMessage(shown + " maps found matching " + keyword + limitedMessage);
        }
    }
}

