/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public abstract class CompoundEntityAction
extends CompoundAction {
    protected boolean targetSelf;
    private List<WeakReference<Entity>> entities = new ArrayList<WeakReference<Entity>>();
    private int currentEntity = 0;

    public abstract void addEntities(CastContext var1, List<WeakReference<Entity>> var2);

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetSelf = parameters.getBoolean("target_self", false);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentEntity = 0;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.currentEntity == 0) {
            this.entities.clear();
            this.addEntities(context, this.entities);
        }
        SpellResult result = SpellResult.NO_TARGET;
        while (this.currentEntity < this.entities.size()) {
            Entity entity = (Entity)this.entities.get(this.currentEntity).get();
            if (entity == null) {
                ++this.currentEntity;
                this.skippedActions(context);
                continue;
            }
            this.actionContext.setTargetEntity(entity);
            this.actionContext.setTargetLocation(entity.getLocation());
            SpellResult entityResult = super.perform(this.actionContext);
            result = result.min(entityResult);
            if (entityResult == SpellResult.PENDING) break;
            ++this.currentEntity;
            if (this.currentEntity >= this.entities.size()) continue;
            super.reset(context);
        }
        return result;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_self");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_self")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public Object clone() {
        CompoundEntityAction action = (CompoundEntityAction)super.clone();
        if (action != null) {
            action.entities = new ArrayList<WeakReference<Entity>>(this.entities);
        }
        return action;
    }
}

