/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ArcLocationEffect
extends LocationEffect {
    protected final Vector link;
    protected final float length;
    public ParticleEffect particle = ParticleEffect.FLAME;
    public float height = 2.0f;
    public int particles = 100;
    protected int step = 0;

    public ArcLocationEffect(EffectManager effectManager, Location start, Location stop) {
        super(effectManager, start);
        this.link = stop.toVector().subtract(start.toVector());
        this.length = (float)this.link.length();
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        float pitch = (float)((double)(4.0f * this.height) / Math.pow(this.length, 2.0));
        for (int i = 0; i < this.particles; ++i) {
            Vector v = this.link.clone().normalize().multiply(this.length * (float)i / (float)this.particles);
            float x = (float)i / (float)this.particles * this.length - this.length / 2.0f;
            float y = (float)((double)(-pitch) * Math.pow(x, 2.0) + (double)this.height);
            this.location.add(v).add(0.0, (double)y, 0.0);
            this.particle.display(this.location, this.visibleRange);
            this.location.subtract(0.0, (double)y, 0.0).subtract(v);
            ++this.step;
        }
    }
}

