/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.protection.GriefPreventionAPI;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GriefPreventionManager {
    private boolean enabled = false;
    private GriefPreventionAPI api = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.api != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin griefPlugin = plugin.getServer().getPluginManager().getPlugin("GriefPrevention");
                if (griefPlugin != null) {
                    this.api = new GriefPreventionAPI(griefPlugin);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.api == null) {
                plugin.getLogger().info("GriefPrevention not found, claim protection will not be used.");
            } else {
                plugin.getLogger().info("GriefPrevention found, will respect claim build permissions for construction spells");
            }
        } else {
            plugin.getLogger().info("GriefPrevention manager disabled, claim protection will not be used.");
            this.api = null;
        }
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.api != null) {
            return this.api.hasBuildPermission(player, block);
        }
        return true;
    }
}

