/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.Schematic;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.maps.BufferedMapCanvas;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialBrush {
    public static final String ERASE_MATERIAL_KEY = "erase";
    public static final String COPY_MATERIAL_KEY = "copy";
    public static final String CLONE_MATERIAL_KEY = "clone";
    public static final String REPLICATE_MATERIAL_KEY = "replicate";
    public static final String MAP_MATERIAL_KEY = "map";
    public static final String SCHEMATIC_MATERIAL_KEY = "schematic";
    public static final int DEFAULT_MAP_SIZE = 16;
    public static final String[] SPECIAL_MATERIAL_KEYS = new String[]{"erase", "copy", "clone", "replicate", "map"};
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.SUGAR;
    public static Material CloneMaterial = Material.NETHER_STALK;
    public static Material ReplicateMaterial = Material.PUMPKIN_SEEDS;
    public static Material MapMaterial = Material.MAP;
    public static Material SchematicMaterial = Material.PAPER;
    public static Material DefaultBrushMaterial = Material.SULPHUR;
    public static String EraseCustomIcon;
    public static String CopyCustomIcon;
    public static String CloneCustomIcon;
    public static String ReplicateCustomIcon;
    public static String MapCustomIcon;
    public static String SchematicCustomIcon;
    public static String DefaultBrushCustomIcon;
    public static final Material DEFAULT_MATERIAL;
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneSource = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private Vector targetOffset = null;
    private String targetWorldName = null;
    private final Mage mage;
    private short mapId = (short)-1;
    private BufferedMapCanvas mapCanvas = null;
    private Material mapMaterialBase = Material.STAINED_CLAY;
    private Schematic schematic;
    private String schematicName = "";
    private boolean fillWithAir = true;
    private Vector orientVector = null;
    private double scale = 1.0;

    public MaterialBrush(Mage mage, Material material, byte data) {
        super(material, data);
        this.mage = mage;
    }

    public MaterialBrush(Mage mage, Location location, String materialKey) {
        super(DEFAULT_MATERIAL, (short)0);
        this.mage = mage;
        this.update(materialKey);
        this.activate(location, materialKey);
    }

    public MaterialBrush(Mage mage, Block block) {
        super(block);
        this.mage = mage;
    }

    private MaterialBrush(String materialKey) {
        super(DEFAULT_MATERIAL, (short)0);
        this.mage = null;
        this.update(materialKey);
    }

    @Override
    public String getKey() {
        String materialKey = null;
        if (this.mode == BrushMode.ERASE) {
            materialKey = ERASE_MATERIAL_KEY;
        } else if (this.mode == BrushMode.COPY) {
            materialKey = COPY_MATERIAL_KEY;
        } else if (this.mode == BrushMode.CLONE) {
            materialKey = CLONE_MATERIAL_KEY;
        } else if (this.mode == BrushMode.MAP) {
            materialKey = MAP_MATERIAL_KEY;
            int mapSize = (int)(128.0 / this.scale);
            if (mapSize != 16) {
                materialKey = materialKey + ":" + mapSize;
            }
        } else {
            materialKey = this.mode == BrushMode.REPLICATE ? REPLICATE_MATERIAL_KEY : (this.mode == BrushMode.SCHEMATIC ? "schematic:" + this.schematicName : super.getKey());
        }
        return materialKey;
    }

    public static boolean isSpecialMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        return COPY_MATERIAL_KEY.equals(materialKey = MaterialBrush.splitMaterialKey(materialKey)[0]) || ERASE_MATERIAL_KEY.equals(materialKey) || REPLICATE_MATERIAL_KEY.equals(materialKey) || CLONE_MATERIAL_KEY.equals(materialKey) || MAP_MATERIAL_KEY.equals(materialKey) || SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static boolean isSchematic(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        materialKey = MaterialBrush.splitMaterialKey(materialKey)[0];
        return SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static String getMaterialName(Messages messages, String materialKey) {
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.getName(messages);
    }

    @Override
    public String getName() {
        Messages messages = this.mage != null ? this.mage.getController().getMessages() : null;
        return this.getName(messages);
    }

    @Override
    public String getName(Messages messages) {
        String brushKey;
        switch (this.mode) {
            case ERASE: {
                brushKey = ERASE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.erase_material_name");
                break;
            }
            case CLONE: {
                brushKey = CLONE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.clone_material_name");
                break;
            }
            case REPLICATE: {
                brushKey = REPLICATE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.replicate_material_name");
                break;
            }
            case COPY: {
                brushKey = COPY_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.copy_material_name");
                break;
            }
            case MAP: {
                brushKey = MAP_MATERIAL_KEY;
                int mapSize = (int)(128.0 / this.scale);
                if (mapSize != 16) {
                    if (messages != null) {
                        brushKey = messages.get("wand.map_material_name_scaled");
                        brushKey = brushKey.replace("$size", Integer.toString(mapSize));
                        break;
                    }
                    brushKey = brushKey + " " + mapSize + "x" + mapSize;
                    break;
                }
                if (messages == null) break;
                brushKey = messages.get("wand.map_material_name");
                break;
            }
            case SCHEMATIC: {
                brushKey = this.schematicName;
                brushKey = brushKey.toLowerCase().replace('_', ' ');
                break;
            }
            default: {
                brushKey = super.getName(messages);
            }
        }
        return brushKey;
    }

    public static MaterialBrush parseMaterialKey(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey, false);
    }

    public static MaterialBrush parseMaterialKey(String materialKey, boolean allowItems) {
        if (materialKey == null || materialKey.length() == 0) {
            return null;
        }
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.isValid(allowItems) ? brush : null;
    }

    public static boolean isValidMaterial(String materialKey, boolean allowItems) {
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.isValid(allowItems);
    }

    public boolean isValid(boolean allowItems) {
        if (!this.isValid()) {
            return false;
        }
        if (this.mode != BrushMode.MATERIAL) {
            return true;
        }
        return allowItems || this.material.isBlock();
    }

    @Override
    public void setMaterial(Material material, Short data) {
        if (material != null && material.isBlock() && (this.mage == null || !this.mage.isRestricted(material))) {
            super.setMaterial(material, data);
            this.isValid = true;
        } else {
            this.isValid = false;
        }
        this.fillWithAir = true;
    }

    public void enableCloning() {
        if (this.mode != BrushMode.CLONE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.CLONE;
        }
    }

    public void enableErase() {
        if (this.mode != BrushMode.ERASE) {
            this.setMaterial(Material.AIR);
            this.mode = BrushMode.ERASE;
            this.fillWithAir = true;
        }
    }

    public void enableMap(int size) {
        this.fillWithAir = false;
        if (size <= 0) {
            size = 16;
        }
        this.scale = 128.0f / (float)size;
        this.mode = BrushMode.MAP;
        if (this.material == Material.WOOL || this.material == Material.STAINED_CLAY || this.material == Material.STAINED_GLASS || this.material == Material.STAINED_GLASS_PANE || this.material == Material.CARPET) {
            this.mapMaterialBase = this.material;
        }
    }

    public void enableSchematic(String name) {
        if (this.mode != BrushMode.SCHEMATIC) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.SCHEMATIC;
        }
        this.schematicName = name;
        this.schematic = null;
    }

    public void clearSchematic() {
        this.schematic = null;
    }

    public void enableReplication() {
        if (this.mode != BrushMode.REPLICATE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.REPLICATE;
        }
    }

    public void setMapId(short mapId) {
        this.mapCanvas = null;
        this.mapId = mapId;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneSource = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void clearCloneLocation() {
        this.cloneSource = null;
        this.materialTarget = null;
    }

    public void clearCloneTarget() {
        this.cloneTarget = null;
        this.targetOffset = null;
        this.targetWorldName = null;
    }

    public void setTargetOffset(Vector offset, String worldName) {
        this.targetOffset = offset.clone();
        this.targetWorldName = worldName;
    }

    public boolean hasCloneTarget() {
        return this.cloneSource != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    @Override
    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public Location toTargetLocation(Location target) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneSource.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        return translated;
    }

    public Location fromTargetLocation(World targetWorld, Location target) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        translated.setX((double)translated.getBlockX());
        translated.setY((double)translated.getBlockY());
        translated.setZ((double)translated.getBlockZ());
        Vector cloneVector = new Vector(this.cloneSource.getBlockX(), this.cloneSource.getBlockY(), this.cloneSource.getBlockZ());
        translated.subtract(cloneVector);
        Vector cloneTargetVector = new Vector(this.cloneTarget.getBlockX(), this.cloneTarget.getBlockY(), this.cloneTarget.getBlockZ());
        translated.add(cloneTargetVector);
        translated.setWorld(targetWorld);
        return translated;
    }

    @Override
    public boolean update(Mage fromMage, Location target) {
        Vector diff;
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            if (this.cloneSource == null) {
                this.isValid = false;
                return true;
            }
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            if (this.materialTarget.getY() < 0.0 || this.materialTarget.getWorld() == null || this.materialTarget.getY() > (double)this.materialTarget.getWorld().getMaxHeight()) {
                this.isValid = false;
            } else {
                Block block = this.materialTarget.getBlock();
                if (!block.getChunk().isLoaded()) {
                    return false;
                }
                this.updateFrom(block, fromMage.getRestrictedMaterials());
                boolean bl = this.isValid = this.fillWithAir || this.material != Material.AIR;
            }
        }
        if (this.mode == BrushMode.SCHEMATIC) {
            if (!this.checkSchematic()) {
                return true;
            }
            if (this.cloneTarget == null) {
                this.isValid = false;
                return true;
            }
            diff = target.toVector().subtract(this.cloneTarget.toVector());
            com.elmakers.mine.bukkit.api.block.MaterialAndData newMaterial = this.schematic.getBlock(diff);
            if (newMaterial == null) {
                this.isValid = false;
            } else {
                this.updateFrom(newMaterial);
                boolean bl = this.isValid = this.fillWithAir || newMaterial.getMaterial() != Material.AIR;
            }
        }
        if (this.mode == BrushMode.MAP && this.mapId >= 0) {
            if (this.mapCanvas == null && fromMage != null) {
                try {
                    MapView mapView = Bukkit.getMap((short)this.mapId);
                    if (mapView != null) {
                        Player player = fromMage.getPlayer();
                        List renderers = mapView.getRenderers();
                        if (renderers.size() > 0 && player != null) {
                            this.mapCanvas = new BufferedMapCanvas();
                            MapRenderer renderer = (MapRenderer)renderers.get(0);
                            renderer.initialize(mapView);
                            renderer.render(mapView, (MapCanvas)this.mapCanvas, player);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.isValid = false;
            if (this.mapCanvas != null && this.cloneTarget != null) {
                diff = target.toVector().subtract(this.cloneTarget.toVector());
                DyeColor mapColor = DyeColor.WHITE;
                mapColor = this.orientVector.getBlockY() > this.orientVector.getBlockZ() || this.orientVector.getBlockY() > this.orientVector.getBlockX() ? (this.orientVector.getBlockX() > this.orientVector.getBlockZ() ? this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockX() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)(-diff.getBlockY()) * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT)) : this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockZ() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)(-diff.getBlockY()) * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT))) : this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockX() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)diff.getBlockZ() * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT));
                if (mapColor != null) {
                    this.material = this.mapMaterialBase;
                    this.data = mapColor.getData();
                    this.isValid = true;
                }
            }
        }
        return true;
    }

    protected boolean checkSchematic() {
        if (this.schematic == null) {
            if (this.schematicName.length() == 0) {
                this.isValid = false;
                return false;
            }
            this.schematic = this.mage.getController().loadSchematic(this.schematicName);
            if (this.schematic == null) {
                this.schematicName = "";
                this.isValid = false;
                return false;
            }
        }
        return this.schematic != null;
    }

    @Override
    public void prepare() {
        Block block;
        if (this.cloneSource != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    public void load(ConfigurationSection node) {
        try {
            this.cloneSource = ConfigurationUtils.getLocation(node, "clone_location");
            this.cloneTarget = ConfigurationUtils.getLocation(node, "clone_target");
            this.materialTarget = ConfigurationUtils.getLocation(node, "material_target");
            this.schematicName = node.getString(SCHEMATIC_MATERIAL_KEY, this.schematicName);
            this.mapId = (short)node.getInt("map_id", (int)this.mapId);
            this.material = ConfigurationUtils.getMaterial(node, "material", this.material);
            this.data = (short)node.getInt("data", (int)this.data.shortValue());
            this.customName = node.getString("extra_data", this.customName);
            this.scale = node.getDouble("scale", this.scale);
            this.fillWithAir = node.getBoolean(ERASE_MATERIAL_KEY, this.fillWithAir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mage.getController().getLogger().warning("Failed to load brush data: " + ex.getMessage());
        }
    }

    public void save(ConfigurationSection node) {
        try {
            if (this.cloneSource != null) {
                node.set("clone_location", (Object)ConfigurationUtils.fromLocation(this.cloneSource));
            }
            if (this.cloneTarget != null) {
                node.set("clone_target", (Object)ConfigurationUtils.fromLocation(this.cloneTarget));
            }
            if (this.materialTarget != null) {
                node.set("material_target", (Object)ConfigurationUtils.fromLocation(this.materialTarget));
            }
            node.set("map_id", (Object)this.mapId);
            node.set("material", (Object)ConfigurationUtils.fromMaterial(this.material));
            node.set("data", (Object)this.data);
            node.set("extra_data", (Object)this.customName);
            node.set(SCHEMATIC_MATERIAL_KEY, (Object)this.schematicName);
            node.set("scale", (Object)this.scale);
            node.set(ERASE_MATERIAL_KEY, (Object)this.fillWithAir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mage.getController().getLogger().warning("Failed to save brush data: " + ex.getMessage());
        }
    }

    @Override
    public boolean hasEntities() {
        return this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE || this.mode == BrushMode.SCHEMATIC;
    }

    @Override
    public Collection<Entity> getTargetEntities() {
        if (this.cloneTarget == null) {
            return null;
        }
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE || this.mode == BrushMode.SCHEMATIC) {
            ArrayList<Entity> targetData = new ArrayList<Entity>();
            World targetWorld = this.cloneTarget.getWorld();
            List targetEntities = targetWorld.getEntities();
            for (Entity entity : targetEntities) {
                if (this.mode == BrushMode.SCHEMATIC && !(entity instanceof Hanging) || entity instanceof Player || this.mage.getController().isNPC(entity)) continue;
                targetData.add(entity);
            }
            return targetData;
        }
        return null;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities() {
        if (this.cloneTarget == null) {
            return null;
        }
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.cloneSource != null) {
            ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData> copyEntities = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
            World sourceWorld = this.cloneSource.getWorld();
            List entities = sourceWorld.getEntities();
            for (Entity entity : entities) {
                if (entity instanceof Player || entity instanceof Item) continue;
                Location entityLocation = entity.getLocation();
                Location translated = this.fromTargetLocation(this.cloneTarget.getWorld(), entityLocation);
                EntityData entityData = new EntityData(translated, entity);
                copyEntities.add(entityData);
            }
            return copyEntities;
        }
        if (this.mode == BrushMode.SCHEMATIC && this.schematic != null) {
            return this.schematic.getEntities(this.cloneTarget);
        }
        return null;
    }

    @Override
    public void activate(Location location, String material) {
        String materialKey = MaterialBrush.splitMaterialKey(material)[0];
        if (materialKey.equals(CLONE_MATERIAL_KEY) || materialKey.equals(REPLICATE_MATERIAL_KEY) && location != null) {
            Location cloneFrom = location.clone();
            cloneFrom.setY(cloneFrom.getY() - 1.0);
            this.setCloneLocation(cloneFrom);
        } else if (materialKey.equals(MAP_MATERIAL_KEY) || materialKey.equals(SCHEMATIC_MATERIAL_KEY)) {
            this.clearCloneTarget();
        }
    }

    @Override
    public void update(String activeMaterial) {
        String[] pieces = MaterialBrush.splitMaterialKey(activeMaterial);
        this.isValid = true;
        if (activeMaterial.equals(COPY_MATERIAL_KEY)) {
            this.enableCopying();
        } else if (activeMaterial.equals(CLONE_MATERIAL_KEY)) {
            this.enableCloning();
        } else if (activeMaterial.equals(REPLICATE_MATERIAL_KEY)) {
            this.enableReplication();
        } else if (pieces[0].equals(MAP_MATERIAL_KEY)) {
            int size = 16;
            if (pieces.length > 1) {
                try {
                    size = Integer.parseInt(pieces[1]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.enableMap(size);
        } else if (activeMaterial.equals(ERASE_MATERIAL_KEY)) {
            this.enableErase();
        } else if (pieces.length > 1 && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
            this.enableSchematic(pieces[1]);
        } else {
            this.mode = BrushMode.MATERIAL;
            super.update(activeMaterial);
        }
    }

    @Override
    public void setTarget(Location target) {
        this.setTarget(target, target);
    }

    @Override
    public void setTarget(Location target, Location center) {
        if (target == null || center == null) {
            return;
        }
        this.orientVector = target.toVector().subtract(center.toVector());
        this.orientVector.setX(Math.abs(this.orientVector.getX()));
        this.orientVector.setY(Math.abs(this.orientVector.getY()));
        this.orientVector.setZ(Math.abs(this.orientVector.getZ()));
        if (this.mode == BrushMode.REPLICATE || this.mode == BrushMode.CLONE || this.mode == BrushMode.MAP || this.mode == BrushMode.SCHEMATIC) {
            if (this.cloneTarget == null || this.mode == BrushMode.CLONE || !center.getWorld().getName().equals(this.cloneTarget.getWorld().getName())) {
                this.cloneTarget = center;
                if (this.targetOffset != null) {
                    this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                }
            } else if (this.mode == BrushMode.SCHEMATIC) {
                if (this.schematic == null && this.schematicName != null) {
                    this.schematic = this.mage.getController().loadSchematic(this.schematicName);
                }
                boolean recenter = true;
                if (this.schematic != null) {
                    Vector diff = target.toVector().subtract(this.cloneTarget.toVector());
                    boolean bl = recenter = !this.schematic.contains(diff);
                }
                if (recenter) {
                    this.cloneTarget = center;
                    if (this.targetOffset != null) {
                        this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                    }
                }
            }
            if (this.cloneSource == null) {
                this.cloneSource = this.cloneTarget.clone();
                if (this.targetWorldName != null && this.targetWorldName.length() > 0) {
                    World sourceWorld = this.cloneSource.getWorld();
                    this.cloneSource.setWorld(ConfigurationUtils.overrideWorld(this.targetWorldName, sourceWorld, this.mage.getController().canCreateWorlds()));
                }
            }
            if (this.materialTarget == null) {
                this.materialTarget = this.cloneTarget;
            }
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            if (this.targetOffset != null) {
                Location targetLocation = block.getLocation();
                targetLocation = targetLocation.add(this.targetOffset);
                block = targetLocation.getBlock();
            }
            this.updateFrom(block, this.mage.getRestrictedMaterials());
        }
    }

    @Override
    public Vector getSize() {
        if (this.mode != BrushMode.SCHEMATIC) {
            return new Vector(0, 0, 0);
        }
        if (!this.checkSchematic()) {
            return new Vector(0, 0, 0);
        }
        return this.schematic.getSize();
    }

    @Override
    public BrushMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isEraseModifierActive() {
        return this.fillWithAir;
    }

    public ItemStack getItem(MageController controller, boolean isItem) {
        Messages messages = controller.getMessages();
        Material material = this.getMaterial();
        short dataId = this.getData();
        String extraLore = null;
        String customName = this.getName(messages);
        ItemStack itemStack = null;
        if (this.mode == BrushMode.ERASE) {
            material = EraseMaterial;
            if (EraseCustomIcon != null && !EraseCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(EraseCustomIcon);
            }
            extraLore = messages.get("wand.erase_material_description");
        } else if (this.mode == BrushMode.COPY) {
            material = CopyMaterial;
            if (CopyCustomIcon != null && !CopyCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(CopyCustomIcon);
            }
            extraLore = messages.get("wand.copy_material_description");
        } else if (this.mode == BrushMode.CLONE) {
            material = CloneMaterial;
            if (CloneCustomIcon != null && !CloneCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(CloneCustomIcon);
            }
            extraLore = messages.get("wand.clone_material_description");
        } else if (this.mode == BrushMode.REPLICATE) {
            material = ReplicateMaterial;
            if (ReplicateCustomIcon != null && !ReplicateCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(ReplicateCustomIcon);
            }
            extraLore = messages.get("wand.replicate_material_description");
        } else if (this.mode == BrushMode.MAP) {
            material = MapMaterial;
            if (MapCustomIcon != null && !MapCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(MapCustomIcon);
            }
            extraLore = messages.get("wand.map_material_description");
        } else if (this.mode == BrushMode.SCHEMATIC) {
            material = SchematicMaterial;
            if (SchematicCustomIcon != null && !SchematicCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                itemStack = InventoryUtils.getURLSkull(SchematicCustomIcon);
            }
            extraLore = messages.get("wand.schematic_material_description").replace("$schematic", this.schematicName);
        } else {
            if (material == Material.WATER || material == Material.STATIONARY_WATER || material == Material.LAVA || material == Material.STATIONARY_LAVA) {
                if (material == Material.WATER || material == Material.STATIONARY_WATER) {
                    material = Material.WATER_BUCKET;
                } else if (material == Material.LAVA || material == Material.STATIONARY_LAVA) {
                    material = Material.LAVA_BUCKET;
                }
            }
            extraLore = messages.get("wand.building_material_description").replace("$material", customName);
        }
        if (itemStack == null) {
            itemStack = new ItemStack(material, 1, dataId);
            if ((itemStack = InventoryUtils.makeReal(itemStack)) == null) {
                if (DefaultBrushCustomIcon != null && !DefaultBrushCustomIcon.isEmpty() && controller.isUrlIconsEnabled()) {
                    itemStack = InventoryUtils.getURLSkull(DefaultBrushCustomIcon);
                }
                if (itemStack == null) {
                    itemStack = new ItemStack(DefaultBrushMaterial, 1, dataId);
                    if ((itemStack = InventoryUtils.makeReal(itemStack)) == null) {
                        return itemStack;
                    }
                }
            }
        }
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (extraLore != null) {
            lore.add(ChatColor.LIGHT_PURPLE + extraLore);
        }
        if (isItem) {
            lore.add(ChatColor.YELLOW + messages.get("wand.brush_item_description"));
        }
        meta.setLore(lore);
        if (customName != null) {
            meta.setDisplayName(customName);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    static {
        DEFAULT_MATERIAL = Material.DIRT;
    }
}

