/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.batch.SpellBatch;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public abstract class BrushBatch
extends SpellBatch {
    protected final BrushSpell spell;

    public BrushBatch(BrushSpell spell) {
        super(spell);
        this.spell = spell;
    }

    protected abstract boolean contains(Location var1);

    @Override
    public void finish() {
        if (!this.finished) {
            MaterialBrush brush = this.spell.getBrush();
            if (brush != null && brush.hasEntities()) {
                Collection<EntityData> entities = brush.getEntities();
                Collection<Entity> targetEntities = brush.getTargetEntities();
                if (targetEntities != null) {
                    for (Entity entity : targetEntities) {
                        if (!this.contains(entity.getLocation())) continue;
                        this.undoList.modify(entity);
                        entity.remove();
                    }
                }
                if (entities != null) {
                    for (EntityData entityData : entities) {
                        if (!this.contains(entityData.getLocation())) continue;
                        this.undoList.add(entityData.spawn());
                    }
                }
            }
            super.finish();
        }
    }
}

