/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class PlayRecordAction
extends BaseSpellAction {
    private String recordList = "";

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.recordList = parameters.getString("records", "records");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location location = context.getTargetLocation();
        Set<Material> recordSet = context.getMaterialSet(this.recordList);
        if (recordSet == null || recordSet.size() == 0) {
            return SpellResult.FAIL;
        }
        ArrayList<Material> records = new ArrayList<Material>(recordSet);
        Random random = context.getRandom();
        Material record = (Material)records.get(random.nextInt(records.size()));
        location.getWorld().playEffect(location, Effect.RECORD_PLAY, record.getId());
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

