/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.block.Schematic;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class NMSUtils {
    protected static boolean failed = false;
    protected static String versionPrefix = "";
    protected static boolean isLegacy = false;
    protected static final int NBT_TYPE_COMPOUND = 10;
    protected static final int NBT_TYPE_INT_ARRAY = 11;
    protected static final int NBT_TYPE_DOUBLE = 6;
    protected static final int NBT_TYPE_FLOAT = 5;
    protected static final int NBT_TYPE_STRING = 8;
    protected static int WITHER_SKULL_TYPE = 66;
    protected static int FIREWORK_TYPE = 76;
    protected static Class<?> class_ItemStack;
    protected static Class<?> class_NBTBase;
    protected static Class<?> class_NBTTagCompound;
    protected static Class<?> class_NBTTagList;
    protected static Class<?> class_NBTTagByte;
    protected static Class<?> class_NBTTagString;
    protected static Class<?> class_CraftTask;
    protected static Class<?> class_CraftInventoryCustom;
    protected static Class<?> class_CraftItemStack;
    protected static Class<?> class_CraftBlockState;
    protected static Class<?> class_CraftLivingEntity;
    protected static Class<?> class_CraftWorld;
    protected static Class<?> class_Entity;
    protected static Class<?> class_EntityCreature;
    protected static Class<?> class_EntityLiving;
    protected static Class<?> class_DataWatcher;
    protected static Class<?> class_DamageSource;
    protected static Class<?> class_World;
    protected static Class<?> class_Packet;
    protected static Class<Enum> class_EnumSkyBlock;
    protected static Class<?> class_PacketPlayOutMapChunkBulk;
    protected static Class<?> class_EntityPainting;
    protected static Class<?> class_EntityItemFrame;
    protected static Class<?> class_EntityMinecartRideable;
    protected static Class<?> class_EntityTNTPrimed;
    protected static Class<?> class_AxisAlignedBB;
    protected static Class<?> class_PathPoint;
    protected static Class<?> class_PathEntity;
    protected static Class<?> class_EntityFirework;
    protected static Class<?> class_CraftSkull;
    protected static Class<?> class_CraftBanner;
    protected static Class<?> class_CraftMetaSkull;
    protected static Class<?> class_CraftMetaBanner;
    protected static Class<?> class_GameProfile;
    protected static Class<?> class_GameProfileProperty;
    protected static Class<?> class_BlockPosition;
    protected static Class<?> class_NBTCompressedStreamTools;
    protected static Class<?> class_TileEntity;
    protected static Class<Enum> class_EnumDirection;
    protected static Class<?> class_EntityHorse;
    protected static Class<?> class_EntityWitherSkull;
    protected static Class<?> class_PacketPlayOutAttachEntity;
    protected static Class<?> class_PacketPlayOutEntityDestroy;
    protected static Class<?> class_PacketPlayOutSpawnEntity;
    protected static Class<?> class_PacketPlayOutSpawnEntityLiving;
    protected static Class<?> class_PacketPlayOutEntityMetadata;
    protected static Class<?> class_PacketPlayOutEntityStatus;
    protected static Method class_NBTTagList_addMethod;
    protected static Method class_NBTTagList_getMethod;
    protected static Method class_NBTTagList_getDoubleMethod;
    protected static Method class_NBTTagList_sizeMethod;
    protected static Method class_NBTTagCompound_setMethod;
    protected static Method class_DataWatcher_watchMethod;
    protected static Method class_World_getEntitiesMethod;
    protected static Method class_Entity_getBukkitEntityMethod;
    protected static Method class_EntityLiving_damageEntityMethod;
    protected static Method class_DamageSource_getMagicSourceMethod;
    protected static Method class_AxisAlignedBB_createBBMethod;
    protected static Method class_World_explodeMethod;
    protected static Method class_NBTTagCompound_setBooleanMethod;
    protected static Method class_NBTTagCompound_setStringMethod;
    protected static Method class_NBTTagCompound_setIntMethod;
    protected static Method class_NBTTagCompound_removeMethod;
    protected static Method class_NBTTagCompound_getStringMethod;
    protected static Method class_NBTTagCompound_getIntMethod;
    protected static Method class_NBTTagCompound_getByteMethod;
    protected static Method class_NBTTagCompound_getMethod;
    protected static Method class_NBTTagCompound_getCompoundMethod;
    protected static Method class_NBTTagCompound_getShortMethod;
    protected static Method class_NBTTagCompound_getByteArrayMethod;
    protected static Method class_NBTTagCompound_getListMethod;
    protected static Method class_TileEntity_loadMethod;
    protected static Method class_TileEntity_saveMethod;
    protected static Method class_TileEntity_updateMethod;
    protected static Method class_World_addEntityMethod;
    protected static Method class_CraftMetaBanner_getPatternsMethod;
    protected static Method class_CraftMetaBanner_setPatternsMethod;
    protected static Method class_CraftMetaBanner_getBaseColorMethod;
    protected static Method class_CraftMetaBanner_setBaseColorMethod;
    protected static Method class_CraftBanner_getPatternsMethod;
    protected static Method class_CraftBanner_setPatternsMethod;
    protected static Method class_CraftBanner_getBaseColorMethod;
    protected static Method class_CraftBanner_setBaseColorMethod;
    protected static Method class_NBTCompressedStreamTools_loadFileMethod;
    protected static Method class_ItemStack_createStackMethod;
    protected static Method class_CraftItemStack_asBukkitCopyMethod;
    protected static Method class_CraftItemStack_copyMethod;
    protected static Method class_CraftItemStack_mirrorMethod;
    protected static Method class_NBTTagCompound_hasKeyMethod;
    protected static Method class_CraftWorld_getTileEntityAtMethod;
    protected static Method class_Entity_setLocationMethod;
    protected static Method class_Entity_getIdMethod;
    protected static Method class_Entity_getDataWatcherMethod;
    protected static Constructor class_NBTTagList_consructor;
    protected static Constructor class_NBTTagList_legacy_consructor;
    protected static Constructor class_CraftInventoryCustom_constructor;
    protected static Constructor class_NBTTagByte_constructor;
    protected static Constructor class_NBTTagByte_legacy_constructor;
    protected static Constructor class_EntityFireworkConstructor;
    protected static Constructor class_EntityPaintingConstructor;
    protected static Constructor class_EntityItemFrameConstructor;
    protected static Constructor class_BlockPositionConstructor;
    protected static Constructor class_PacketSpawnEntityConstructor;
    protected static Constructor class_PacketSpawnLivingEntityConstructor;
    protected static Constructor class_PacketPlayOutEntityMetadata_Constructor;
    protected static Constructor class_PacketPlayOutEntityStatus_Constructor;
    protected static Constructor class_PacketPlayOutEntityDestroy_Constructor;
    protected static Field class_Entity_invulnerableField;
    protected static Field class_Entity_motXField;
    protected static Field class_Entity_motYField;
    protected static Field class_Entity_motZField;
    protected static Field class_ItemStack_tagField;
    protected static Field class_DamageSource_MagicField;
    protected static Field class_Firework_ticksFlownField;
    protected static Field class_Firework_expectedLifespanField;
    protected static Field class_CraftSkull_profile;
    protected static Field class_CraftMetaSkull_profile;
    protected static Field class_GameProfile_properties;
    protected static Field class_GameProfileProperty_value;
    protected static Field class_ItemStack_count;
    protected static Field class_EntityTNTPrimed_source;
    protected static Field class_NBTTagList_list;

    public static boolean getFailed() {
        return failed;
    }

    public static boolean isLegacy() {
        return isLegacy;
    }

    public static Class<?> getVersionedBukkitClass(String newVersion, String oldVersion) {
        Class<?> c = NMSUtils.getBukkitClass(newVersion);
        if (c == null && (c = NMSUtils.getBukkitClass(oldVersion)) == null) {
            Bukkit.getLogger().warning("Could not bind to " + newVersion + " or " + oldVersion);
        }
        return c;
    }

    public static Class<?> getClass(String className) {
        Class<?> result = null;
        try {
            result = NMSUtils.class.getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static Class<?> getBukkitClass(String className) {
        Class<?> result = null;
        try {
            result = NMSUtils.fixBukkitClass(className);
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static Class<?> fixBukkitClass(String className) throws ClassNotFoundException {
        if (!versionPrefix.isEmpty()) {
            className = className.replace("org.bukkit.craftbukkit.", "org.bukkit.craftbukkit." + versionPrefix);
            className = className.replace("net.minecraft.server.", "net.minecraft.server." + versionPrefix);
        }
        return NMSUtils.class.getClassLoader().loadClass(className);
    }

    public static Object getHandle(ItemStack stack) {
        Object handle = null;
        try {
            Field handleField = stack.getClass().getDeclaredField("handle");
            handleField.setAccessible(true);
            handle = handleField.get(stack);
        }
        catch (Throwable ex) {
            handle = null;
        }
        return handle;
    }

    public static Object getHandle(World world) {
        if (world == null) {
            return null;
        }
        Object handle = null;
        try {
            Method handleMethod = world.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)world, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static Object getHandle(Entity entity) {
        if (entity == null) {
            return null;
        }
        Object handle = null;
        try {
            Method handleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static Object getHandle(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        Object handle = null;
        try {
            Method handleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static boolean isDone(Chunk chunk) {
        Object chunkHandle = NMSUtils.getHandle(chunk);
        boolean done = false;
        try {
            Field doneField = chunkHandle.getClass().getDeclaredField("done");
            doneField.setAccessible(true);
            done = (Boolean)doneField.get(chunkHandle);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return done;
    }

    public static Object getHandle(Chunk chunk) {
        Object handle = null;
        try {
            Method handleMethod = chunk.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)chunk, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static Object getHandle(Player player) {
        Object handle = null;
        try {
            Method handleMethod = player.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)player, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getHandle(Object object) {
        Object handle = null;
        try {
            Method handleMethod = object.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke(object, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static void sendPacket(Location source, Collection<Player> players, Object packet) throws Exception {
        players = players != null && players.size() > 0 ? players : source.getWorld().getPlayers();
        int viewDistanceSquared = Bukkit.getServer().getViewDistance() * Bukkit.getServer().getViewDistance();
        World sourceWorld = source.getWorld();
        for (Player player : players) {
            Location location = player.getLocation();
            if (!location.getWorld().equals(sourceWorld) || !(location.distanceSquared(source) <= (double)viewDistanceSquared)) continue;
            NMSUtils.sendPacket(player, packet);
        }
    }

    protected static void sendPacket(Player player, Object packet) throws Exception {
        Object playerHandle = NMSUtils.getHandle(player);
        Field connectionField = playerHandle.getClass().getField("playerConnection");
        Object connection = connectionField.get(playerHandle);
        Method sendPacketMethod = connection.getClass().getMethod("sendPacket", class_Packet);
        sendPacketMethod.invoke(connection, packet);
    }

    public static int getFacing(BlockFace direction) {
        int dir;
        switch (direction) {
            default: {
                dir = 0;
                break;
            }
            case WEST: {
                dir = 1;
                break;
            }
            case NORTH: {
                dir = 2;
                break;
            }
            case EAST: {
                dir = 3;
            }
        }
        return dir;
    }

    public static Entity getBukkitEntity(Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            Method getMethod = entity.getClass().getMethod("getBukkitEntity", new Class[0]);
            Object bukkitEntity = getMethod.invoke(entity, new Object[0]);
            if (!(bukkitEntity instanceof Entity)) {
                return null;
            }
            return (Entity)bukkitEntity;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getTag(Object mcItemStack) {
        Object tag = null;
        try {
            tag = class_ItemStack_tagField.get(mcItemStack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    protected static Object getNMSCopy(ItemStack stack) {
        Object nms = null;
        try {
            nms = class_CraftItemStack_copyMethod.invoke(null, stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return nms;
    }

    public static ItemStack getCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        try {
            Object craft = NMSUtils.getNMSCopy(stack);
            stack = (ItemStack)class_CraftItemStack_mirrorMethod.invoke(null, craft);
        }
        catch (Throwable ex) {
            stack = null;
        }
        return stack;
    }

    public static ItemStack makeReal(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object nmsStack = NMSUtils.getHandle(stack);
        if (nmsStack == null) {
            stack = NMSUtils.getCopy(stack);
            nmsStack = NMSUtils.getHandle(stack);
        }
        if (nmsStack == null) {
            return null;
        }
        try {
            Object tag = class_ItemStack_tagField.get(nmsStack);
            if (tag == null) {
                class_ItemStack_tagField.set(nmsStack, class_NBTTagCompound.newInstance());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return stack;
    }

    public static String getMeta(ItemStack stack, String tag, String defaultValue) {
        String result = NMSUtils.getMeta(stack, tag);
        return result == null ? defaultValue : result;
    }

    public static boolean hasMeta(ItemStack stack, String tag) {
        return NMSUtils.getNode(stack, tag) != null;
    }

    public static Object getNode(ItemStack stack, String tag) {
        if (stack == null) {
            return null;
        }
        Object meta = null;
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return null;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return null;
            }
            meta = class_NBTTagCompound_getMethod.invoke(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static boolean containsNode(Object nbtBase, String tag) {
        if (nbtBase == null) {
            return false;
        }
        Boolean result = false;
        try {
            result = (Boolean)class_NBTTagCompound_hasKeyMethod.invoke(nbtBase, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Object getNode(Object nbtBase, String tag) {
        if (nbtBase == null) {
            return null;
        }
        Object meta = null;
        try {
            meta = class_NBTTagCompound_getMethod.invoke(nbtBase, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static Object createNode(Object nbtBase, String tag) {
        if (nbtBase == null) {
            return null;
        }
        Object meta = null;
        try {
            meta = class_NBTTagCompound_getCompoundMethod.invoke(nbtBase, tag);
            class_NBTTagCompound_setMethod.invoke(nbtBase, tag, meta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static Object createNode(ItemStack stack, String tag) {
        if (stack == null) {
            return null;
        }
        Object outputObject = NMSUtils.getNode(stack, tag);
        if (outputObject == null) {
            try {
                Object craft = NMSUtils.getHandle(stack);
                if (craft == null) {
                    return null;
                }
                Object tagObject = NMSUtils.getTag(craft);
                if (tagObject == null) {
                    return null;
                }
                outputObject = class_NBTTagCompound.newInstance();
                class_NBTTagCompound_setMethod.invoke(tagObject, tag, outputObject);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return outputObject;
    }

    public static String getMeta(Object node, String tag, String defaultValue) {
        String meta = NMSUtils.getMeta(node, tag);
        return meta == null || meta.length() == 0 ? defaultValue : meta;
    }

    public static String getMeta(Object node, String tag) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return null;
        }
        String meta = null;
        try {
            meta = (String)class_NBTTagCompound_getStringMethod.invoke(node, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static Byte getMetaByte(Object node, String tag) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return null;
        }
        Byte meta = null;
        try {
            meta = (Byte)class_NBTTagCompound_getByteMethod.invoke(node, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static Integer getMetaInt(Object node, String tag) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return null;
        }
        Integer meta = null;
        try {
            meta = (Integer)class_NBTTagCompound_getIntMethod.invoke(node, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static void setMeta(Object node, String tag, String value) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return;
        }
        try {
            if (value == null || value.length() == 0) {
                class_NBTTagCompound_removeMethod.invoke(node, tag);
            } else {
                class_NBTTagCompound_setStringMethod.invoke(node, tag, value);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void removeMeta(Object node, String tag) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return;
        }
        try {
            class_NBTTagCompound_removeMethod.invoke(node, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void removeMeta(ItemStack stack, String tag) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            NMSUtils.removeMeta(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static String getMeta(ItemStack stack, String tag) {
        if (stack == null) {
            return null;
        }
        String meta = null;
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return null;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return null;
            }
            meta = (String)class_NBTTagCompound_getStringMethod.invoke(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static void setMeta(ItemStack stack, String tag, String value) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            class_NBTTagCompound_setStringMethod.invoke(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void addGlow(ItemStack stack) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object enchList = class_NBTTagList.newInstance();
            class_NBTTagCompound_setMethod.invoke(tagObject, "ench", enchList);
            Object bukkitData = NMSUtils.createNode(stack, "bukkit");
            class_NBTTagCompound_setBooleanMethod.invoke(bukkitData, "glow", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void removeGlow(ItemStack stack) {
        if (stack == null) {
            return;
        }
        Set enchants = stack.getEnchantments().keySet();
        for (Enchantment enchant : enchants) {
            stack.removeEnchantment(enchant);
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object bukkitData = NMSUtils.getNode(stack, "bukkit");
            if (bukkitData != null) {
                class_NBTTagCompound_setBooleanMethod.invoke(bukkitData, "glow", false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void makeUnbreakable(ItemStack stack) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object unbreakableFlag = null;
            unbreakableFlag = class_NBTTagByte_constructor != null ? class_NBTTagByte_constructor.newInstance((byte)1) : class_NBTTagByte_legacy_constructor.newInstance("", (byte)1);
            class_NBTTagCompound_setMethod.invoke(tagObject, "Unbreakable", unbreakableFlag);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void removeUnbreakable(ItemStack stack) {
        NMSUtils.removeMeta(stack, "Unbreakable");
    }

    public static void hideFlags(ItemStack stack, byte flags) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = NMSUtils.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = NMSUtils.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object hideFlag = null;
            hideFlag = class_NBTTagByte_constructor != null ? class_NBTTagByte_constructor.newInstance(flags) : class_NBTTagByte_legacy_constructor.newInstance("", flags);
            class_NBTTagCompound_setMethod.invoke(tagObject, "HideFlags", hideFlag);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean createExplosion(Entity entity, World world, double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        boolean result = false;
        if (world == null) {
            return false;
        }
        try {
            Object worldHandle = NMSUtils.getHandle(world);
            if (worldHandle == null) {
                return false;
            }
            Object entityHandle = entity == null ? null : NMSUtils.getHandle(entity);
            Object explosion = class_World_explodeMethod.invoke(worldHandle, entityHandle, x, y, z, Float.valueOf(power), setFire, breakBlocks);
            Field cancelledField = explosion.getClass().getDeclaredField("wasCanceled");
            result = (Boolean)cancelledField.get(explosion);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    public static void makeTemporary(ItemStack itemStack, String message) {
        NMSUtils.setMeta(itemStack, "temporary", message);
    }

    public static boolean isTemporary(ItemStack itemStack) {
        return NMSUtils.hasMeta(itemStack, "temporary");
    }

    public static String getTemporaryMessage(ItemStack itemStack) {
        return NMSUtils.getMeta(itemStack, "temporary");
    }

    public static void setReplacement(ItemStack itemStack, ItemStack replacement) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)replacement);
        NMSUtils.setMeta(itemStack, "replacement", configuration.saveToString());
    }

    public static ItemStack getReplacement(ItemStack itemStack) {
        String serialized = NMSUtils.getMeta(itemStack, "replacement");
        if (serialized == null || serialized.isEmpty()) {
            return null;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ItemStack replacement = null;
        try {
            configuration.loadFromString(serialized);
            replacement = configuration.getItemStack("item");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return replacement;
    }

    protected static Object getTagString(String value) {
        try {
            if (class_NBTTagList_legacy_consructor != null) {
                return class_NBTTagList_legacy_consructor.newInstance("", value);
            }
            return class_NBTTagList_consructor.newInstance(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object setStringList(Object nbtBase, String tag, Collection<String> values) {
        if (nbtBase == null) {
            return null;
        }
        Object listMeta = null;
        try {
            listMeta = class_NBTTagList.newInstance();
            for (String value : values) {
                Object nbtString = NMSUtils.getTagString(value);
                class_NBTTagList_addMethod.invoke(listMeta, nbtString);
            }
            class_NBTTagCompound_setMethod.invoke(nbtBase, tag, listMeta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return listMeta;
    }

    public static boolean hasBannerSupport() {
        return !isLegacy;
    }

    public static boolean hasURLSkullSupport() {
        return !isLegacy;
    }

    public static ItemStack getItem(Object itemTag) {
        ItemStack item = null;
        try {
            Object nmsStack = class_ItemStack_createStackMethod.invoke(null, itemTag);
            item = (ItemStack)class_CraftItemStack_mirrorMethod.invoke(null, nmsStack);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return item;
    }

    public static ItemStack[] getItems(Object rootTag, String tagName) {
        try {
            Object itemList = class_NBTTagCompound_getListMethod.invoke(rootTag, tagName, 10);
            Integer size = (Integer)class_NBTTagList_sizeMethod.invoke(itemList, new Object[0]);
            ItemStack[] items = new ItemStack[size.intValue()];
            for (int i = 0; i < size; ++i) {
                try {
                    Object itemData = class_NBTTagList_getMethod.invoke(itemList, i);
                    if (itemData == null) continue;
                    items[i] = NMSUtils.getItem(itemData);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return items;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Schematic loadSchematic(File inputFile) {
        if (inputFile == null || !inputFile.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return NMSUtils.loadSchematic(inputStream);
    }

    public static Schematic loadSchematic(InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            int i;
            int size;
            Object nbtData = class_NBTCompressedStreamTools_loadFileMethod.invoke(null, input);
            if (nbtData == null) {
                return null;
            }
            String materials = (String)class_NBTTagCompound_getStringMethod.invoke(nbtData, "Materials");
            if (!materials.equals("Alpha")) {
                Bukkit.getLogger().warning("Schematic is not in Alpha format");
                return null;
            }
            short width = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Width");
            short height = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Height");
            short length = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Length");
            byte[] blockIds = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Blocks");
            short[] blocks = new short[blockIds.length];
            byte[] addBlocks = new byte[]{};
            if (((Boolean)class_NBTTagCompound_hasKeyMethod.invoke(nbtData, "AddBlocks")).booleanValue()) {
                addBlocks = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = index >> 1 >= addBlocks.length ? (short)(blockIds[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addBlocks[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF)) : (short)(((addBlocks[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF)));
            }
            byte[] data = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Data");
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            Object entityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "Entities", 10);
            Object tileEntityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "TileEntities", 10);
            if (entityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(entityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object entity = class_NBTTagList_getMethod.invoke(entityList, i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(tileEntityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object tileEntity = class_NBTTagList_getMethod.invoke(tileEntityList, i);
                    tileEntityData.add(tileEntity);
                }
            }
            int originX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginX");
            int originY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginY");
            int originZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginZ");
            int offsetX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetX");
            int offsetY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetY");
            int offsetZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetZ");
            return new Schematic(width, height, length, blocks, data, tileEntityData, entityData, new Vector(originX, originY, originZ), new Vector(offsetX, offsetY, offsetZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getTileEntityData(Location location) {
        Object data = null;
        try {
            World world = location.getWorld();
            Object tileEntity = class_CraftWorld_getTileEntityAtMethod.invoke((Object)world, location.getBlockX(), location.getBlockY(), location.getBlockZ());
            if (tileEntity != null) {
                data = class_NBTTagCompound.newInstance();
                class_TileEntity_saveMethod.invoke(tileEntity, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return data;
    }

    public static void clearItems(Location location) {
        try {
            World world = location.getWorld();
            Object tileEntity = class_CraftWorld_getTileEntityAtMethod.invoke((Object)world, location.getBlockX(), location.getBlockY(), location.getBlockZ());
            if (tileEntity != null) {
                Object entityData = class_NBTTagCompound.newInstance();
                class_TileEntity_saveMethod.invoke(tileEntity, entityData);
                Object itemList = class_NBTTagCompound_getListMethod.invoke(entityData, "Items", 10);
                if (itemList != null) {
                    List items = (List)class_NBTTagList_list.get(itemList);
                    items.clear();
                    class_TileEntity_loadMethod.invoke(tileEntity, entityData);
                    class_TileEntity_updateMethod.invoke(tileEntity, new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setTileEntityData(Location location, Object data) {
        try {
            World world = location.getWorld();
            Object tileEntity = class_CraftWorld_getTileEntityAtMethod.invoke((Object)world, location.getBlockX(), location.getBlockY(), location.getBlockZ());
            class_NBTTagCompound_setIntMethod.invoke(data, "x", location.getBlockX());
            class_NBTTagCompound_setIntMethod.invoke(data, "y", location.getBlockY());
            class_NBTTagCompound_setIntMethod.invoke(data, "z", location.getBlockZ());
            class_TileEntity_loadMethod.invoke(tileEntity, data);
            class_TileEntity_updateMethod.invoke(tileEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Vector getPosition(Object entityData, String tag) {
        try {
            Object posList = class_NBTTagCompound_getListMethod.invoke(entityData, "Pos", 6);
            Double x = (Double)class_NBTTagList_getDoubleMethod.invoke(posList, 0);
            Double y = (Double)class_NBTTagList_getDoubleMethod.invoke(posList, 1);
            Double z = (Double)class_NBTTagList_getDoubleMethod.invoke(posList, 2);
            if (x != null && y != null && z != null) {
                return new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        String className = Bukkit.getServer().getClass().getName();
        String[] packages = className.split("\\.");
        if (packages.length == 5) {
            versionPrefix = packages[3] + ".";
        }
        try {
            class_Entity = NMSUtils.fixBukkitClass("net.minecraft.server.Entity");
            class_EntityLiving = NMSUtils.fixBukkitClass("net.minecraft.server.EntityLiving");
            class_ItemStack = NMSUtils.fixBukkitClass("net.minecraft.server.ItemStack");
            class_DataWatcher = NMSUtils.fixBukkitClass("net.minecraft.server.DataWatcher");
            class_NBTBase = NMSUtils.fixBukkitClass("net.minecraft.server.NBTBase");
            class_NBTTagCompound = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagCompound");
            class_NBTTagList = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagList");
            class_NBTTagString = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagString");
            class_NBTTagByte = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagByte");
            class_CraftWorld = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.CraftWorld");
            class_CraftInventoryCustom = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftInventoryCustom");
            class_CraftItemStack = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftItemStack");
            class_CraftBlockState = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.block.CraftBlockState");
            class_CraftTask = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.scheduler.CraftTask");
            class_CraftLivingEntity = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.entity.CraftLivingEntity");
            class_Packet = NMSUtils.fixBukkitClass("net.minecraft.server.Packet");
            class_World = NMSUtils.fixBukkitClass("net.minecraft.server.World");
            class_EnumSkyBlock = NMSUtils.fixBukkitClass("net.minecraft.server.EnumSkyBlock");
            class_EntityPainting = NMSUtils.fixBukkitClass("net.minecraft.server.EntityPainting");
            class_EntityCreature = NMSUtils.fixBukkitClass("net.minecraft.server.EntityCreature");
            class_EntityItemFrame = NMSUtils.fixBukkitClass("net.minecraft.server.EntityItemFrame");
            class_EntityMinecartRideable = NMSUtils.fixBukkitClass("net.minecraft.server.EntityMinecartRideable");
            class_EntityTNTPrimed = NMSUtils.fixBukkitClass("net.minecraft.server.EntityTNTPrimed");
            class_AxisAlignedBB = NMSUtils.fixBukkitClass("net.minecraft.server.AxisAlignedBB");
            class_DamageSource = NMSUtils.fixBukkitClass("net.minecraft.server.DamageSource");
            class_PathEntity = NMSUtils.fixBukkitClass("net.minecraft.server.PathEntity");
            class_PathPoint = NMSUtils.fixBukkitClass("net.minecraft.server.PathPoint");
            class_EntityFirework = NMSUtils.fixBukkitClass("net.minecraft.server.EntityFireworks");
            class_CraftSkull = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.block.CraftSkull");
            class_CraftMetaSkull = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftMetaSkull");
            class_NBTCompressedStreamTools = NMSUtils.fixBukkitClass("net.minecraft.server.NBTCompressedStreamTools");
            class_TileEntity = NMSUtils.fixBukkitClass("net.minecraft.server.TileEntity");
            class_EntityHorse = NMSUtils.fixBukkitClass("net.minecraft.server.EntityHorse");
            class_EntityWitherSkull = NMSUtils.fixBukkitClass("net.minecraft.server.EntityWitherSkull");
            class_PacketPlayOutAttachEntity = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutAttachEntity");
            class_PacketPlayOutEntityDestroy = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutEntityDestroy");
            class_PacketPlayOutSpawnEntity = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutSpawnEntity");
            class_PacketPlayOutSpawnEntityLiving = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutSpawnEntityLiving");
            class_PacketPlayOutEntityMetadata = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutEntityMetadata");
            class_PacketPlayOutEntityStatus = NMSUtils.fixBukkitClass("net.minecraft.server.PacketPlayOutEntityStatus");
            class_NBTTagList_addMethod = class_NBTTagList.getMethod("add", class_NBTBase);
            class_NBTTagList_getMethod = class_NBTTagList.getMethod("get", Integer.TYPE);
            class_NBTTagList_getDoubleMethod = class_NBTTagList.getMethod("d", Integer.TYPE);
            class_NBTTagList_sizeMethod = class_NBTTagList.getMethod("size", new Class[0]);
            class_NBTTagCompound_setMethod = class_NBTTagCompound.getMethod("set", String.class, class_NBTBase);
            class_DataWatcher_watchMethod = class_DataWatcher.getMethod("watch", Integer.TYPE, Object.class);
            class_World_getEntitiesMethod = class_World.getMethod("getEntities", class_Entity, class_AxisAlignedBB);
            class_CraftWorld_getTileEntityAtMethod = class_CraftWorld.getMethod("getTileEntityAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            class_Entity_getBukkitEntityMethod = class_Entity.getMethod("getBukkitEntity", new Class[0]);
            class_AxisAlignedBB_createBBMethod = class_AxisAlignedBB.getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            class_World_explodeMethod = class_World.getMethod("createExplosion", class_Entity, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Boolean.TYPE, Boolean.TYPE);
            class_NBTTagCompound_setBooleanMethod = class_NBTTagCompound.getMethod("setBoolean", String.class, Boolean.TYPE);
            class_NBTTagCompound_setStringMethod = class_NBTTagCompound.getMethod("setString", String.class, String.class);
            class_NBTTagCompound_setIntMethod = class_NBTTagCompound.getMethod("setInt", String.class, Integer.TYPE);
            class_NBTTagCompound_removeMethod = class_NBTTagCompound.getMethod("remove", String.class);
            class_NBTTagCompound_getStringMethod = class_NBTTagCompound.getMethod("getString", String.class);
            class_NBTTagCompound_getShortMethod = class_NBTTagCompound.getMethod("getShort", String.class);
            class_NBTTagCompound_getIntMethod = class_NBTTagCompound.getMethod("getInt", String.class);
            class_NBTTagCompound_getByteMethod = class_NBTTagCompound.getMethod("getByte", String.class);
            class_NBTTagCompound_getByteArrayMethod = class_NBTTagCompound.getMethod("getByteArray", String.class);
            class_NBTTagCompound_getListMethod = class_NBTTagCompound.getMethod("getList", String.class, Integer.TYPE);
            class_CraftItemStack_copyMethod = class_CraftItemStack.getMethod("asNMSCopy", ItemStack.class);
            class_CraftItemStack_asBukkitCopyMethod = class_CraftItemStack.getMethod("asBukkitCopy", class_ItemStack);
            class_CraftItemStack_mirrorMethod = class_CraftItemStack.getMethod("asCraftMirror", class_ItemStack);
            class_ItemStack_createStackMethod = class_ItemStack.getMethod("createStack", class_NBTTagCompound);
            class_NBTTagCompound_hasKeyMethod = class_NBTTagCompound.getMethod("hasKey", String.class);
            class_NBTTagCompound_getMethod = class_NBTTagCompound.getMethod("get", String.class);
            class_NBTTagCompound_getCompoundMethod = class_NBTTagCompound.getMethod("getCompound", String.class);
            class_EntityLiving_damageEntityMethod = class_EntityLiving.getMethod("damageEntity", class_DamageSource, Float.TYPE);
            class_DamageSource_getMagicSourceMethod = class_DamageSource.getMethod("b", class_Entity, class_Entity);
            class_World_addEntityMethod = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            class_NBTCompressedStreamTools_loadFileMethod = class_NBTCompressedStreamTools.getMethod("a", InputStream.class);
            class_TileEntity_loadMethod = class_TileEntity.getMethod("a", class_NBTTagCompound);
            class_TileEntity_saveMethod = class_TileEntity.getMethod("b", class_NBTTagCompound);
            class_TileEntity_updateMethod = class_TileEntity.getMethod("update", new Class[0]);
            class_Entity_setLocationMethod = class_Entity.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            class_Entity_getIdMethod = class_Entity.getMethod("getId", new Class[0]);
            class_Entity_getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            class_CraftInventoryCustom_constructor = class_CraftInventoryCustom.getConstructor(InventoryHolder.class, Integer.TYPE, String.class);
            class_EntityFireworkConstructor = class_EntityFirework.getConstructor(class_World, Double.TYPE, Double.TYPE, Double.TYPE, class_ItemStack);
            class_PacketSpawnEntityConstructor = class_PacketPlayOutSpawnEntity.getConstructor(class_Entity, Integer.TYPE);
            class_PacketSpawnLivingEntityConstructor = class_PacketPlayOutSpawnEntityLiving.getConstructor(class_EntityLiving);
            class_PacketPlayOutEntityMetadata_Constructor = class_PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, class_DataWatcher, Boolean.TYPE);
            class_PacketPlayOutEntityStatus_Constructor = class_PacketPlayOutEntityStatus.getConstructor(class_Entity, Byte.TYPE);
            class_PacketPlayOutEntityDestroy_Constructor = class_PacketPlayOutEntityDestroy.getConstructor(int[].class);
            class_Entity_invulnerableField = class_Entity.getDeclaredField("invulnerable");
            class_Entity_invulnerableField.setAccessible(true);
            class_Entity_motXField = class_Entity.getDeclaredField("motX");
            class_Entity_motXField.setAccessible(true);
            class_Entity_motYField = class_Entity.getDeclaredField("motY");
            class_Entity_motYField.setAccessible(true);
            class_Entity_motZField = class_Entity.getDeclaredField("motZ");
            class_Entity_motZField.setAccessible(true);
            class_ItemStack_tagField = class_ItemStack.getDeclaredField("tag");
            class_ItemStack_tagField.setAccessible(true);
            class_DamageSource_MagicField = class_DamageSource.getField("MAGIC");
            class_EntityTNTPrimed_source = class_EntityTNTPrimed.getDeclaredField("source");
            class_EntityTNTPrimed_source.setAccessible(true);
            class_Firework_ticksFlownField = class_EntityFirework.getDeclaredField("ticksFlown");
            class_Firework_ticksFlownField.setAccessible(true);
            class_Firework_expectedLifespanField = class_EntityFirework.getDeclaredField("expectedLifespan");
            class_Firework_expectedLifespanField.setAccessible(true);
            class_NBTTagList_consructor = class_NBTTagString.getConstructor(String.class);
            class_NBTTagByte_constructor = class_NBTTagByte.getConstructor(Byte.TYPE);
            class_ItemStack_count = class_ItemStack.getDeclaredField("count");
            class_ItemStack_count.setAccessible(true);
            class_NBTTagList_list = class_NBTTagList.getDeclaredField("list");
            class_NBTTagList_list.setAccessible(true);
            isLegacy = false;
            try {
                class_GameProfile = NMSUtils.getClass("com.mojang.authlib.GameProfile");
                class_GameProfileProperty = NMSUtils.getClass("com.mojang.authlib.properties.Property");
                class_CraftSkull_profile = class_CraftSkull.getDeclaredField("profile");
                class_CraftSkull_profile.setAccessible(true);
                class_CraftMetaSkull_profile = class_CraftMetaSkull.getDeclaredField("profile");
                class_CraftMetaSkull_profile.setAccessible(true);
                class_GameProfile_properties = class_GameProfile.getDeclaredField("properties");
                class_GameProfile_properties.setAccessible(true);
                class_GameProfileProperty_value = class_GameProfileProperty.getDeclaredField("value");
                class_GameProfileProperty_value.setAccessible(true);
                class_CraftMetaBanner = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftMetaBanner");
                class_CraftMetaBanner_getBaseColorMethod = class_CraftMetaBanner.getMethod("getBaseColor", new Class[0]);
                class_CraftMetaBanner_getPatternsMethod = class_CraftMetaBanner.getMethod("getPatterns", new Class[0]);
                class_CraftMetaBanner_setPatternsMethod = class_CraftMetaBanner.getMethod("setPatterns", List.class);
                class_CraftMetaBanner_setBaseColorMethod = class_CraftMetaBanner.getMethod("setBaseColor", DyeColor.class);
                class_CraftBanner = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.block.CraftBanner");
                class_CraftBanner_getBaseColorMethod = class_CraftBanner.getMethod("getBaseColor", new Class[0]);
                class_CraftBanner_getPatternsMethod = class_CraftBanner.getMethod("getPatterns", new Class[0]);
                class_CraftBanner_setPatternsMethod = class_CraftBanner.getMethod("setPatterns", List.class);
                class_CraftBanner_setBaseColorMethod = class_CraftBanner.getMethod("setBaseColor", DyeColor.class);
                class_BlockPosition = NMSUtils.fixBukkitClass("net.minecraft.server.BlockPosition");
                class_EnumDirection = NMSUtils.fixBukkitClass("net.minecraft.server.EnumDirection");
                class_BlockPositionConstructor = class_BlockPosition.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                class_EntityPaintingConstructor = class_EntityPainting.getConstructor(class_World, class_BlockPosition, class_EnumDirection);
                class_EntityItemFrameConstructor = class_EntityItemFrame.getConstructor(class_World, class_BlockPosition, class_EnumDirection);
            }
            catch (Throwable legacy) {
                isLegacy = true;
                class_EntityPaintingConstructor = class_EntityPainting.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                class_EntityItemFrameConstructor = class_EntityItemFrame.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            class_PacketPlayOutMapChunkBulk = NMSUtils.getVersionedBukkitClass("net.minecraft.server.PacketPlayOutMapChunkBulk", "net.minecraft.server.Packet56MapChunkBulk");
        }
        catch (Throwable ex) {
            failed = true;
            ex.printStackTrace();
        }
    }
}

