/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import net.dandielo.citizens.traders_v3.core.exceptions.InvalidItemException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeInvalidValueException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Attribute(name="Magic Spell", key="magic_spell", priority=5)
public class SpellAttr
extends ItemAttr {
    private String spellKey;

    public SpellAttr(String key) {
        super(key);
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        MagicAPI api = MagicPlugin.getAPI();
        String spellKey = api.getSpell(itemStack);
        if (spellKey == null) {
            throw new AttributeValueNotFoundException();
        }
        this.spellKey = spellKey;
        this.item.addFlag(".nostack");
    }

    public void onLoad(String itemData) throws AttributeInvalidValueException {
        if (itemData == null || itemData.isEmpty()) {
            throw new AttributeInvalidValueException(this.info, "No data");
        }
        this.spellKey = itemData;
    }

    public String onSave() {
        if (this.spellKey == null) {
            this.spellKey = "";
        }
        return this.spellKey;
    }

    public void onAssign(ItemStack itemStack) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        if (this.spellKey != null && !this.spellKey.isEmpty()) {
            InventoryUtils.setMeta(itemStack, "spell", this.spellKey);
        }
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        if (this.spellKey != null && !this.spellKey.isEmpty()) {
            MagicAPI api = MagicPlugin.getAPI();
            ItemMeta meta = itemStack.getItemMeta();
            itemStack = api.createSpellItem(this.spellKey);
            if (!endItem && meta != null) {
                ItemMeta newMeta = itemStack.getItemMeta();
                newMeta.setLore(meta.getLore());
                itemStack.setItemMeta(newMeta);
            }
        }
        return itemStack;
    }

    public boolean equalsWeak(ItemAttr other) {
        if (other instanceof SpellAttr) {
            return this.spellKey.equalsIgnoreCase(((SpellAttr)other).spellKey);
        }
        return false;
    }

    public boolean equalsStrong(ItemAttr other) {
        if (other instanceof SpellAttr) {
            return this.spellKey.equalsIgnoreCase(((SpellAttr)other).spellKey);
        }
        return false;
    }
}

