/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class HeroesSkillSpell
extends BaseSpell {
    private String skillKey;
    private Skill skill;
    private HeroesManager heroes;
    private MagicController magic;
    private CastingCost manaCost = new CastingCost("mana", 1);
    private boolean isCasting = false;

    @Override
    public boolean cast(ConfigurationSection extraParameters, Location defaultLocation) {
        boolean success = false;
        this.isCasting = true;
        try {
            success = super.cast(extraParameters, defaultLocation);
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Error using Heroes skill", ex);
        }
        this.isCasting = false;
        return success;
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection template) {
        super.loadTemplate(key, template);
        this.skillKey = key.substring(7);
        this.showUndoable = false;
        if (!(this.controller instanceof MagicController)) {
            return;
        }
        this.magic = (MagicController)this.controller;
        this.heroes = this.magic.getHeroes();
        if (this.heroes == null) {
            return;
        }
        this.skill = this.heroes.getSkill(this.skillKey);
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        CommandSender sender = this.mage.getCommandSender();
        this.controller.getPlugin().getServer().dispatchCommand(sender, "skill " + this.skillKey);
        return SpellResult.CAST;
    }

    @Override
    public void addLore(Messages messages, Mage mage, Wand apiWand, List<String> lore) {
        int mana;
        String cooldownDescription;
        int cooldown;
        String description;
        if (mage == null || !mage.isPlayer()) {
            return;
        }
        Hero hero = this.heroes.getHero(mage.getPlayer());
        if (hero == null) {
            return;
        }
        int level = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
        String levelDescription = this.controller.getMessages().get("spell.level_description").replace("$level", Integer.toString(level));
        if (levelDescription != null && levelDescription.length() > 0) {
            lore.add(ChatColor.GOLD + levelDescription);
        }
        if ((description = this.getDescription()) == null || description.isEmpty()) {
            description = this.skill.getDescription(hero);
        }
        if (description != null && description.length() > 0) {
            InventoryUtils.wrapText(description, 24, lore);
        }
        if ((cooldown = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.COOLDOWN, (int)0, (boolean)true)) > 0 && (cooldownDescription = HeroesSkillSpell.getCooldownDescription(messages, cooldown)) != null && !cooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
        }
        if ((mana = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.MANA, (int)0, (boolean)true)) > 0) {
            String manaDescription = messages.get("costs.heroes_mana").replace("$amount", Integer.toString(mana));
            lore.add(ChatColor.YELLOW + messages.get("wand.costs_description").replace("$description", manaDescription));
        }
    }

    @Override
    public long getRemainingCooldown() {
        if (this.isCasting || this.skill == null || this.mage == null) {
            return 0L;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return 0L;
        }
        Hero hero = this.heroes.getHero(this.mage.getPlayer());
        if (hero == null) {
            return 0L;
        }
        Long cooldown = hero.getCooldown(this.skillKey);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return Math.max(0L, cooldown - now);
    }

    @Override
    public CastingCost getRequiredCost() {
        if (this.isCasting || this.skill == null || this.mage == null) {
            return null;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return null;
        }
        Hero hero = this.heroes.getHero(this.mage.getPlayer());
        if (hero == null) {
            return null;
        }
        int mana = SkillConfigManager.getUseSetting((Hero)hero, (Skill)this.skill, (SkillSetting)SkillSetting.MANA, (int)0, (boolean)true);
        if (mana == 0 || hero.getMana() > mana) {
            return null;
        }
        return this.manaCost;
    }
}

