/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.dynmap;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.io.InvalidClassException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;

public class DynmapController {
    private final Plugin plugin;
    private DynmapCommonAPI dynmap = null;
    private DateFormat dateFormatter = new SimpleDateFormat("yy-MM-dd HH:mm");

    public DynmapController(Plugin plugin, Plugin dynmapPlugin) throws InvalidClassException {
        this.plugin = plugin;
        if (dynmapPlugin != null && !(dynmapPlugin instanceof DynmapCommonAPI)) {
            throw new InvalidClassException("Dynmap plugin found, but class is not DynmapCommonAPI");
        }
        this.dynmap = (DynmapCommonAPI)dynmapPlugin;
    }

    public void showCastMarker(Mage mage, Spell spell, SpellResult result) {
        if (this.dynmap != null && this.dynmap.markerAPIInitialized()) {
            PolyLineMarker targetMarker;
            MarkerAPI markers = this.dynmap.getMarkerAPI();
            MarkerSet spellSet = markers.getMarkerSet("Spells");
            if (spellSet == null) {
                spellSet = markers.createMarkerSet("Spells", "Spell Casts", null, false);
            }
            String markerId = "Spell-" + mage.getId();
            String targetId = "SpellTarget-" + mage.getId();
            int range = 32;
            double radius = 3.0 * (double)mage.getPower() + 3.0;
            int width = (int)(2.0 * (double)mage.getPower()) + 2;
            radius = Math.min(64.0, radius);
            width = Math.min(8, width);
            Location location = spell.getLocation();
            if (location == null) {
                return;
            }
            Color mageColor = mage.getEffectColor();
            mageColor = mageColor == null ? Color.PURPLE : mageColor;
            Color spellColor = spell.getColor();
            spellColor = spellColor == null ? mageColor : spellColor;
            String worldName = location.getWorld().getName();
            Date now = new Date();
            String label = spell.getName() + " : " + mage.getName() + " @ " + this.dateFormatter.format(now);
            CircleMarker marker = spellSet.findCircleMarker(markerId);
            if (marker != null) {
                marker.setCenter(worldName, location.getX(), location.getY(), location.getZ());
                marker.setLabel(label);
            } else {
                marker = spellSet.createCircleMarker(markerId, label, false, worldName, location.getX(), location.getY(), location.getZ(), radius, radius, false);
            }
            marker.setRadius(radius, radius);
            marker.setLineStyle(1, 0.9, spellColor.asRGB());
            marker.setFillStyle(0.5, mageColor.asRGB());
            Location target = spell.getTargetLocation();
            if (target == null) {
                target = location.clone();
                Vector direction = location.getDirection();
                direction.normalize().multiply(range);
                target.add(direction);
            }
            if ((targetMarker = spellSet.findPolyLineMarker(targetId)) != null) {
                targetMarker.setCornerLocation(0, location.getX(), location.getY(), location.getZ());
                targetMarker.setCornerLocation(1, target.getX(), target.getY(), target.getZ());
                targetMarker.setLabel(label);
            } else {
                double[] x = new double[]{location.getX(), target.getX()};
                double[] y = new double[]{location.getY(), target.getY()};
                double[] z = new double[]{location.getZ(), target.getZ()};
                targetMarker = spellSet.createPolyLineMarker(targetId, label, false, worldName, x, y, z, false);
            }
            targetMarker.setLineStyle(width, 0.8, spellColor.asRGB());
        }
    }

    public boolean isReady() {
        return this.dynmap == null || this.dynmap.markerAPIInitialized();
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmap.markerAPIInitialized()) {
            Marker marker;
            MarkerIcon wandIcon;
            MarkerAPI markers = this.dynmap.getMarkerAPI();
            MarkerSet markerSet = markers.getMarkerSet(group);
            if (markerSet == null) {
                markerSet = markers.createMarkerSet(group, group, null, false);
            }
            if ((wandIcon = markers.getMarkerIcon("wand")) == null) {
                wandIcon = markers.createMarkerIcon("wand", "Wand", this.plugin.getResource("wand_icon32.png"));
            }
            if ((marker = markerSet.findMarker(id)) == null) {
                created = true;
                marker = markerSet.createMarker(id, title, world, (double)x, (double)y, (double)z, wandIcon, false);
            } else {
                marker.setLocation(world, (double)x, (double)y, (double)z);
                marker.setLabel(title);
            }
            if (description != null) {
                marker.setDescription(description);
            }
        }
        return created;
    }

    public boolean removeMarker(String id, String group) {
        Marker marker;
        MarkerAPI markers;
        MarkerSet markerSet;
        boolean removed = false;
        if (this.dynmap != null && this.dynmap.markerAPIInitialized() && (markerSet = (markers = this.dynmap.getMarkerAPI()).getMarkerSet(group)) != null && (marker = markerSet.findMarker(id)) != null) {
            removed = true;
            marker.deleteMarker();
        }
        return removed;
    }

    public int triggerRenderOfVolume(String wid, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap == null) {
            return 0;
        }
        return this.dynmap.triggerRenderOfVolume(wid, minx, miny, minz, maxx, maxy, maxz);
    }

    public int triggerRenderOfBlock(String wid, int x, int y, int z) {
        if (this.dynmap == null) {
            return 0;
        }
        return this.dynmap.triggerRenderOfBlock(wid, x, y, z);
    }
}

