/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class MagicCitizensTrait
extends Trait {
    private String spellKey;
    private boolean npcCaster = true;
    private YamlConfiguration parameters = null;
    private double cost = 0.0;
    private MagicAPI api;

    public MagicCitizensTrait() {
        super("magic");
    }

    public void load(DataKey data) {
        this.spellKey = data.getString("spell", null);
        this.npcCaster = data.getBoolean("caster", false);
        this.cost = data.getDouble("cost", 0.0);
        String parameterString = data.getString("parameters", null);
        this.parameters = new YamlConfiguration();
        if (parameterString != null && !parameterString.isEmpty()) {
            if (!parameterString.contains(":")) {
                String[] simple = StringUtils.split((String)parameterString, (String)" ");
                if (simple.length > 0) {
                    ConfigurationUtils.addParameters(simple, (ConfigurationSection)this.parameters);
                }
            } else {
                try {
                    this.parameters.loadFromString(parameterString);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void save(DataKey data) {
        data.setString("spell", this.spellKey);
        data.setBoolean("caster", this.npcCaster);
        String parameterString = this.parameters.saveToString();
        data.setString("parameters", parameterString);
        data.setDouble("cost", this.cost);
    }

    public void onRemove() {
    }

    public void onAttach() {
        this.load((DataKey)new MemoryDataKey());
        this.api = MagicPlugin.getAPI();
    }

    @EventHandler
    public void onClick(NPCRightClickEvent event) {
        boolean result;
        if (event.getNPC() != this.getNPC() || this.spellKey == null || this.spellKey.isEmpty()) {
            return;
        }
        Player sender = event.getClicker();
        Player player = event.getClicker();
        Player entity = event.getClicker();
        if (this.cost > 0.0) {
            if (!VaultController.hasEconomy()) {
                sender.sendMessage(this.api.getMessages().get("economy.missing"));
                return;
            }
            VaultController vault = VaultController.getInstance();
            if (!vault.has(player, this.cost)) {
                sender.sendMessage(this.api.getMessages().get("economy.insufficient").replace("$cost", vault.format(this.cost)));
                return;
            }
        }
        YamlConfiguration config = this.parameters;
        if (this.npcCaster && event.getNPC().isSpawned()) {
            entity = event.getNPC().getBukkitEntity();
            sender = null;
            config = new MemoryConfiguration();
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)this.parameters);
            config.set("player", (Object)event.getClicker().getName());
        }
        if ((result = this.api.cast(this.spellKey, (ConfigurationSection)this.parameters, (CommandSender)sender, (Entity)entity)) && this.cost > 0.0) {
            VaultController vault = VaultController.getInstance();
            sender.sendMessage(this.api.getMessages().get("economy.deducted").replace("$cost", vault.format(this.cost)));
            vault.withdrawPlayer(player, this.cost);
        }
    }

    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + "Magic NPC: " + ChatColor.GOLD + this.npc.getName() + ChatColor.WHITE + "(" + ChatColor.GRAY + this.npc.getId() + ChatColor.WHITE + ")");
        String spellDescription = this.spellKey == null ? ChatColor.RED + "(None)" : ChatColor.LIGHT_PURPLE + this.spellKey;
        sender.sendMessage(ChatColor.DARK_PURPLE + "Spell: " + spellDescription);
        String casterDescription = this.npcCaster ? ChatColor.GRAY + "NPC" : ChatColor.LIGHT_PURPLE + "Player";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Caster: " + casterDescription);
        if (VaultController.hasEconomy()) {
            VaultController vault = VaultController.getInstance();
            sender.sendMessage(ChatColor.DARK_PURPLE + "Cost: " + ChatColor.GOLD + vault.format(this.cost));
        }
        sender.sendMessage(ChatColor.DARK_PURPLE + "Parameters: ");
        this.describeParameters(sender);
    }

    protected void describeParameters(CommandSender sender) {
        Set keys = this.parameters.getKeys(false);
        if (keys.size() == 0) {
            sender.sendMessage(ChatColor.GRAY + " (None)");
        }
        for (String key : keys) {
            String value = null;
            if (this.parameters.isConfigurationSection(key)) {
                ConfigurationSection child = this.parameters.getConfigurationSection(key);
                value = "(" + child.getKeys(false).size() + " values)";
            } else {
                value = this.parameters.getString(key);
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + " " + key + ": " + value);
        }
    }

    public void configure(CommandSender sender, String key, String value) {
        block20: {
            if (key == null) {
                return;
            }
            if (key.equalsIgnoreCase("spell")) {
                if (value == null) {
                    sender.sendMessage(ChatColor.RED + "Cleared spell");
                } else {
                    this.spellKey = value;
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set spell to: " + ChatColor.LIGHT_PURPLE + this.spellKey);
                }
            } else if (key.equalsIgnoreCase("parameters")) {
                if (value == null) {
                    sender.sendMessage(ChatColor.RED + "Cleared parameters");
                } else {
                    String[] params = StringUtils.split((String)value, (String)" ");
                    this.parameters = new YamlConfiguration();
                    ConfigurationUtils.addParameters(params, (ConfigurationSection)this.parameters);
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set parameters to: ");
                    this.describeParameters(sender);
                }
            } else if (key.equalsIgnoreCase("caster")) {
                if (value == null || !value.equalsIgnoreCase("true")) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as player");
                    this.npcCaster = false;
                } else {
                    this.npcCaster = true;
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as NPC");
                }
            } else if (key.equalsIgnoreCase("cost")) {
                if (value == null) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Cleared cost");
                    this.cost = 0.0;
                } else {
                    try {
                        this.cost = Double.parseDouble(value);
                        if (VaultController.hasEconomy()) {
                            VaultController vault = VaultController.getInstance();
                            sender.sendMessage(ChatColor.DARK_PURPLE + "Set cost to: " + ChatColor.GOLD + vault.format(this.cost));
                            break block20;
                        }
                        sender.sendMessage(ChatColor.DARK_PURPLE + "Set cost to " + value);
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "Invalid cost: " + value);
                    }
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Expecting: spell, parameters or caster");
            }
        }
    }
}

