/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class TargetingSpell
extends BaseSpell {
    private static final int MAX_RANGE = 511;
    private Target target = null;
    private List<Target> targets = null;
    private TargetType targetType = TargetType.OTHER;
    private boolean targetNPCs = false;
    private boolean targetInvisible = false;
    private boolean targetUnknown = true;
    private boolean targetingComplete = false;
    private boolean targetSpaceRequired = false;
    private int targetMinOffset = 0;
    protected Class<? extends Entity> targetEntityType = null;
    protected Material targetContents = null;
    private Location targetLocation;
    private Vector targetLocationOffset;
    private Vector targetDirectionOverride;
    private String targetLocationWorldName;
    protected Location targetLocation2;
    protected double targetBreakables = 0.0;
    private Entity targetEntity = null;
    private boolean bypassBuildRestriction = false;
    private boolean bypassProtection = false;
    private boolean checkProtection = false;
    private boolean allowMaxRange = false;
    private boolean bypassBackfire = false;
    private boolean useHitbox = false;
    private int range = 32;
    private double fov = 0.3;
    private double closeRange = 1.0;
    private double closeFOV = 0.5;
    private Set<Material> targetThroughMaterials = new HashSet<Material>();
    private boolean reverseTargeting = false;
    private boolean originAtTarget = false;
    private boolean ignoreBlocks = false;
    private BlockIterator blockIterator = null;
    private Block currentBlock = null;
    private Block previousBlock = null;
    private Block previousPreviousBlock = null;

    protected void initializeTargeting() {
        this.clearTarget();
        this.blockIterator = null;
        this.currentBlock = null;
        this.previousBlock = null;
        this.previousPreviousBlock = null;
        this.targetSpaceRequired = false;
        this.reverseTargeting = false;
        this.targetingComplete = false;
        this.targetMinOffset = 0;
    }

    public void setTargetType(TargetType t) {
        this.targetType = t;
        if (this.target != null) {
            this.target = null;
            this.initializeTargeting();
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        String useTargetName = null;
        if (this.currentCast != null) {
            useTargetName = this.currentCast.getTargetName();
        }
        if (useTargetName == null && this.target != null) {
            com.elmakers.mine.bukkit.block.MaterialAndData material;
            if (this.target.hasEntity() && this.getTargetType() != TargetType.BLOCK) {
                useTargetName = this.controller.getEntityDisplayName(this.target.getEntity());
            } else if (this.target.isValid() && this.getTargetType() != TargetType.OTHER_ENTITY && this.getTargetType() != TargetType.ANY_ENTITY && (material = this.target.getTargetedMaterial()) != null) {
                useTargetName = material.getName();
            }
        }
        message = useTargetName == null ? message.replace("$target", "?") : message.replace("$target", useTargetName);
        return message;
    }

    public void clearTargetThrough() {
        this.targetThroughMaterials.clear();
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.add(mat);
    }

    public void targetThrough(Set<Material> mat) {
        this.targetThroughMaterials.clear();
        this.targetThroughMaterials.addAll(mat);
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.remove(mat);
    }

    public boolean isTargetable(Material mat) {
        if (!this.allowPassThrough(mat)) {
            return true;
        }
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public boolean isOriginAtTarget() {
        return this.originAtTarget;
    }

    public void setTargetSpaceRequired() {
        this.targetSpaceRequired = true;
    }

    public void setTargetMinOffset(int offset) {
        this.targetMinOffset = offset;
    }

    public void setTarget(Location location) {
        this.target = new Target(this.getEyeLocation(), location == null ? null : location.getBlock());
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.bypassBuildRestriction || super.hasBuildPermission(block);
    }

    public void offsetTarget(int dx, int dy, int dz) {
        Location location = this.getLocation();
        if (location == null) {
            return;
        }
        location.add((double)dx, (double)dy, (double)dz);
        this.initializeBlockIterator(location);
    }

    protected boolean initializeBlockIterator(Location location) {
        if (this.blockIterator != null) {
            return true;
        }
        if (location.getBlockY() < 0) {
            location = location.clone();
            location.setY(0.0);
        }
        if (location.getBlockY() > location.getWorld().getMaxHeight()) {
            location = location.clone();
            location.setY((double)location.getWorld().getMaxHeight());
        }
        try {
            this.blockIterator = new BlockIterator(location, 1.65, this.getMaxRange());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected Block getNextBlock() {
        this.previousPreviousBlock = this.previousBlock;
        this.previousBlock = this.currentBlock;
        this.currentBlock = this.blockIterator == null || !this.blockIterator.hasNext() ? null : this.blockIterator.next();
        return this.currentBlock;
    }

    public Block getCurBlock() {
        return this.currentBlock;
    }

    public Block getPreviousBlock() {
        return this.previousBlock;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void retarget(int range, double fov, double closeRange, double closeFOV, boolean useHitbox, Vector offset, boolean targetSpaceRequired, int targetMinOffset) {
        this.initializeTargeting();
        if (offset != null) {
            this.offsetTarget(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        }
        this.targetSpaceRequired = targetSpaceRequired;
        this.targetMinOffset = targetMinOffset;
        this.range = range;
        this.fov = fov;
        this.closeRange = closeRange;
        this.closeFOV = closeFOV;
        this.useHitbox = useHitbox;
        this.target();
    }

    public void retarget(int range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        this.retarget(range, fov, closeRange, closeFOV, useHitbox, null, this.targetSpaceRequired, this.targetMinOffset);
    }

    @Override
    public void target() {
        if (this.target == null) {
            this.getTarget();
        }
    }

    protected Target getTarget() {
        Location location;
        int breakable;
        this.target = this.findTarget();
        Block block = this.target.getBlock();
        if (block != null && !this.bypassBackfire && block.hasMetadata("backfire")) {
            List metadata = block.getMetadata("backfire");
            for (MetadataValue value : metadata) {
                if (!value.getOwningPlugin().equals(this.controller.getPlugin()) || !(random.nextDouble() < value.asDouble())) continue;
                final Entity mageEntity = this.mage.getEntity();
                final Location location2 = this.getLocation();
                final Location originLocation = block.getLocation();
                Vector direction = location2.getDirection();
                CompatibilityUtils.setDirection(originLocation, direction.multiply(-1));
                this.location = originLocation;
                this.backfire();
                final Collection<EffectPlayer> effects = this.getEffects("cast");
                if (effects.size() > 0) {
                    Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            for (EffectPlayer player : effects) {
                                player.setMaterial(TargetingSpell.this.getEffectMaterial());
                                player.setColor(TargetingSpell.this.mage.getEffectColor());
                                player.start(originLocation, null, location2, mageEntity);
                            }
                        }
                    }, 5L);
                }
                this.target = new Target(this.getEyeLocation(), mageEntity);
            }
        }
        if (this.targetBreakables > 0.0 && this.target.isValid() && block != null && block.hasMetadata("breakable") && (breakable = (int)(this.targetBreakables > 1.0 ? this.targetBreakables : (double)(random.nextDouble() < this.targetBreakables ? 1 : 0))) > 0) {
            List metadata = block.getMetadata("breakable");
            for (MetadataValue value : metadata) {
                if (!value.getOwningPlugin().equals(this.controller.getPlugin())) continue;
                this.breakBlock(block, value.asInt() + breakable - 1);
                break;
            }
        }
        if (this.targetLocationOffset != null) {
            this.target.add(this.targetLocationOffset);
        }
        if (this.targetDirectionOverride != null) {
            this.target.setDirection(this.targetDirectionOverride);
        }
        if (this.targetLocationWorldName != null && this.targetLocationWorldName.length() > 0 && (location = this.target.getLocation()) != null) {
            World targetWorld = location.getWorld();
            this.target.setWorld(ConfigurationUtils.overrideWorld(this.targetLocationWorldName, targetWorld, this.controller.canCreateWorlds()));
        }
        if (this.originAtTarget && this.target.isValid()) {
            Location previous = this.location;
            if (previous == null && this.mage != null) {
                previous = this.mage.getLocation();
            }
            this.location = this.target.getLocation().clone();
            if (previous != null) {
                this.location.setPitch(previous.getPitch());
                this.location.setYaw(previous.getYaw());
            }
        }
        if (this.currentCast != null) {
            Entity targetEntity = this.target != null ? this.target.getEntity() : null;
            Location targetLocation = this.target != null ? this.target.getLocation() : null;
            this.currentCast.setTargetLocation(targetLocation);
            this.currentCast.setTargetEntity(targetEntity);
        }
        return this.target;
    }

    public Target findTarget() {
        Location location = this.getEyeLocation();
        if (this.targetType != TargetType.NONE && this.targetType != TargetType.BLOCK && this.targetEntity != null) {
            return new Target(location, this.targetEntity);
        }
        Entity mageEntity = this.mage.getEntity();
        if (this.targetType == TargetType.SELF && mageEntity != null) {
            return new Target(location, mageEntity);
        }
        CommandSender sender = this.mage.getCommandSender();
        if (this.targetType == TargetType.SELF && mageEntity == null && sender != null && sender instanceof BlockCommandSender) {
            BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
            return new Target(commandBlock.getBlock().getLocation(), commandBlock.getBlock());
        }
        if (this.targetType == TargetType.SELF && location != null) {
            return new Target(location, location.getBlock());
        }
        if (this.targetType == TargetType.SELF) {
            return new Target(location);
        }
        if (this.targetType != TargetType.NONE && this.targetLocation != null) {
            return new Target(location, this.targetLocation.getBlock());
        }
        if (this.targetType == TargetType.NONE) {
            return new Target(location);
        }
        Block block = null;
        if (!this.ignoreBlocks) {
            this.findTargetBlock();
            block = this.getCurBlock();
        }
        if (this.targetType == TargetType.BLOCK) {
            return new Target(location, block);
        }
        Target targetBlock = block == null ? null : new Target(location, block);
        Target entityTarget = this.getEntityTarget();
        if (entityTarget != null && !this.canCast(entityTarget.getLocation())) {
            entityTarget = null;
        }
        if (targetBlock != null && !this.canCast(targetBlock.getLocation())) {
            targetBlock = null;
        }
        if (this.targetType == TargetType.OTHER_ENTITY && entityTarget == null) {
            return new Target(location);
        }
        if (this.targetType == TargetType.ANY_ENTITY && entityTarget == null) {
            return new Target(location, mageEntity);
        }
        if (entityTarget == null && this.targetType == TargetType.ANY && mageEntity != null) {
            return new Target(location, mageEntity, targetBlock == null ? null : targetBlock.getBlock());
        }
        if (targetBlock != null && entityTarget != null) {
            if (targetBlock.getDistanceSquared() < entityTarget.getDistanceSquared()) {
                entityTarget = null;
            } else {
                targetBlock = null;
            }
        }
        if (entityTarget != null) {
            return entityTarget;
        }
        if (targetBlock != null) {
            return targetBlock;
        }
        return new Target(location);
    }

    public Target getCurrentTarget() {
        if (this.target == null) {
            this.target = new Target(this.getEyeLocation());
        }
        return this.target;
    }

    public void clearTarget() {
        this.target = null;
        this.targets = null;
        this.targetLocation = null;
    }

    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    protected Target getEntityTarget() {
        if (this.targetEntityType == null) {
            return null;
        }
        List<Target> scored = this.getAllTargetEntities();
        if (scored.size() <= 0) {
            return null;
        }
        return scored.get(0);
    }

    public List<Target> getAllTargetEntities() {
        return this.getAllTargetEntities(this.getMaxRange());
    }

    protected List<Target> getAllTargetEntities(double range) {
        return this.getAllTargetEntities(this.getEyeLocation(), this.mage.getEntity(), range, this.fov, this.closeRange, this.closeFOV, this.useHitbox);
    }

    public List<Target> getAllTargetEntities(Location sourceLocation, Entity sourceEntity, double range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        if (this.targets != null) {
            return this.targets;
        }
        this.targets = new ArrayList<Target>();
        if (this.currentBlock != null && sourceLocation != null && sourceLocation.getWorld().equals(this.currentBlock.getWorld())) {
            range = Math.min(range, sourceLocation.distance(this.currentBlock.getLocation()));
        }
        int rangeSquared = (int)Math.floor(range * range);
        List<Entity> entities = null;
        range = Math.min(range, 72.0);
        if (sourceLocation == null && sourceEntity != null) {
            entities = sourceEntity.getNearbyEntities(range, range, range);
        } else if (sourceLocation != null) {
            entities = CompatibilityUtils.getNearbyEntities(sourceLocation, range, range, range);
        }
        if (entities == null) {
            return this.targets;
        }
        for (Entity entity : entities) {
            if (entity == this.mage.getEntity() || !this.targetUnknown && entity.getType() == EntityType.UNKNOWN || !this.targetNPCs && this.controller.isNPC(entity) || entity.hasMetadata("notarget") || entity.getLocation().distanceSquared(sourceLocation) > (double)rangeSquared || !this.controller.isElemental(entity) && !this.canTarget(entity) || this.isSuperProtected(entity) || !this.targetInvisible && entity instanceof LivingEntity && ((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY)) continue;
            Target newScore = null;
            newScore = useHitbox ? new Target(sourceLocation, entity, (int)range, useHitbox) : new Target(sourceLocation, entity, (int)range, fov, closeRange, closeFOV);
            if (newScore.getScore() <= 0) continue;
            this.targets.add(newScore);
        }
        Collections.sort(this.targets);
        return this.targets;
    }

    @Override
    public boolean canTarget(Entity entity) {
        ItemFrame itemFrame;
        ItemStack item;
        if (!this.targetUnknown && entity.getType() == EntityType.UNKNOWN) {
            return false;
        }
        if (!this.targetNPCs && this.controller.isNPC(entity)) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkProtection && player.hasPermission("Magic.protected." + this.getKey())) {
                return false;
            }
            if (this.controller.isMage(entity) && this.controller.getMage(entity).isSuperProtected()) {
                return false;
            }
        }
        if (this.targetEntityType == null) {
            return true;
        }
        if (this.targetContents != null && entity instanceof ItemFrame && ((item = (itemFrame = (ItemFrame)entity).getItem()) == null || item.getType() != this.targetContents)) {
            return false;
        }
        return this.targetEntityType.isAssignableFrom(entity.getClass());
    }

    public boolean isSuperProtected(Mage mage) {
        return !this.bypassProtection && mage.isSuperProtected();
    }

    protected boolean isSuperProtected(Entity entity) {
        if (this.bypassProtection || !this.controller.isMage(entity)) {
            return false;
        }
        Mage targetMage = this.controller.getMage(entity);
        return this.isSuperProtected(targetMage);
    }

    protected int getMaxRange() {
        if (this.allowMaxRange) {
            return Math.min(511, this.range);
        }
        return Math.min(511, (int)(this.mage.getRangeMultiplier() * (float)this.range));
    }

    protected int getMaxRangeSquared() {
        int maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    protected void setMaxRange(int range) {
        this.range = range;
    }

    public boolean isTransparent(Material material) {
        return this.targetThroughMaterials.contains(material);
    }

    protected void findTargetBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return;
        }
        if (this.targetingComplete) {
            return;
        }
        if (!this.initializeBlockIterator(location)) {
            return;
        }
        this.currentBlock = null;
        this.previousBlock = null;
        this.previousPreviousBlock = null;
        Block block = this.getNextBlock();
        while (block != null) {
            if (this.targetMinOffset <= 0) {
                if (this.targetSpaceRequired ? !this.allowPassThrough(block.getType()) || this.isOkToStandIn(block.getType()) && this.isOkToStandIn(block.getRelative(BlockFace.UP).getType()) : !this.bypassProtection && block.hasMetadata("breakable") || this.isTargetable(block.getType())) {
                    break;
                }
            } else {
                --this.targetMinOffset;
            }
            block = this.getNextBlock();
        }
        if (block == null && this.allowMaxRange) {
            this.currentBlock = this.previousBlock;
            this.previousBlock = this.previousPreviousBlock;
        }
        this.targetingComplete = true;
    }

    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock.getType())) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    public Block findBlockUnder(Block block) {
        int depth = 0;
        if (this.targetThroughMaterials.contains(block.getType())) {
            while (depth < this.verticalSearchDistance && this.targetThroughMaterials.contains(block.getType())) {
                ++depth;
                block = block.getRelative(BlockFace.DOWN);
            }
        } else {
            while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains(block.getType())) {
                ++depth;
                block = block.getRelative(BlockFace.UP);
            }
            block = block.getRelative(BlockFace.DOWN);
        }
        return block;
    }

    public Block findSpaceAbove(Block block) {
        int depth = 0;
        while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains(block.getType())) {
            ++depth;
            block = block.getRelative(BlockFace.UP);
        }
        return block;
    }

    @Override
    protected void reset() {
        super.reset();
        this.initializeTargeting();
    }

    protected void breakBlock(Block block, int recursion) {
        if (!block.hasMetadata("breakable")) {
            return;
        }
        Location blockLocation = block.getLocation();
        Location effectLocation = blockLocation.add(0.5, 0.5, 0.5);
        effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, block.getType().getId());
        UndoList undoList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(blockLocation);
        if (undoList != null) {
            undoList.add(block);
        }
        block.removeMetadata("breakable", this.mage.getController().getPlugin());
        block.removeMetadata("backfire", this.mage.getController().getPlugin());
        block.setType(Material.AIR);
        if (--recursion > 0) {
            this.breakBlock(block.getRelative(BlockFace.UP), recursion);
            this.breakBlock(block.getRelative(BlockFace.DOWN), recursion);
            this.breakBlock(block.getRelative(BlockFace.EAST), recursion);
            this.breakBlock(block.getRelative(BlockFace.WEST), recursion);
            this.breakBlock(block.getRelative(BlockFace.NORTH), recursion);
            this.breakBlock(block.getRelative(BlockFace.SOUTH), recursion);
        }
    }

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.useHitbox = parameters.getBoolean("hitbox", false);
        this.range = parameters.getInt("range", 32);
        this.fov = parameters.getDouble("fov", 0.3);
        this.closeRange = parameters.getDouble("close_range", 1.0);
        this.closeFOV = parameters.getDouble("close_fov", 0.5);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", false);
        this.bypassBackfire = parameters.getBoolean("bypass_backfire", false);
        this.bypassProtection = parameters.getBoolean("bypass_protection", false);
        this.bypassProtection = parameters.getBoolean("bp", this.bypassProtection);
        this.checkProtection = parameters.getBoolean("check_protection", false);
        this.targetBreakables = parameters.getDouble("target_breakables", 0.0);
        this.reverseTargeting = parameters.getBoolean("reverse_targeting", false);
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
        if (parameters.contains("transparent")) {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet(parameters.getString("transparent")));
        } else {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet("transparent"));
        }
        this.targetMinOffset = parameters.getInt("target_min_offset", 0);
        this.targetMinOffset = parameters.getInt("tmo", this.targetMinOffset);
        if (parameters.contains("target")) {
            String targetTypeName = parameters.getString("target");
            try {
                this.targetType = TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid target_type: " + targetTypeName);
                this.targetType = TargetType.OTHER;
            }
        } else {
            this.targetType = TargetType.OTHER;
        }
        this.targetNPCs = parameters.getBoolean("target_npc", false);
        this.targetInvisible = parameters.getBoolean("target_invisible", false);
        this.targetUnknown = parameters.getBoolean("target_unknown", true);
        if (parameters.contains("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                Class<?> typeClass = Class.forName("org.bukkit.entity." + entityTypeName);
                if (Entity.class.isAssignableFrom(typeClass)) {
                    this.targetEntityType = typeClass;
                } else {
                    this.controller.getLogger().warning("Entity type: " + entityTypeName + " not assignable to Entity");
                }
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity type: " + entityTypeName);
                this.targetEntityType = null;
            }
        }
        this.targetContents = ConfigurationUtils.getMaterial(parameters, "target_contents", null);
        this.originAtTarget = parameters.getBoolean("origin_at_target", false);
        this.ignoreBlocks = parameters.getBoolean("ignore_blocks", false);
        Location defaultLocation = this.getLocation();
        this.targetLocation = ConfigurationUtils.overrideLocation(parameters, "t", defaultLocation, this.controller.canCreateWorlds());
        this.targetLocationOffset = null;
        this.targetDirectionOverride = null;
        Double otxValue = ConfigurationUtils.getDouble(parameters, "otx", null);
        Double otyValue = ConfigurationUtils.getDouble(parameters, "oty", null);
        Double otzValue = ConfigurationUtils.getDouble(parameters, "otz", null);
        if (otxValue != null || otzValue != null || otyValue != null) {
            this.targetLocationOffset = new Vector(otxValue == null ? 0.0 : otxValue, otyValue == null ? 0.0 : otyValue, otzValue == null ? 0.0 : otzValue);
        }
        this.targetLocationWorldName = parameters.getString("otworld");
        Double tdxValue = ConfigurationUtils.getDouble(parameters, "otdx", null);
        Double tdyValue = ConfigurationUtils.getDouble(parameters, "otdy", null);
        Double tdzValue = ConfigurationUtils.getDouble(parameters, "otdz", null);
        if (tdxValue != null || tdzValue != null || tdyValue != null) {
            this.targetDirectionOverride = new Vector(tdxValue == null ? 0.0 : tdxValue, tdyValue == null ? 0.0 : tdyValue, tdzValue == null ? 0.0 : tdzValue);
        }
        defaultLocation = this.targetLocation == null ? defaultLocation : this.targetLocation;
        this.targetLocation2 = ConfigurationUtils.overrideLocation(parameters, "t2", defaultLocation, this.controller.canCreateWorlds());
        if (parameters.contains("player")) {
            Player player = this.controller.getPlugin().getServer().getPlayer(parameters.getString("player"));
            if (player != null) {
                this.targetLocation = player.getLocation();
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        if (this.isUnderwater()) {
            this.targetThroughMaterials.add(Material.WATER);
            this.targetThroughMaterials.add(Material.STATIONARY_WATER);
        }
    }

    @Override
    protected String getDisplayMaterialName() {
        if (this.target != null && this.target.isValid()) {
            return MaterialBrush.getMaterialName(this.target.getBlock());
        }
        return super.getDisplayMaterialName();
    }

    @Override
    protected void onBackfire() {
        this.targetType = TargetType.SELF;
    }

    @Override
    public Location getTargetLocation() {
        if (this.target != null && this.target.isValid()) {
            return this.target.getLocation();
        }
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        if (this.target != null && this.target.isValid()) {
            return this.target.getEntity();
        }
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        if (this.target != null && this.target.isValid()) {
            Block block = this.target.getBlock();
            com.elmakers.mine.bukkit.block.MaterialAndData targetMaterial = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
            if (targetMaterial.getMaterial() == Material.AIR) {
                targetMaterial.setMaterial(DEFAULT_EFFECT_MATERIAL);
            }
            return targetMaterial;
        }
        return super.getEffectMaterial();
    }

    public Class<? extends Entity> getTargetEntityType() {
        return this.targetEntityType;
    }
}

