/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.heroes.HeroesSkillSpell;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HeroesManager {
    private Heroes heroes;
    private CharacterManager characters;
    private SkillManager skills;
    private static final Set<String> emptySkills = new HashSet<String>();
    private static final List<String> emptySkillList = new ArrayList<String>();

    public HeroesManager(Plugin plugin, Plugin heroesPlugin) {
        if (!(heroesPlugin instanceof Heroes)) {
            plugin.getLogger().warning("Heroes found, but is not instance of Heroes plugin!");
            return;
        }
        this.heroes = (Heroes)heroesPlugin;
        this.characters = this.heroes.getCharacterManager();
        this.skills = this.heroes.getSkillManager();
        if (this.heroes != null && this.characters != null && this.skills != null) {
            plugin.getLogger().warning("Heroes found, skills available for wand use");
        } else {
            plugin.getLogger().warning("Heroes found, but failed to integrate!");
        }
    }

    public boolean canUseSkill(Player player, String skillName) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return false;
        }
        return hero.canUseSkill(skillName);
    }

    public List<String> getSkillList(Player player, boolean showUnuseable) {
        if (this.skills == null) {
            return emptySkillList;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkillList;
        }
        Set<String> skillSet = this.getSkills(player, showUnuseable);
        if (skillSet.size() == 0) {
            return emptySkillList;
        }
        TreeMultimap skillMap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new Comparator<Skill>(){

            @Override
            public int compare(Skill skill1, Skill skill2) {
                return skill1.getName().compareTo(skill2.getName());
            }
        });
        for (String skillName : skillSet) {
            Skill skill = this.skills.getSkill(skillName);
            if (skill == null) continue;
            int level = SkillConfigManager.getUseSetting((Hero)hero, (Skill)skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
            skillMap.put((Object)level, (Object)skill);
        }
        ArrayList<String> skillNames = new ArrayList<String>();
        for (Skill skill : skillMap.values()) {
            skillNames.add(skill.getName());
        }
        return skillNames;
    }

    public Set<String> getSkills(Player player) {
        return this.getSkills(player, false);
    }

    public Set<String> getSkills(Player player, boolean showUnuseable) {
        HeroClass secondClass;
        if (this.skills == null) {
            return emptySkills;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkills;
        }
        HeroClass heroClass = hero.getHeroClass();
        if (heroClass == null) {
            return emptySkills;
        }
        HashSet<String> skillSet = new HashSet<String>();
        if (heroClass != null) {
            Set classSkills = heroClass.getSkillNames();
            for (String classSkill : classSkills) {
                Skill skill = this.skills.getSkill(classSkill);
                if (!showUnuseable && !hero.canUseSkill(skill) || !SkillConfigManager.getRaw((Skill)skill, (String)"wand", (String)"true").equalsIgnoreCase("true")) continue;
                skillSet.add(classSkill);
            }
        }
        if ((secondClass = hero.getSecondClass()) != null) {
            Set classSkills = secondClass.getSkillNames();
            for (String classSkill : classSkills) {
                Skill skill = this.skills.getSkill(classSkill);
                if (!showUnuseable && !hero.canUseSkill(skill) || !SkillConfigManager.getRaw((Skill)skill, (String)"wand", (String)"true").equalsIgnoreCase("true")) continue;
                skillSet.add(classSkill);
            }
        }
        return skillSet;
    }

    public SpellTemplate createSkillSpell(MagicController controller, String skillName) {
        if (this.skills == null) {
            return null;
        }
        Skill skill = this.skills.getSkill(skillName);
        if (skill == null) {
            return null;
        }
        HeroesSkillSpell newSpell = new HeroesSkillSpell();
        newSpell.initialize(controller);
        MemoryConfiguration config = new MemoryConfiguration();
        config.set("icon", (Object)SkillConfigManager.getRaw((Skill)skill, (String)"icon", (String)controller.getDefaultSkillIcon()));
        config.set("icon_url", (Object)SkillConfigManager.getRaw((Skill)skill, (String)"icon-url", null));
        config.set("name", (Object)skill.getName());
        config.set("description", (Object)SkillConfigManager.getRaw((Skill)skill, (String)"description", null));
        newSpell.loadTemplate("heroes*" + skillName, (ConfigurationSection)config);
        return newSpell;
    }

    protected Skill getSkill(String key) {
        if (this.skills == null) {
            return null;
        }
        return this.skills.getSkill(key);
    }

    protected Hero getHero(Player player) {
        if (this.characters == null) {
            return null;
        }
        return this.characters.getHero(player);
    }

    public int getMaxMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getMaxMana();
    }

    public int getManaRegen(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getManaRegen();
    }

    public int getMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getMana();
    }

    public void removeMana(Player player, int amount) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.setMana(Math.max(0, hero.getMana() - amount));
    }
}

