/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import net.dandielo.citizens.traders_v3.core.exceptions.InvalidItemException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeInvalidValueException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Attribute(name="Magic Material Brush", key="magic_brush", priority=5)
public class BrushAttr
extends ItemAttr {
    private String brushKey;

    public BrushAttr(String key) {
        super(key);
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        MagicAPI api = MagicPlugin.getAPI();
        String brushKey = api.getBrush(itemStack);
        if (brushKey == null) {
            throw new AttributeValueNotFoundException();
        }
        this.brushKey = brushKey;
        this.item.addFlag(".nostack");
    }

    public void onLoad(String itemData) throws AttributeInvalidValueException {
        if (itemData == null || itemData.isEmpty()) {
            throw new AttributeInvalidValueException(this.info, "No data");
        }
        this.brushKey = itemData.replace("|", ":");
    }

    public String onSave() {
        if (this.brushKey == null) {
            this.brushKey = "";
        }
        return this.brushKey.replace(":", "|");
    }

    public void onAssign(ItemStack itemStack) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        if (this.brushKey != null && !this.brushKey.isEmpty()) {
            InventoryUtils.setMeta(itemStack, "brush", this.brushKey);
        }
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) throws InvalidItemException {
        if (itemStack == null) {
            throw new InvalidItemException();
        }
        if (this.brushKey != null && !this.brushKey.isEmpty()) {
            MagicAPI api = MagicPlugin.getAPI();
            ItemMeta meta = itemStack.getItemMeta();
            itemStack = api.createBrushItem(this.brushKey);
            if (!endItem && meta != null) {
                ItemMeta newMeta = itemStack.getItemMeta();
                newMeta.setLore(meta.getLore());
                itemStack.setItemMeta(newMeta);
            }
        }
        return itemStack;
    }

    public boolean equalsWeak(ItemAttr other) {
        if (other instanceof BrushAttr) {
            return this.brushKey.equalsIgnoreCase(((BrushAttr)other).brushKey);
        }
        return false;
    }

    public boolean equalsStrong(ItemAttr other) {
        if (other instanceof BrushAttr) {
            return this.brushKey.equalsIgnoreCase(((BrushAttr)other).brushKey);
        }
        return false;
    }
}

