/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.EntityEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.MathUtils;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class AnimatedBallEntityEffect
extends EntityEffect {
    public ParticleEffect particle = ParticleEffect.WITCH_MAGIC;
    public int particles = 150;
    public int particlesPerIteration = 10;
    public float size = 1.0f;
    public float xFactor = 1.0f;
    public float yFactor = 2.0f;
    public float zFactor = 1.0f;
    public float xOffset;
    public float yOffset = 0.8f;
    public float zOffset;
    public double xRotation;
    public double yRotation;
    public double zRotation = 0.0;
    protected int step;

    public AnimatedBallEntityEffect(EffectManager effectManager, Entity entity) {
        super(effectManager, entity);
        this.type = EffectType.REPEATING;
        this.iterations = 0x7FFFFFFE;
        this.period = 1;
    }

    @Override
    public void onRun() {
        Vector vector = new Vector();
        Location location = this.entity.getLocation();
        for (int i = 0; i < this.particlesPerIteration; ++i) {
            ++this.step;
            float t = (float)Math.PI / (float)this.particles * (float)this.step;
            float r = MathUtils.sin(t) * this.size;
            float s = (float)Math.PI * 2 * t;
            vector.setX(this.xFactor * r * MathUtils.cos(s) + this.xOffset);
            vector.setZ(this.zFactor * r * MathUtils.sin(s) + this.zOffset);
            vector.setY(this.yFactor * this.size * MathUtils.cos(t) + this.yOffset);
            VectorUtils.rotateVector(vector, this.xRotation, this.yRotation, this.zRotation);
            this.particle.display(location.add(vector), (double)this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 0);
            location.subtract(vector);
        }
    }
}

