/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class MagicRecipe {
    private String outputKey;
    private Set<Material> ingredients = new HashSet<Material>();
    private Material outputType;
    private Material substitue;
    private boolean disableDefaultRecipe;
    private ShapedRecipe recipe;
    private final MagicController controller;

    public MagicRecipe(MagicController controller) {
        this.controller = controller;
    }

    public boolean load(ConfigurationSection configuration) {
        Wand wand;
        this.outputKey = configuration.getString("output");
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitue", null);
        this.disableDefaultRecipe = configuration.getBoolean("disable_default", false);
        String outputTypeString = configuration.getString("output_type", "");
        if (!outputTypeString.equalsIgnoreCase("wand")) {
            this.outputType = ConfigurationUtils.getMaterial(configuration, "input", null);
            this.outputType = ConfigurationUtils.getMaterial(configuration, "output", this.outputType);
            return this.outputType != null;
        }
        Wand wand2 = wand = this.outputKey != null && !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey) : null;
        if (wand != null) {
            ItemStack wandItem = wand.getItem();
            this.outputType = wandItem.getType();
            ShapedRecipe shaped = new ShapedRecipe(wandItem);
            ArrayList<String> rows = new ArrayList<String>();
            for (int i = 1; i <= 3; ++i) {
                String recipeRow = configuration.getString("row_" + i, "");
                if (recipeRow.length() <= 0) continue;
                rows.add(recipeRow);
            }
            if (rows.size() > 0) {
                shaped = shaped.shape(rows.toArray(new String[0]));
                ConfigurationSection materials = configuration.getConfigurationSection("materials");
                Set keys = materials.getKeys(false);
                for (String key : keys) {
                    String materialKey = materials.getString(key);
                    MaterialAndData mat = new MaterialAndData(materialKey);
                    this.ingredients.add(mat.getMaterial());
                    Material material = mat.getMaterial();
                    if (material == null) {
                        this.outputType = null;
                        this.controller.getLogger().warning("Unable to load recipe ingredient " + materialKey);
                        return false;
                    }
                    shaped.setIngredient(key.charAt(0), material);
                }
                this.recipe = shaped;
            }
        }
        return this.outputType != null;
    }

    public void register(Plugin plugin) {
        if (this.disableDefaultRecipe) {
            Iterator it = plugin.getServer().recipeIterator();
            while (it.hasNext()) {
                Recipe defaultRecipe = (Recipe)it.next();
                if (defaultRecipe == null || defaultRecipe.getResult().getType() != this.outputType) continue;
                plugin.getLogger().info("Disabled default crafting recipe for " + this.outputType);
                it.remove();
            }
        }
        if (this.recipe != null) {
            plugin.getLogger().info("Adding crafting recipe for " + this.outputKey);
            plugin.getServer().addRecipe((Recipe)this.recipe);
        }
    }

    public Material getOutputType() {
        return this.outputType;
    }

    public Set<Material> getIngredients() {
        return this.ingredients;
    }

    public Material getSubstitute() {
        return this.substitue;
    }

    public ItemStack craft() {
        if (this.outputKey == null) {
            return null;
        }
        ItemStack item = this.controller.createWand(this.outputKey).getItem();
        return item;
    }

    public boolean isMatch(ItemStack[] matrix) {
        if (this.recipe == null || matrix.length < 9) {
            return false;
        }
        String[] shape = this.recipe.getShape();
        if (shape == null || shape.length < 3) {
            return false;
        }
        Map itemMap = this.recipe.getIngredientMap();
        for (int i = 0; i < 9; ++i) {
            String row = shape[i / 3];
            int charIndex = i % 3;
            char charAt = ' ';
            if (charIndex < row.length()) {
                charAt = row.charAt(charIndex);
            }
            ItemStack item = (ItemStack)itemMap.get(Character.valueOf(charAt));
            ItemStack ingredient = matrix[i];
            if (ingredient != null && ingredient.getType() == Material.AIR) {
                ingredient = null;
            }
            if (item == null && ingredient == null) continue;
            if (item == null && ingredient != null) {
                return false;
            }
            if (ingredient == null && item != null) {
                return false;
            }
            if (ingredient.getType() == item.getType()) continue;
            return false;
        }
        return true;
    }
}

