/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.batch.UndoBatch;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.effect.HoloUtils;
import com.elmakers.mine.bukkit.effect.Hologram;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer,
com.elmakers.mine.bukkit.api.magic.Mage {
    protected static int AUTOMATA_ONLINE_TIMEOUT = 5000;
    private static final Set<Material> EMPTY_MATERIAL_SET = new HashSet<Material>();
    private static String defaultMageName = "Mage";
    protected final String id;
    protected ConfigurationSection data = new MemoryConfiguration();
    protected WeakReference<Player> _player;
    protected WeakReference<Entity> _entity;
    protected WeakReference<CommandSender> _commandSender;
    protected boolean hasEntity;
    protected String playerName;
    protected final MagicController controller;
    protected HashMap<String, MageSpell> spells = new HashMap();
    private Wand activeWand = null;
    private Wand boundWand = null;
    private final Collection<Listener> quitListeners = new HashSet<Listener>();
    private final Collection<Listener> deathListeners = new HashSet<Listener>();
    private final Collection<Listener> damageListeners = new HashSet<Listener>();
    private final Set<MageSpell> activeSpells = new HashSet<MageSpell>();
    private UndoQueue undoQueue = null;
    private LinkedList<Batch> pendingBatches = new LinkedList();
    private boolean loading = false;
    private int debugLevel = 0;
    private Map<PotionEffectType, Integer> effectivePotionEffects = new HashMap<PotionEffectType, Integer>();
    protected float damageReduction = 0.0f;
    protected float damageReductionPhysical = 0.0f;
    protected float damageReductionProjectiles = 0.0f;
    protected float damageReductionFalling = 0.0f;
    protected float damageReductionFire = 0.0f;
    protected float damageReductionExplosions = 0.0f;
    private Map<Integer, Wand> activeArmor = new HashMap<Integer, Wand>();
    private Location location;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float powerMultiplier = 1.0f;
    private long lastClick = 0L;
    private long lastCast = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final com.elmakers.mine.bukkit.block.MaterialBrush brush;
    private long fallProtection = 0L;
    private long fallProtectionCount = 1L;
    private BaseSpell fallingSpell = null;
    private boolean isNewPlayer = true;
    private GUIAction gui = null;
    private Hologram hologram;
    private Integer hologramTaskId = null;
    private boolean hologramIsVisible = false;
    private HashMap<Integer, ItemStack> respawnInventory;
    private HashMap<Integer, ItemStack> respawnArmor;

    public Mage(String id, MagicController controller) {
        this.id = id;
        this.controller = controller;
        this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush((com.elmakers.mine.bukkit.api.magic.Mage)this, Material.DIRT, 0);
        this._player = new WeakReference<Object>(null);
        this._entity = new WeakReference<Object>(null);
        this._commandSender = new WeakReference<Object>(null);
        this.hasEntity = false;
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 62 + (expLevel - 30) * 7 : (expLevel >= 15 ? 17 + (expLevel - 15) * 3 : 17);
    }

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    @Override
    public boolean hasStoredInventory() {
        return this.activeWand != null && this.activeWand.hasStoredInventory();
    }

    @Override
    public Set<Spell> getActiveSpells() {
        return new HashSet<Spell>(this.activeSpells);
    }

    public Inventory getStoredInventory() {
        return this.activeWand != null ? this.activeWand.getStoredInventory() : null;
    }

    @Override
    public void setLocation(Location location) {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null && location != null) {
            entity.teleport(location);
            return;
        }
        this.location = location;
    }

    public void setLocation(Location location, boolean direction) {
        if (!direction) {
            if (this.location == null) {
                this.location = location;
            } else {
                this.location.setX(location.getX());
                this.location.setY(location.getY());
                this.location.setZ(location.getZ());
            }
        } else {
            this.location = location;
        }
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public void setPowerMultiplier(float mutliplier) {
        this.powerMultiplier = mutliplier;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    public boolean addToStoredInventory(ItemStack item) {
        return this.activeWand == null ? false : this.activeWand.addToStoredInventory(item);
    }

    public boolean cancel() {
        boolean result = false;
        for (MageSpell spell : this.spells.values()) {
            result = spell.cancel() || result;
        }
        return result;
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getPlayer()) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.quitListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getEntity()) {
            return;
        }
        this.lastDeathLocation = player.getLocation();
        ArrayList<Listener> active = new ArrayList<Listener>(this.deathListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerCombust(EntityCombustEvent event) {
        if (this.activeWand != null && this.activeWand.getDamageReductionFire() > 0.0f) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    protected void callEvent(Listener listener, Event event) {
        for (Method method : listener.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.isAnnotationPresent(EventHandler.class) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(event.getClass())) continue;
            try {
                method.invoke((Object)listener, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.damageListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
            if (!event.isCancelled()) continue;
            break;
        }
        if (this.isSuperProtected()) {
            event.setCancelled(true);
            if (player.getFireTicks() > 0) {
                player.setFireTicks(0);
            }
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.FALL) {
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L && this.fallProtection > System.currentTimeMillis()) {
                event.setCancelled(true);
                --this.fallProtectionCount;
                if (this.fallingSpell != null) {
                    double scale = 1.0;
                    LivingEntity li = this.getLivingEntity();
                    if (li != null) {
                        scale = event.getDamage() / li.getMaxHealth();
                    }
                    this.fallingSpell.playEffects("land", (float)scale);
                }
                if (this.fallProtectionCount <= 0L) {
                    this.fallProtection = 0L;
                    this.fallingSpell = null;
                }
                return;
            }
            this.fallingSpell = null;
        }
        float reduction = 0.0f;
        reduction = this.damageReduction * this.controller.getMaxDamageReduction();
        switch (cause) {
            case CONTACT: 
            case ENTITY_ATTACK: {
                reduction += this.damageReductionPhysical * this.controller.getMaxDamageReductionPhysical();
                break;
            }
            case PROJECTILE: {
                reduction += this.damageReductionProjectiles * this.controller.getMaxDamageReductionProjectiles();
                break;
            }
            case FALL: {
                reduction += this.damageReductionFalling * this.controller.getMaxDamageReductionFalling();
                break;
            }
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: {
                if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
                    player.setFireTicks(0);
                }
                reduction += this.damageReductionFire * this.controller.getMaxDamageReductionFire();
                break;
            }
            case BLOCK_EXPLOSION: 
            case ENTITY_EXPLOSION: {
                reduction += this.damageReductionExplosions * this.controller.getMaxDamageReductionExplosions();
            }
        }
        if (reduction >= 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            double newDamage = (double)(1.0f - reduction) * event.getDamage();
            if (newDamage <= 0.0) {
                newDamage = 0.1;
            }
            event.setDamage(newDamage);
        }
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
        if (activeWand != null && activeWand.isBound() && activeWand.canUse(this.getPlayer())) {
            this.boundWand = activeWand;
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updateEquipmentEffects();
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    @Override
    public void castMessage(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showCastMessages() && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getCastMessagePrefix() + message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getMessagePrefix() + message);
        }
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (short)1);
    }

    public void playSound(Sound sound, float volume, float pitch) {
        if (!this.controller.soundsEnabled()) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        } else {
            Entity entity = this.getEntity();
            entity.getLocation().getWorld().playSound(entity.getLocation(), sound, volume, pitch);
        }
    }

    @Override
    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue(this);
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    @Override
    public UndoList getLastUndoList() {
        if (this.undoQueue == null || this.undoQueue.isEmpty()) {
            return null;
        }
        return this.undoQueue.getLast();
    }

    @Override
    public boolean prepareForUndo(UndoList undoList) {
        if (undoList == null) {
            return false;
        }
        if (undoList.bypass()) {
            return true;
        }
        UndoQueue queue = this.getUndoQueue();
        queue.add(undoList);
        return true;
    }

    @Override
    public boolean registerForUndo(UndoList undoList) {
        if (!this.prepareForUndo(undoList)) {
            return false;
        }
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && undoList.getScheduledUndo() == 0) {
            undoList.setScheduleUndo(autoUndo);
        } else {
            undoList.updateScheduledUndo();
        }
        return true;
    }

    @Override
    public void addUndoBatch(UndoBatch batch) {
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this._player = new WeakReference<Player>(player);
            this._entity = new WeakReference<Player>(player);
            this._commandSender = new WeakReference<Player>(player);
            this.hasEntity = true;
        } else {
            this._player.clear();
            this._entity.clear();
            this._commandSender.clear();
            this.hasEntity = false;
        }
    }

    protected void setEntity(Entity entity) {
        if (entity != null) {
            LivingEntity li;
            String customName;
            this.playerName = entity.getType().name().toLowerCase().replace("_", " ");
            if (entity instanceof LivingEntity && (customName = (li = (LivingEntity)entity).getCustomName()) != null && customName.length() > 0) {
                this.playerName = customName;
            }
            this._entity = new WeakReference<Entity>(entity);
            this.hasEntity = true;
        } else {
            this._entity.clear();
            this.hasEntity = false;
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this._commandSender = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                }
                this.setLocation(location, false);
            } else {
                this.setLocation(null);
            }
        } else {
            this._commandSender.clear();
            this.setLocation(null);
        }
    }

    protected void onLoad() {
        this.loading = false;
        Player player = this.getPlayer();
        if (player != null && this.activeWand == null) {
            String welcomeWand = this.controller.getWelcomeWand();
            Wand wand = Wand.getActiveWand(this.controller, player);
            if (wand != null) {
                wand.activate(this);
            } else if (this.isNewPlayer && welcomeWand.length() > 0) {
                this.isNewPlayer = false;
                wand = Wand.createWand(this.controller, welcomeWand);
                if (wand != null) {
                    wand.takeOwnership(player, false, false);
                    this.controller.giveItemToPlayer(player, wand.getItem());
                    this.controller.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
                } else {
                    this.controller.getLogger().warning("Unable to give welcome wand '" + welcomeWand + "' to " + player.getName());
                }
            }
        }
        Collection<Spell> spells = this.getSpells();
        for (Spell spell : spells) {
            if (!spell.isActive()) continue;
            this.sendMessage(this.controller.getMessages().get("spell.reactivate").replace("$name", spell.getName()));
            this.activateSpell(spell);
        }
    }

    protected boolean load(ConfigurationSection configNode) {
        try {
            ConfigurationSection respawnArmorData;
            ConfigurationSection respawnData;
            if (configNode == null) {
                this.onLoad();
                return true;
            }
            this.boundWand = null;
            if (configNode.contains("bound_wand")) {
                this.boundWand = new Wand(this.controller, configNode.getConfigurationSection("bound_wand"));
            } else if (configNode.contains("wand")) {
                this.boundWand = new Wand(this.controller, this.controller.deserialize(configNode, "wand"));
            }
            if (configNode.contains("data")) {
                this.data = configNode.getConfigurationSection("data");
            }
            this.isNewPlayer = false;
            this.playerName = configNode.getString("name", this.playerName);
            this.lastDeathLocation = ConfigurationUtils.getLocation(configNode, "last_death_location");
            this.location = ConfigurationUtils.getLocation(configNode, "location");
            this.lastCast = configNode.getLong("last_cast", this.lastCast);
            this.getUndoQueue().load(configNode);
            ConfigurationSection spellNode = configNode.getConfigurationSection("spells");
            if (spellNode != null) {
                Set keys = spellNode.getKeys(false);
                for (String key : keys) {
                    MageSpell spell = this.getSpell(key);
                    if (spell == null || !(spell instanceof MageSpell)) continue;
                    ConfigurationSection spellSection = spellNode.getConfigurationSection(key);
                    spell.load(spellSection);
                }
            }
            if ((respawnData = configNode.getConfigurationSection("respawn_inventory")) != null) {
                Set keys = respawnData.getKeys(false);
                this.respawnInventory = new HashMap();
                for (String key : keys) {
                    try {
                        int index = Integer.parseInt(key);
                        ItemStack item = this.controller.deserialize(respawnData, key);
                        this.respawnInventory.put(index, item);
                    }
                    catch (Exception ex) {}
                }
            }
            if ((respawnArmorData = configNode.getConfigurationSection("respawn_armor")) != null) {
                Set keys = respawnArmorData.getKeys(false);
                this.respawnArmor = new HashMap();
                for (String key : keys) {
                    try {
                        int index = Integer.parseInt(key);
                        ItemStack item = this.controller.deserialize(respawnArmorData, key);
                        this.respawnArmor.put(index, item);
                    }
                    catch (Exception ex) {}
                }
            }
            if (configNode.contains("brush")) {
                this.brush.load(configNode.getConfigurationSection("brush"));
            }
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load player data for " + this.playerName + ": " + ex.getMessage());
            return false;
        }
        this.onLoad();
        return true;
    }

    @Override
    public boolean save(ConfigurationSection configNode) {
        try {
            configNode.set("name", (Object)this.playerName);
            configNode.set("last_cast", (Object)this.lastCast);
            configNode.set("last_death_location", (Object)ConfigurationUtils.fromLocation(this.lastDeathLocation));
            if (this.location != null) {
                configNode.set("location", (Object)ConfigurationUtils.fromLocation(this.location));
            }
            ConfigurationSection brushNode = configNode.createSection("brush");
            this.brush.save(brushNode);
            this.getUndoQueue().save(configNode);
            ConfigurationSection spellNode = configNode.createSection("spells");
            for (MageSpell spell : this.spells.values()) {
                ConfigurationSection section = spellNode.createSection(spell.getKey());
                section.set("active", (Object)spell.isActive());
                spell.save(section);
            }
            if (this.boundWand != null) {
                this.controller.serialize(configNode, "wand", this.boundWand.getItem());
            }
            if (this.respawnArmor != null) {
                ConfigurationSection armorSection = configNode.createSection("respawn_armor");
                for (Map.Entry<Integer, ItemStack> entry : this.respawnArmor.entrySet()) {
                    this.controller.serialize(armorSection, Integer.toString(entry.getKey()), entry.getValue());
                }
            }
            if (this.respawnInventory != null) {
                ConfigurationSection inventorySection = configNode.createSection("respawn_inventory");
                for (Map.Entry<Integer, ItemStack> entry : this.respawnInventory.entrySet()) {
                    this.controller.serialize(inventorySection, Integer.toString(entry.getKey()), entry.getValue());
                }
            }
            ConfigurationSection dataSection = configNode.createSection("data");
            ConfigurationUtils.addConfigurations(dataSection, this.data);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().log(Level.WARNING, "Failed to save player data for " + this.playerName, ex);
            return false;
        }
        return true;
    }

    protected boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    protected void removeActiveEffects() {
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        Collection activeEffects = entity.getActivePotionEffects();
        for (PotionEffect effect : activeEffects) {
            if (effect.getDuration() <= 0x3FFFFFFF) continue;
            entity.removePotionEffect(effect.getType());
        }
    }

    protected void tick() {
        Player player = this.getPlayer();
        if (player != null && player.isOnline()) {
            if (this.activeWand != null) {
                this.activeWand.tick();
            }
            for (Wand armorWand : this.activeArmor.values()) {
                armorWand.updateEffects(this);
            }
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                spell.tick();
                if (spell.isActive()) continue;
                this.deactivateSpell(spell);
            }
        }
    }

    public int processPendingBatches(int maxBlockUpdates) {
        int updated = 0;
        if (this.pendingBatches.size() > 0) {
            ArrayList<Batch> processBatches = new ArrayList<Batch>(this.pendingBatches);
            this.pendingBatches.clear();
            for (Batch batch : processBatches) {
                if (updated < maxBlockUpdates) {
                    int batchUpdated = batch.process(maxBlockUpdates - updated);
                    updated += batchUpdated;
                }
                if (batch.isFinished()) continue;
                this.pendingBatches.add(batch);
            }
        }
        if (this.pendingBatches.size() == 0) {
            this.controller.removePending(this);
        }
        return updated;
    }

    public void setLastHeldMapId(short mapId) {
        this.brush.setMapId(mapId);
    }

    protected void loadSpells(ConfigurationSection config) {
        if (config == null) {
            return;
        }
        ArrayList<MageSpell> currentSpells = new ArrayList<MageSpell>(this.spells.values());
        for (MageSpell spell : currentSpells) {
            String key = spell.getKey();
            if (config.contains(key)) {
                ConfigurationSection template = config.getConfigurationSection(key);
                String className = template.getString("class");
                if (className == null) {
                    className = ActionSpell.class.getName();
                }
                if (!spell.getClass().getName().contains(className)) {
                    MemoryConfiguration spellData = new MemoryConfiguration();
                    spell.save((ConfigurationSection)spellData);
                    this.spells.remove(key);
                    MageSpell newSpell = this.getSpell(key);
                    if (newSpell == null || !(newSpell instanceof MageSpell)) continue;
                    newSpell.load((ConfigurationSection)spellData);
                    continue;
                }
                spell.loadTemplate(key, template);
                continue;
            }
            this.spells.remove(key);
        }
    }

    public boolean isNewPlayer() {
        return this.isNewPlayer;
    }

    public void clearNewPlayer() {
        this.isNewPlayer = false;
    }

    @Override
    public Collection<Batch> getPendingBatches() {
        ArrayList<Batch> pending = new ArrayList<Batch>();
        pending.addAll(this.pendingBatches);
        return pending;
    }

    @Override
    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    @Override
    public String getDisplayName() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return this.getName();
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        return this.controller.getEntityDisplayName(entity);
    }

    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity == null) {
            return null;
        }
        return livingEntity.getLocation();
    }

    @Override
    public Location getEyeLocation() {
        Entity entity = this.getEntity();
        if (entity != null) {
            return CompatibilityUtils.getEyeLocation(entity);
        }
        return this.getLocation();
    }

    @Override
    public Vector getDirection() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getDirection();
        }
        return new Vector(0, 1, 0);
    }

    @Override
    public UndoList undo(Block target) {
        return this.getUndoQueue().undo(target);
    }

    @Override
    public Batch cancelPending() {
        return this.cancelPending(null);
    }

    @Override
    public Batch cancelPending(String spellKey) {
        Batch stoppedPending = null;
        if (this.pendingBatches.size() > 0) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                SpellBatch spellBatch;
                Spell spell;
                if (spellKey != null && (!(batch instanceof SpellBatch) || (spell = (spellBatch = (SpellBatch)batch).getSpell()) == null || !spell.getSpellKey().getBaseKey().equalsIgnoreCase(spellKey)) || batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch) continue;
                batch.finish();
                this.pendingBatches.remove(batch);
                stoppedPending = batch;
                break;
            }
        }
        return stoppedPending;
    }

    @Override
    public UndoList undo() {
        return this.getUndoQueue().undo();
    }

    @Override
    public boolean commit() {
        return this.getUndoQueue().commit();
    }

    @Override
    public boolean hasCastPermission(Spell spell) {
        return spell.hasCastPermission(this.getCommandSender());
    }

    @Override
    public MageSpell getSpell(String key) {
        if (this.loading) {
            return null;
        }
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell == null) {
            SpellTemplate spellTemplate = this.controller.getSpellTemplate(key);
            if (spellTemplate == null) {
                return null;
            }
            Spell newSpell = spellTemplate.createSpell();
            if (newSpell == null || !(newSpell instanceof MageSpell)) {
                return null;
            }
            playerSpell = (MageSpell)newSpell;
            this.spells.put(newSpell.getKey(), playerSpell);
            SpellKey baseKey = newSpell.getSpellKey();
            SpellKey upgradeKey = new SpellKey(baseKey.getBaseKey(), baseKey.getLevel() + 1);
            MageSpell upgradeSpell = this.getSpell(upgradeKey.getKey());
            if (upgradeSpell instanceof MageSpell) {
                playerSpell.setUpgrade(upgradeSpell);
            }
        }
        playerSpell.setMage(this);
        return playerSpell;
    }

    @Override
    public Collection<Spell> getSpells() {
        ArrayList<Spell> export = new ArrayList<Spell>(this.spells.values());
        return export;
    }

    @Override
    public void activateSpell(Spell spell) {
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.activeSpells.add(mageSpell);
            mageSpell.reactivate();
        }
    }

    @Override
    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
        if (spell instanceof MageSpell) {
            ((MageSpell)spell).deactivate();
        }
    }

    @Override
    public void deactivateAllSpells() {
        this.deactivateAllSpells(false, false);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet) {
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (!spell.deactivate(force, quiet)) continue;
            this.activeSpells.remove(spell);
        }
    }

    @Override
    public boolean isCostFree() {
        if (this.getPlayer() == null) {
            return true;
        }
        return this.activeWand == null ? false : this.activeWand.isCostFree();
    }

    @Override
    public boolean isSuperProtected() {
        return this.activeWand != null && this.activeWand.isSuperProtected();
    }

    @Override
    public boolean isSuperPowered() {
        return this.activeWand != null && this.activeWand.isSuperPowered();
    }

    @Override
    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction + this.controller.getCostReduction() : this.activeWand.getCostReduction() + this.costReduction;
    }

    @Override
    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction + this.controller.getCooldownReduction() : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    @Override
    public boolean isCooldownFree() {
        return this.activeWand == null ? false : this.activeWand.isCooldownFree();
    }

    @Override
    public Color getEffectColor() {
        if (this.activeWand == null) {
            return null;
        }
        return this.activeWand.getEffectColor();
    }

    @Override
    public String getEffectParticleName() {
        if (this.activeWand == null) {
            return null;
        }
        ParticleEffect particle = this.activeWand.getEffectParticle();
        return particle == null ? null : particle.name();
    }

    @Override
    public void onCast(Spell spell, SpellResult result) {
        this.lastCast = System.currentTimeMillis();
        if (spell != null) {
            this.controller.onCast(this, spell, result);
        }
    }

    @Override
    public float getPower() {
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? 0.0f : this.activeWand.getPower());
        return power * this.powerMultiplier;
    }

    @Override
    public boolean isRestricted(Material material) {
        Player player = this.getPlayer();
        if (player != null && player.hasPermission("Magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material);
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        if (this.isSuperPowered()) {
            return EMPTY_MATERIAL_SET;
        }
        return this.controller.getRestrictedMaterials();
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        return this.controller.isPVPAllowed(this.getPlayer(), location == null ? this.getLocation() : location);
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    @Override
    public boolean isDead() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.isDead();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        BlockCommandSender commandBlock = (BlockCommandSender)sender;
        Block block = commandBlock.getBlock();
        if (!block.getChunk().isLoaded()) {
            return true;
        }
        return block.getType() != Material.COMMAND;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.isOnline();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        return this.lastCast > System.currentTimeMillis() - (long)AUTOMATA_ONLINE_TIMEOUT;
    }

    @Override
    public boolean isPlayer() {
        Player player = this.getPlayer();
        return player != null;
    }

    @Override
    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    @Override
    public Inventory getInventory() {
        if (this.hasStoredInventory()) {
            return this.getStoredInventory();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getInventory();
        }
        return null;
    }

    @Override
    public Wand getActiveWand() {
        return this.activeWand;
    }

    @Override
    public MaterialBrush getBrush() {
        return this.brush;
    }

    @Override
    public float getDamageMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public int getMana() {
        return this.activeWand == null ? 0 : this.activeWand.getMana();
    }

    @Override
    public void removeMana(int mana) {
        if (this.activeWand != null) {
            this.activeWand.removeMana(mana);
        }
    }

    @Override
    public void removeExperience(int xp) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                int expAtLevel = (int)(expProgress * (float)player.getExpToLevel());
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / (float)Mage.getExpToLevel(expLevel);
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            --expLevel;
            if ((xp -= player.getExpToLevel()) >= 0) continue;
            expProgress = (float)(-xp) / (float)Mage.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(expProgress);
        player.setLevel(expLevel);
        if (this.activeWand != null) {
            this.activeWand.updateExperience();
        }
    }

    @Override
    public int getLevel() {
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp() && !Wand.retainLevelDisplay) {
            return this.activeWand.getStoredXpLevel();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLevel();
        }
        return 0;
    }

    @Override
    public void setLevel(int level) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setLevel(level);
        }
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp()) {
            this.activeWand.setStoredXpLevel(level);
        }
    }

    @Override
    public int getExperience() {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        int xp = 0;
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        for (int level = 0; level < expLevel; ++level) {
            xp += Mage.getExpToLevel(level);
        }
        return xp + (int)(expProgress * (float)Mage.getExpToLevel(expLevel));
    }

    @Override
    public void giveExperience(int xp) {
        Player player;
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp()) {
            this.activeWand.addExperience(xp);
        }
        if ((player = this.getPlayer()) != null) {
            player.giveExp(xp);
        }
    }

    @Override
    public boolean addBatch(Batch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            this.controller.getLogger().info("Rejected spell batch for " + this.getName() + ", already has " + this.pendingBatches.size() + " pending, limit: " + this.controller.getPendingQueueDepth());
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    @Override
    public void registerEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    @Override
    public void unregisterEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    @Override
    public Player getPlayer() {
        return (Player)this._player.get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this._entity.get();
    }

    @Override
    public LivingEntity getLivingEntity() {
        Entity entity = (Entity)this._entity.get();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public CommandSender getCommandSender() {
        return (CommandSender)this._commandSender.get();
    }

    @Override
    public List<LostWand> getLostWands() {
        Entity entity = this.getEntity();
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        if (entity == null) {
            return mageWands;
        }
        String playerId = entity.getUniqueId().toString();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwnerId();
            if (owner == null || !owner.equals(playerId)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    @Override
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    @Override
    public void showHoloText(Location location, String text, int duration) {
        if (!this.isPlayer()) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.hologram == null) {
            this.hologram = HoloUtils.createHoloText(location, text);
        } else {
            if (this.hologramIsVisible) {
                this.hologram.hide(player);
            }
            this.hologram.teleport(location);
            this.hologram.setLabel(text);
        }
        this.hologram.show(player);
        BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.hologramTaskId != null) {
            scheduler.cancelTask(this.hologramTaskId.intValue());
        }
        if (duration > 0) {
            scheduler.scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Mage.this.hologram.hide(player);
                    Mage.this.hologramIsVisible = false;
                }
            }, (long)duration);
        }
    }

    @Override
    public void enableFallProtection(int ms, Spell protector) {
        this.enableFallProtection(ms, 1, protector);
    }

    @Override
    public void enableFallProtection(int ms, int count, Spell protector) {
        long nextTime;
        if (ms <= 0 || count <= 0) {
            return;
        }
        if (protector != null && protector instanceof BaseSpell) {
            this.fallingSpell = (BaseSpell)protector;
        }
        if ((nextTime = System.currentTimeMillis() + (long)ms) > this.fallProtection) {
            this.fallProtection = nextTime;
        }
        if ((long)count > this.fallProtectionCount) {
            this.fallProtectionCount = count;
        }
    }

    @Override
    public void enableFallProtection(int ms) {
        this.enableFallProtection(ms, null);
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean isValid() {
        if (!this.hasEntity) {
            return true;
        }
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        if (this.controller.isNPC(entity)) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.isOnline();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return !living.isDead();
        }
        return true;
    }

    @Override
    public boolean restoreWand() {
        if (this.boundWand == null) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        this.controller.giveItemToPlayer(player, this.boundWand.duplicate().getItem());
        return true;
    }

    @Override
    public boolean isStealth() {
        if (this.isSneaking()) {
            return true;
        }
        return this.activeWand != null && this.activeWand.isStealth();
    }

    @Override
    public boolean isSneaking() {
        Player player = this.getPlayer();
        return player != null && player.isSneaking();
    }

    @Override
    public ConfigurationSection getData() {
        if (this.loading) {
            return new MemoryConfiguration();
        }
        return this.data;
    }

    @Override
    public void activateGUI(GUIAction action) {
        GUIAction previousGUI = this.gui;
        this.gui = action;
        Player player = this.getPlayer();
        if (this.gui == null && player != null) {
            this.controller.disableItemSpawn();
            try {
                player.closeInventory();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        if (previousGUI != null) {
            previousGUI.deactivated();
        }
    }

    @Override
    public void deactivateGUI() {
        this.activateGUI(null);
    }

    @Override
    public GUIAction getActiveGUI() {
        return this.gui;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public void sendDebugMessage(String message) {
        this.sendDebugMessage(message, 1);
    }

    @Override
    public void sendDebugMessage(String message, int level) {
        if (this.debugLevel >= level) {
            this.sendMessage(message);
        }
    }

    public void clearRespawnInventories() {
        this.respawnArmor = null;
        this.respawnInventory = null;
    }

    public void restoreRespawnInventories() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (this.respawnArmor != null) {
            ItemStack[] armor = inventory.getArmorContents();
            for (Map.Entry<Integer, ItemStack> entry : this.respawnArmor.entrySet()) {
                armor[entry.getKey().intValue()] = entry.getValue();
            }
            player.getInventory().setArmorContents(armor);
            this.armorUpdated();
        }
        if (this.respawnInventory != null) {
            for (Map.Entry<Integer, ItemStack> entry : this.respawnInventory.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), entry.getValue());
            }
        }
        this.clearRespawnInventories();
    }

    public void addToRespawnInventory(int slot, ItemStack item) {
        if (this.respawnInventory == null) {
            this.respawnInventory = new HashMap();
        }
        this.respawnInventory.put(slot, item);
    }

    public void addToRespawnArmor(int slot, ItemStack item) {
        if (this.respawnArmor == null) {
            this.respawnArmor = new HashMap();
        }
        this.respawnArmor.put(slot, item);
    }

    @Override
    public void giveItem(ItemStack itemStack) {
        if (this.hasStoredInventory()) {
            this.addToStoredInventory(itemStack);
            return;
        }
        Wand activeWand = this.getActiveWand();
        if (activeWand != null && activeWand.addItem(itemStack)) {
            return;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItem(inventory.getHeldItemSlot(), itemStack);
            if (Wand.isWand(itemStack)) {
                Wand wand = new Wand(this.controller, itemStack);
                wand.activate(this);
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            if (returned.size() > 0) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
    }

    public void armorUpdated() {
        this.activeArmor.clear();
        Player player = this.getPlayer();
        if (player != null) {
            ItemStack[] armor = player.getInventory().getArmorContents();
            for (int index = 0; index < armor.length; ++index) {
                ItemStack armorItem = armor[index];
                if (!Wand.isWand(armorItem)) continue;
                this.activeArmor.put(index, new Wand(this.controller, armorItem));
            }
        }
        if (this.activeWand != null) {
            this.activeWand.armorUpdated();
        }
        this.updateEquipmentEffects();
    }

    protected void updateEquipmentEffects() {
        this.damageReduction = 0.0f;
        this.damageReductionPhysical = 0.0f;
        this.damageReductionProjectiles = 0.0f;
        this.damageReductionFalling = 0.0f;
        this.damageReductionFire = 0.0f;
        this.damageReductionExplosions = 0.0f;
        this.effectivePotionEffects.clear();
        if (this.activeWand != null && !this.activeWand.isPassive()) {
            this.damageReduction += this.activeWand.getDamageReduction();
            this.damageReductionPhysical += this.activeWand.getDamageReductionPhysical();
            this.damageReductionProjectiles += this.activeWand.getDamageReductionProjectiles();
            this.damageReductionFalling += this.activeWand.getDamageReductionFalling();
            this.damageReductionFire += this.activeWand.getDamageReductionFire();
            this.damageReductionExplosions += this.activeWand.getDamageReductionExplosions();
            this.effectivePotionEffects.putAll(this.activeWand.getPotionEffects());
        }
        for (Wand armorWand : this.activeArmor.values()) {
            if (armorWand == null) continue;
            this.damageReduction += armorWand.getDamageReduction();
            this.damageReductionPhysical += armorWand.getDamageReductionPhysical();
            this.damageReductionProjectiles += armorWand.getDamageReductionProjectiles();
            this.damageReductionFalling += armorWand.getDamageReductionFalling();
            this.damageReductionFire += armorWand.getDamageReductionFire();
            this.damageReductionExplosions += armorWand.getDamageReductionExplosions();
            this.effectivePotionEffects.putAll(armorWand.getPotionEffects());
        }
        this.damageReduction = Math.min(this.damageReduction, 1.0f);
        this.damageReductionPhysical = Math.min(this.damageReductionPhysical, 1.0f);
        this.damageReductionProjectiles = Math.min(this.damageReductionProjectiles, 1.0f);
        this.damageReductionFalling = Math.min(this.damageReductionFalling, 1.0f);
        this.damageReductionFire = Math.min(this.damageReductionFire, 1.0f);
        this.damageReductionExplosions = Math.min(this.damageReductionExplosions, 1.0f);
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            Collection activeEffects = entity.getActivePotionEffects();
            for (PotionEffect potionEffect : activeEffects) {
                if (this.effectivePotionEffects.containsKey(potionEffect.getType()) || potionEffect.getDuration() <= 0x1FFFFFFF) continue;
                entity.removePotionEffect(potionEffect.getType());
            }
            for (Map.Entry entry : this.effectivePotionEffects.entrySet()) {
                PotionEffect effect = new PotionEffect((PotionEffectType)entry.getKey(), Integer.MAX_VALUE, ((Integer)entry.getValue()).intValue(), true);
                CompatibilityUtils.applyPotionEffect(entity, effect);
            }
        }
    }

    public Collection<Wand> getActiveArmor() {
        return this.activeArmor.values();
    }

    @Override
    public void deactivate() {
        if (this.activeWand != null) {
            this.activeWand.deactivate();
        }
        this.deactivateAllSpells(true, true);
        this.removeActiveEffects();
    }

    @Override
    public void removeItemsWithTag(String tag) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack item = contents[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            inventory.setItem(index, null);
        }
        boolean modified = false;
        ItemStack[] armor = inventory.getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack item = armor[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            modified = true;
            armor[index] = null;
        }
        if (modified) {
            inventory.setArmorContents(armor);
        }
    }
}

