/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class BaseSpell
implements MageSpell,
Cloneable {
    protected static final double VIEW_HEIGHT = 1.65;
    protected static final double LOOK_THRESHOLD_RADIANS = 0.9;
    protected static final int MIN_Y = 1;
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.STATIONARY_WATER;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "*1", "*-1", "*-0.5", "*0.5", "*1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z", "otdx", "otdy", "otdz"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "reverse_targeting", "passthrough", "bypass_build", "bypass_pvp", "target_npc", "ignore_blocks"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MageController controller;
    protected Mage mage;
    protected Location location;
    protected com.elmakers.mine.bukkit.action.CastContext currentCast;
    private SpellKey spellKey;
    private String name;
    private String alias;
    private String description;
    private String extendedDescription;
    private String levelDescription;
    private String upgradeDescription;
    private String usage;
    private double worth;
    private Color color;
    private String particle;
    private SpellCategory category;
    private BaseSpell template;
    private MageSpell upgrade;
    private long requiredUpgradeCasts;
    private String requiredUpgradePath;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
    private String iconURL = null;
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    protected boolean pvpRestricted = false;
    protected boolean usesBrushSelection = false;
    protected boolean bypassPvpRestriction = false;
    protected boolean bypassConfusion = false;
    protected boolean bypassPermissions = false;
    protected boolean castOnNoTarget = false;
    protected boolean bypassDeactivate = false;
    protected boolean quiet = false;
    protected boolean loud = false;
    protected boolean showUndoable = true;
    protected int verticalSearchDistance = 8;
    private boolean backfired = false;
    private boolean hidden = false;
    protected ConfigurationSection parameters = null;
    protected ConfigurationSection configuration = null;
    protected static Random random = new Random();
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private boolean isActive = false;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;
    private long lastMessageSent = 0L;
    private Set<Material> preventPassThroughMaterials = null;
    private Set<Material> passthroughMaterials = null;

    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        if (this.passthroughMaterials != null && this.passthroughMaterials.contains(mat)) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.contains(mat);
    }

    public boolean isOkToStandIn(Material mat) {
        return this.passthroughMaterials.contains(mat);
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Block block) {
        if ((block.getType() == Material.STEP || block.getType() == Material.WOOD_STEP) && block.getData() >= 8) {
            return true;
        }
        return this.isOkToStandOn(block.getType());
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA && !this.passthroughMaterials.contains(mat);
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > block.getWorld().getMaxHeight()) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        if ((block.getType() == Material.STEP || block.getType() == Material.WOOD_STEP) && this.isOkToStandIn(blockOneUp.getType()) && block.getData() < 8) {
            return true;
        }
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, targetLoc.getWorld().getMaxHeight(), targetLoc.getWorld().getMaxHeight());
    }

    public Location findPlaceToStand(Location targetLoc) {
        return this.findPlaceToStand(targetLoc, this.verticalSearchDistance, this.verticalSearchDistance);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        Location location = this.findPlaceToStand(targetLoc, maxDownDelta, maxUpDelta);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int minY = 1;
        int maxY = targetLoc.getWorld().getMaxHeight();
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, maxUpDelta);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, maxDownDelta);
        } else {
            int testMaxY = Math.min(maxUpDelta, 3);
            location = this.findPlaceToStand(targetLoc, true, testMaxY);
            if (location == null) {
                int testMinY = Math.min(maxDownDelta, 4);
                location = this.findPlaceToStand(targetLoc, false, testMinY);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, maxUpDelta);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, maxDownDelta);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, this.verticalSearchDistance);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int maxDelta) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        boolean minY = true;
        int maxY = targetLocation.getWorld().getMaxHeight();
        for (int yDelta = 0; (double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY && yDelta < maxDelta; ++yDelta) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                return targetLocation;
            }
            if (!this.allowPassThrough(block.getType())) {
                return null;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        return BaseSpell.getFacing(this.getLocation());
    }

    public static BlockFace getFacing(Location location) {
        float playerRot;
        for (playerRot = location.getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    @Override
    public void castMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showCastMessages()) {
            return;
        }
        if (!this.quiet && this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public void sendMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showMessages()) {
            return;
        }
        if (!this.quiet && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            Location location = this.location.clone();
            location.setY(location.getY() + 1.5);
            return location;
        }
        return this.mage.getEyeLocation();
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.9;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.9;
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (random.nextDouble() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
                break;
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        return BaseSpell.getPotionEffects(parameters, null);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            int ticks = 10;
            int power = 1;
            try {
                if (value.contains(",")) {
                    String[] pieces = value.split(",");
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
            PotionEffect effect = new PotionEffect(effectType, ticks, power, true);
            effects.add(effect);
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    @Override
    public boolean hasBrushOverride() {
        return false;
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean usesBrushSelection() {
        return (this.usesBrushSelection || this.usesBrush()) && !this.hasBrushOverride();
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                return;
            }
            cost.use(this);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected List<CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getInt(key, 1)));
        }
        return castingCosts;
    }

    protected void loadTemplate(ConfigurationSection node) {
        String baseKey = this.spellKey.getBaseKey();
        this.name = this.controller.getMessages().get("spells." + baseKey + ".name", baseKey);
        this.description = this.controller.getMessages().get("spells." + baseKey + ".description", "");
        this.extendedDescription = this.controller.getMessages().get("spells." + baseKey + ".extended_description", "");
        this.usage = this.controller.getMessages().get("spells." + baseKey + ".usage", "");
        this.requiredUpgradePath = node.getString("upgrade_required_path");
        this.requiredUpgradeCasts = node.getLong("upgrade_required_casts");
        this.levelDescription = this.controller.getMessages().get("spells." + baseKey + ".level_description", this.levelDescription);
        this.upgradeDescription = this.controller.getMessages().get("spells." + baseKey + ".upgrade_description", this.upgradeDescription);
        if (this.spellKey.isVariant()) {
            String variantKey = this.spellKey.getKey();
            this.name = this.controller.getMessages().get("spells." + variantKey + ".name", this.name);
            this.description = this.controller.getMessages().get("spells." + variantKey + ".description", this.description);
            this.extendedDescription = this.controller.getMessages().get("spells." + variantKey + ".extended_description", this.extendedDescription);
            this.usage = this.controller.getMessages().get("spells." + variantKey + ".usage", this.usage);
            this.levelDescription = this.controller.getMessages().get("spell.level_description", this.levelDescription);
            this.levelDescription = this.controller.getMessages().get("spells." + variantKey + ".level_description", this.levelDescription);
            this.upgradeDescription = this.controller.getMessages().get("spells." + variantKey + ".upgrade_description", this.upgradeDescription);
        }
        this.name = node.getString("name", this.name);
        this.alias = node.getString("alias", "");
        this.extendedDescription = node.getString("extended_description", this.extendedDescription);
        this.description = node.getString("description", this.description);
        this.levelDescription = node.getString("level_description", this.levelDescription);
        if (this.levelDescription != null && !this.levelDescription.isEmpty()) {
            this.levelDescription = this.levelDescription.replace("$level", Integer.toString(this.spellKey.getLevel()));
        }
        this.icon = ConfigurationUtils.getMaterialAndData(node, "icon", this.icon);
        this.iconURL = node.getString("icon_url");
        this.color = ConfigurationUtils.getColor(node, "color", null);
        this.worth = node.getDouble("worth", 0.0);
        this.category = this.controller.getCategory(node.getString("category"));
        this.parameters = node.getConfigurationSection("parameters");
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.pvpRestricted = node.getBoolean("pvp_restricted", this.pvpRestricted);
        this.usesBrushSelection = node.getBoolean("brush_selection", this.usesBrushSelection);
        this.castOnNoTarget = node.getBoolean("cast_on_no_target", this.castOnNoTarget);
        this.hidden = node.getBoolean("hidden", false);
        this.showUndoable = node.getBoolean("show_undoable", true);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            this.cooldown = parameters.getInt("cooldown", this.cooldown);
            this.cooldown = parameters.getInt("cool", this.cooldown);
            this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", this.bypassPvpRestriction);
            this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
            this.bypassPermissions = parameters.getBoolean("bypass_permissions", this.bypassPermissions);
            this.duration = parameters.getInt("duration", this.duration);
        }
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(this.controller.getPlugin(), effectsNode, effectKey));
            }
        }
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
        this.backfired = false;
    }

    @Override
    public boolean cast(String[] extraParameters, Location defaultLocation) {
        this.reset();
        if (this.currentCast == null || !this.isActive) {
            this.currentCast = new com.elmakers.mine.bukkit.action.CastContext(this);
        }
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        this.location = defaultLocation;
        MemoryConfiguration parameters = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.parameters);
        ConfigurationUtils.addParameters(extraParameters, (ConfigurationSection)parameters);
        this.processParameters((ConfigurationSection)parameters);
        PreCastEvent preCast = new PreCastEvent(this.mage, this);
        Bukkit.getPluginManager().callEvent((Event)preCast);
        if (preCast.isCancelled()) {
            this.processResult(SpellResult.CANCELLED, (ConfigurationSection)parameters);
            this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)SpellResult.CANCELLED) + ChatColor.DARK_AQUA + " (no cast)");
            return false;
        }
        this.bypassConfusion = parameters.getBoolean("bypass_confusion", this.bypassConfusion);
        LivingEntity livingEntity = this.mage.getLivingEntity();
        if (livingEntity != null && !this.bypassConfusion && !this.mage.isSuperPowered() && livingEntity.hasPotionEffect(PotionEffectType.CONFUSION)) {
            this.processResult(SpellResult.CURSED, (ConfigurationSection)parameters);
            this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)SpellResult.CURSED) + ChatColor.DARK_AQUA + " (no cast)");
            return false;
        }
        if (!this.canCast(this.getLocation())) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION, (ConfigurationSection)parameters);
            this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)SpellResult.INSUFFICIENT_PERMISSION) + ChatColor.DARK_AQUA + " (no cast)");
            return false;
        }
        this.preCast();
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = parameters.getBoolean("bypass_permissions", this.bypassPermissions);
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        this.color = ConfigurationUtils.getColor((ConfigurationSection)parameters, "color", this.color);
        this.particle = parameters.getString("particle", null);
        long cooldownRemaining = this.getRemainingCooldown() / 1000L;
        String timeDescription = "";
        if (cooldownRemaining > 0L) {
            long minutes;
            long hours;
            timeDescription = cooldownRemaining > 3600L ? ((hours = cooldownRemaining / 3600L) == 1L ? this.controller.getMessages().get("cooldown.wait_hour") : this.controller.getMessages().get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString())) : (cooldownRemaining > 60L ? ((minutes = cooldownRemaining / 60L) == 1L ? this.controller.getMessages().get("cooldown.wait_minute") : this.controller.getMessages().get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString())) : (cooldownRemaining > 1L ? this.controller.getMessages().get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(cooldownRemaining).toString()) : this.controller.getMessages().get("cooldown.wait_moment")));
            this.castMessage(this.getMessage("cooldown").replace("$time", timeDescription));
            this.processResult(SpellResult.COOLDOWN, (ConfigurationSection)parameters);
            this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)SpellResult.COOLDOWN) + ChatColor.DARK_AQUA + " (no cast)");
            return false;
        }
        CastingCost required = this.getRequiredCost();
        if (required != null) {
            String baseMessage = this.getMessage("insufficient_resources");
            String costDescription = required.getDescription(this.controller.getMessages(), this.mage);
            this.castMessage(baseMessage.replace("$cost", costDescription));
            this.processResult(SpellResult.INSUFFICIENT_RESOURCES, (ConfigurationSection)parameters);
            this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)SpellResult.INSUFFICIENT_RESOURCES) + ChatColor.DARK_AQUA + " (no cast)");
            return false;
        }
        return this.finalizeCast((ConfigurationSection)parameters);
    }

    @Override
    public boolean canCast(Location location) {
        if (location == null) {
            return true;
        }
        if (!this.hasCastPermission(this.mage.getCommandSender())) {
            return false;
        }
        Boolean regionPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, location);
        if (regionPermission != null && regionPermission.booleanValue()) {
            return true;
        }
        Boolean personalPermission = this.controller.getPersonalCastPermission(this.mage.getPlayer(), this, location);
        if (personalPermission != null && personalPermission.booleanValue()) {
            return true;
        }
        if (regionPermission != null && !regionPermission.booleanValue()) {
            return false;
        }
        if (this.requiresBuildPermission() && !this.hasBuildPermission(location.getBlock())) {
            return false;
        }
        return !this.pvpRestricted || this.bypassPvpRestriction || this.mage.isPVPAllowed(location);
    }

    @Override
    public boolean isPvpRestricted() {
        return this.pvpRestricted && !this.bypassPvpRestriction;
    }

    @Override
    public boolean requiresBuildPermission() {
        return false;
    }

    public boolean hasBuildPermission(Location location) {
        if (location == null) {
            return true;
        }
        return this.hasBuildPermission(location.getBlock());
    }

    public boolean hasBuildPermission(Block block) {
        Boolean castPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, block.getLocation());
        if (castPermission != null && castPermission.booleanValue()) {
            return true;
        }
        if (castPermission != null && !castPermission.booleanValue()) {
            return false;
        }
        return this.mage.hasBuildPermission(block);
    }

    protected void onBackfire() {
    }

    protected void backfire() {
        if (!this.backfired) {
            this.onBackfire();
        }
        this.backfired = true;
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        boolean free;
        SpellResult result = null;
        this.controller.disablePhysics(parameters.getInt("disable_physics", 0));
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && random.nextDouble() < (double)this.backfireChance) {
                this.backfire();
            } else if (this.fizzleChance > 0.0f && random.nextDouble() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        if (this.backfired) {
            result = SpellResult.BACKFIRE;
        }
        this.processResult(result, parameters);
        boolean success = result.isSuccess();
        boolean requiresCost = success || this.castOnNoTarget && (result == SpellResult.NO_TARGET || result == SpellResult.NO_ACTION);
        boolean bl = free = !requiresCost && result.isFree();
        if (!free) {
            this.lastCast = System.currentTimeMillis();
            if (this.costs != null && !this.mage.isCostFree()) {
                for (CastingCost cost : this.costs) {
                    cost.use(this);
                }
            }
        }
        if (success) {
            ++this.castCount;
            if (this.template != null) {
                ++this.template.castCount;
            }
        }
        this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)result) + ChatColor.DARK_AQUA + " (" + success + ")");
        return success;
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String message = this.controller.getMessages().get("spells.default." + messageKey, def);
        message = this.controller.getMessages().get("spells." + this.spellKey.getBaseKey() + "." + messageKey, message);
        if (this.spellKey.isVariant()) {
            message = this.controller.getMessages().get("spells." + this.spellKey.getKey() + "." + messageKey, message);
        }
        if (message == null) {
            message = "";
        }
        String playerName = this.mage.getName();
        message = message.replace("$player", playerName);
        String materialName = this.getDisplayMaterialName();
        materialName = materialName == null ? "None" : materialName;
        message = message.replace("$material", materialName);
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result, ConfigurationSection parameters) {
        CastEvent castEvent = new CastEvent(this.mage, this, result);
        Bukkit.getPluginManager().callEvent((Event)castEvent);
        if (this.mage != null) {
            this.mage.onCast(this, result);
        }
        String resultName = result.name().toLowerCase();
        if (result.isSuccess()) {
            String message = null;
            if (result != SpellResult.CAST) {
                message = this.getMessage("cast");
            }
            if (result.isAlternate() && result != SpellResult.ALTERNATE) {
                message = this.getMessage("alternate", message);
            }
            message = this.getMessage(resultName, message);
            LivingEntity sourceEntity = this.mage.getLivingEntity();
            Entity targetEntity = this.getTargetEntity();
            if (targetEntity == sourceEntity) {
                message = this.getMessage("cast_self", message);
            } else if (targetEntity instanceof Player) {
                message = this.getMessage("cast_player", message);
            } else if (targetEntity instanceof LivingEntity) {
                message = this.getMessage("cast_livingentity", message);
            } else if (targetEntity instanceof Entity) {
                message = this.getMessage("cast_entity", message);
            }
            if (this.loud) {
                this.sendMessage(message);
            } else {
                this.castMessage(message);
            }
            this.messageTargets("cast_player_message");
        } else if (result != SpellResult.INSUFFICIENT_RESOURCES && result != SpellResult.COOLDOWN) {
            String message = null;
            if (result.isFailure() && result != SpellResult.FAIL) {
                message = this.getMessage("fail");
            }
            this.sendMessage(this.getMessage(resultName, message));
        }
        this.playEffects(resultName);
    }

    @Override
    public void messageTargets(String messageKey) {
        if (this.currentCast != null) {
            this.currentCast.messageTargets(messageKey);
        }
    }

    public void playEffects(String effectName, float scale) {
        this.playEffects(effectName, this.getCurrentCast(), scale);
    }

    @Override
    public void playEffects(String effectName) {
        this.playEffects(effectName, 1.0f);
    }

    @Override
    public void playEffects(String effectName, CastContext context) {
        this.playEffects(effectName, context, 1.0f);
    }

    @Override
    public void playEffects(String effectName, CastContext context, float scale) {
        context.playEffects(effectName, scale);
    }

    @Override
    public void target() {
    }

    @Override
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public boolean canTarget(Entity entity) {
        return true;
    }

    @Override
    public Entity getTargetEntity() {
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        return new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    protected void processParameters(ConfigurationSection parameters) {
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", (double)this.fizzleChance);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", (double)this.backfireChance);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.overrideLocation(parameters, "p", defaultLocation, this.controller.canCreateWorlds());
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
        this.preventPassThroughMaterials = parameters.contains("prevent_passthrough") ? this.controller.getMaterialSet(parameters.getString("prevent_passthrough")) : this.controller.getMaterialSet("indestructible");
        this.passthroughMaterials = parameters.contains("passthrough") ? this.controller.getMaterialSet(parameters.getString("passthrough")) : this.controller.getMaterialSet("passthrough");
        this.bypassDeactivate = parameters.getBoolean("bypass_deactivate", false);
        this.quiet = parameters.getBoolean("quiet", false);
        this.loud = parameters.getBoolean("loud", false);
        this.verticalSearchDistance = parameters.getInt("vertical_range", 8);
    }

    @Override
    public String getPermissionNode() {
        return "Magic.cast." + this.spellKey.getBaseKey();
    }

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    @Override
    public void initialize(MageController instance) {
        this.controller = instance;
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    @Override
    public void setCastCount(long count) {
        this.castCount = count;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public void onLoad(ConfigurationSection node) {
    }

    public void onSave(ConfigurationSection node) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getCostReduction() {
        return this.costReduction + this.mage.getCostReduction();
    }

    @Override
    public Spell createSpell() {
        BaseSpell spell = null;
        try {
            spell = (BaseSpell)this.getClass().newInstance();
            spell.initialize(this.controller);
            spell.loadTemplate(this.spellKey.getKey(), this.configuration);
            spell.template = this;
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error creating spell " + this.spellKey.getKey(), ex);
        }
        return spell;
    }

    @Override
    public boolean cast() {
        return this.cast(null, null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    @Override
    public final String getKey() {
        return this.spellKey.getKey();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null && this.icon.getMaterial() != Material.AIR;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getExtendedDescription() {
        return this.extendedDescription;
    }

    @Override
    public final String getLevelDescription() {
        return this.levelDescription;
    }

    @Override
    public final SpellKey getSpellKey() {
        return this.spellKey;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final double getWorth() {
        return this.worth;
    }

    @Override
    public final SpellCategory getCategory() {
        return this.category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(SpellResult result) {
        return this.getEffects(result.name().toLowerCase());
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    public String getCooldownDescription() {
        if (this.cooldown > 0) {
            int cooldownInSeconds = this.cooldown / 1000;
            if (cooldownInSeconds > 3600) {
                int hours = cooldownInSeconds / 3600;
                if (hours == 1) {
                    return this.controller.getMessages().get("cooldown.description_hour");
                }
                return this.controller.getMessages().get("cooldown.description_hours").replace("$hours", Integer.valueOf(hours).toString());
            }
            if (cooldownInSeconds > 60) {
                int minutes = cooldownInSeconds / 60;
                if (minutes == 1) {
                    return this.controller.getMessages().get("cooldown.description_minute");
                }
                return this.controller.getMessages().get("cooldown.description_minutes").replace("$minutes", Integer.valueOf(minutes).toString());
            }
            if (cooldownInSeconds > 1) {
                return this.controller.getMessages().get("cooldown.description_seconds").replace("$seconds", Integer.valueOf(cooldownInSeconds).toString());
            }
            return this.controller.getMessages().get("cooldown.description_moment");
        }
        return null;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public CastingCost getRequiredCost() {
        if (!this.mage.isCostFree() && this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                return cost;
            }
        }
        return null;
    }

    @Override
    public long getRemainingCooldown() {
        double cooldownReduction;
        long currentTime = System.currentTimeMillis();
        if (!this.mage.isCooldownFree() && (cooldownReduction = (double)(this.mage.getCooldownReduction() + this.cooldownReduction)) < 1.0 && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                return this.lastCast - (currentTime - (long)reducedCooldown);
            }
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setMage(Mage mage) {
        this.mage = mage;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        return cancelled;
    }

    @Override
    public void reactivate() {
        this.isActive = true;
        this.onActivate();
    }

    @Override
    public void activate() {
        if (!this.isActive) {
            this.mage.activateSpell(this);
        }
    }

    @Override
    public boolean deactivate() {
        return this.deactivate(false, false);
    }

    @Override
    public boolean deactivate(boolean force, boolean quiet) {
        if (!force && this.bypassDeactivate) {
            return false;
        }
        if (this.isActive) {
            this.isActive = false;
            this.onDeactivate();
            this.mage.deactivateSpell(this);
            if (!quiet) {
                this.sendMessage(this.getMessage("deactivate"));
            }
            if (this.currentCast != null) {
                this.currentCast.cancelEffects();
            }
        }
        return true;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public void load(ConfigurationSection node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            if (this.category != null && this.template == null) {
                this.category.addCasts(this.castCount, this.lastCast);
            }
            this.isActive = node.getBoolean("active", false);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    @Override
    public void save(ConfigurationSection node) {
        try {
            node.set("cast_count", (Object)this.castCount);
            node.set("last_cast", (Object)this.lastCast);
            node.set("active", (Object)(this.isActive ? Boolean.valueOf(true) : null));
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name);
            ex.printStackTrace();
        }
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection node) {
        this.spellKey = new SpellKey(key);
        this.configuration = node;
        this.loadTemplate(node);
    }

    @Override
    public void tick() {
        this.checkActiveDuration();
        this.checkActiveCosts();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        if (sender == null || this.bypassPermissions) {
            return true;
        }
        return this.controller.hasCastPermission(sender, this);
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.category != null) {
            return this.category.getColor();
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public abstract SpellResult onCast(ConfigurationSection var1);

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public String getIconURL() {
        return this.iconURL;
    }

    @Override
    public String getRequiredUpgradePath() {
        return this.requiredUpgradePath;
    }

    @Override
    public long getRequiredUpgradeCasts() {
        return this.requiredUpgradeCasts;
    }

    @Override
    public String getUpgradeDescription() {
        return this.upgradeDescription == null ? "" : this.upgradeDescription;
    }

    @Override
    public MageSpell getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(MageSpell upgrade) {
        this.upgrade = upgrade;
    }

    @Override
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    public CastContext getCurrentCast() {
        if (this.currentCast == null) {
            this.currentCast = new com.elmakers.mine.bukkit.action.CastContext(this);
        }
        return this.currentCast;
    }

    @Override
    public Entity getEntity() {
        return this.mage.getEntity();
    }

    @Override
    public String getEffectParticle() {
        if (this.particle == null) {
            return this.mage.getEffectParticleName();
        }
        return this.particle;
    }

    @Override
    public Color getEffectColor() {
        if (this.color == null) {
            return this.mage.getEffectColor();
        }
        return this.color;
    }

    @Override
    public boolean showUndoable() {
        return this.showUndoable;
    }

    public int getVerticalSearchDistance() {
        return this.verticalSearchDistance;
    }
}

