/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.lang.ref.WeakReference;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public abstract class Effect
implements Runnable {
    public EffectType type = EffectType.INSTANT;
    public Color color = null;
    public float speed = 1.0f;
    public int delay = 0;
    public int period = 1;
    public int iterations = 0;
    public Runnable callback = null;
    public float visibleRange = 32.0f;
    public int locationUpdateInterval = 100;
    public boolean autoOrient = true;
    public Vector offset = null;
    public Vector targetOffset = null;
    private Location location = null;
    private WeakReference<Entity> entity = new WeakReference<Object>(null);
    private Location target = null;
    private WeakReference<Entity> targetEntity = new WeakReference<Object>(null);
    private long lastLocationUpdate = 0L;
    private long lastTargetUpdate = 0L;
    private boolean done = false;
    protected final EffectManager effectManager;

    public Effect(EffectManager effectManager) {
        Validate.notNull((Object)effectManager, (String)"EffectManager cannot be null!");
        this.effectManager = effectManager;
    }

    public final void cancel() {
        this.cancel(true);
    }

    public final void cancel(boolean callback) {
        if (callback) {
            this.done();
        } else {
            this.done = true;
        }
    }

    private void done() {
        this.done = true;
        this.effectManager.done(this);
    }

    public final boolean isDone() {
        return this.done;
    }

    public abstract void onRun();

    @Override
    public final void run() {
        if (!this.validate()) {
            this.cancel();
            return;
        }
        if (this.done) {
            return;
        }
        try {
            this.onRun();
        }
        catch (Exception ex) {
            this.done();
            this.effectManager.onError(ex);
        }
        if (this.type == EffectType.REPEATING) {
            if (this.iterations == -1) {
                return;
            }
            --this.iterations;
            if (this.iterations < 1) {
                this.done();
            }
        } else {
            this.done();
        }
    }

    protected final boolean validate() {
        Location target;
        Location location = this.getLocation();
        if (location == null) {
            return false;
        }
        if (this.autoOrient && (target = this.getTarget()) != null) {
            Vector direction = target.toVector().subtract(location.toVector());
            location.setDirection(direction);
            target.setDirection(direction.multiply(-1));
        }
        return true;
    }

    public final void start() {
        this.effectManager.start(this);
    }

    public final void infinite() {
        this.type = EffectType.REPEATING;
        this.iterations = -1;
    }

    public Entity getEntity() {
        return (Entity)this.entity.get();
    }

    public Entity getTargetEntity() {
        return (Entity)this.targetEntity.get();
    }

    public final Location getLocation() {
        Entity entityReference = (Entity)this.entity.get();
        if (entityReference != null) {
            long now = System.currentTimeMillis();
            if (this.locationUpdateInterval == 0 || this.lastLocationUpdate == 0L || this.lastLocationUpdate + (long)this.locationUpdateInterval > now) {
                if (entityReference instanceof LivingEntity) {
                    this.setLocation(((LivingEntity)entityReference).getEyeLocation());
                } else {
                    this.setLocation(entityReference.getLocation());
                }
            }
        }
        return this.location;
    }

    public final Location getTarget() {
        Entity entityReference = (Entity)this.targetEntity.get();
        if (entityReference != null) {
            long now = System.currentTimeMillis();
            if (this.locationUpdateInterval == 0 || this.lastTargetUpdate == 0L || this.lastTargetUpdate + (long)this.locationUpdateInterval > now) {
                if (entityReference instanceof LivingEntity) {
                    this.setTarget(((LivingEntity)entityReference).getEyeLocation());
                } else {
                    this.setTarget(entityReference.getLocation());
                }
            }
        }
        return this.target;
    }

    public void setEntity(Entity entity) {
        this.entity = new WeakReference<Entity>(entity);
    }

    public void setTargetEntity(Entity entity) {
        this.targetEntity = new WeakReference<Entity>(entity);
    }

    public void setLocation(Location location) {
        Validate.notNull((Object)location, (String)"Location cannot be null!");
        Location location2 = this.location = location == null ? null : location.clone();
        if (this.offset != null && this.location != null) {
            this.location = this.location.add(this.offset);
            this.lastLocationUpdate = System.currentTimeMillis();
        }
    }

    public void setTarget(Location location) {
        Location location2 = this.target = location == null ? null : location.clone();
        if (this.targetOffset != null && this.target != null) {
            this.target = this.target.add(this.targetOffset);
            this.lastTargetUpdate = System.currentTimeMillis();
        }
    }

    protected void display(ParticleEffect effect, Location location) {
        this.display(effect, location, this.color);
    }

    protected void display(ParticleEffect particle, Location location, Color color) {
        this.display(particle, location, color, 0.0f, 1);
    }

    protected void display(ParticleEffect particle, Location location, float speed, int amount) {
        this.display(particle, location, this.color, speed, amount);
    }

    protected void display(ParticleEffect particle, Location location, Color color, float speed, int amount) {
        particle.display(null, location, color, (double)this.visibleRange, 0.0f, 0.0f, 0.0f, speed, amount);
    }
}

