/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.protection.WGCustomFlagsManager;
import com.sk89q.worldguard.bukkit.RegionContainer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardAPI {
    private WorldGuardPlugin worldGuard = null;
    private WGCustomFlagsManager customFlags = null;

    public boolean isEnabled() {
        return this.worldGuard != null;
    }

    public WorldGuardAPI(Plugin plugin, Plugin owningPlugin) {
        if (plugin instanceof WorldGuardPlugin) {
            this.worldGuard = (WorldGuardPlugin)plugin;
            try {
                Plugin customFlagsPlugin = plugin.getServer().getPluginManager().getPlugin("WGCustomFlags");
                if (customFlagsPlugin != null) {
                    this.customFlags = new WGCustomFlagsManager(customFlagsPlugin);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.customFlags != null) {
                owningPlugin.getLogger().info("WGCustomFlags found, added custom flags");
            }
        }
    }

    protected RegionAssociable getAssociable(Player player) {
        Object associable = player == null ? Associables.constant((Association)Association.NON_MEMBER) : this.worldGuard.wrapPlayer(player);
        return associable;
    }

    public boolean isPVPAllowed(Player player, Location location) {
        if (this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(this.getAssociable(player), new StateFlag[]{DefaultFlag.PVP}) != StateFlag.State.DENY;
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (block != null && this.worldGuard != null) {
            RegionContainer container = this.worldGuard.getRegionContainer();
            return container.createQuery().testState(block.getLocation(), this.getAssociable(player), new StateFlag[]{DefaultFlag.BUILD});
        }
        return true;
    }

    public Boolean getCastPermission(Player player, SpellTemplate spell, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getCastPermission(this.getAssociable(player), checkSet, spell);
        }
        return null;
    }
}

