/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.mewin.WGCustomFlags.WGCustomFlagsPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public class WGCustomFlagsManager {
    private final WGCustomFlagsPlugin customFlags;
    public static SetFlag<String> ALLOWED_SPELLS = new SetFlag("allowed-spells", (Flag)new StringFlag(null));
    public static SetFlag<String> BLOCKED_SPELLS = new SetFlag("blocked-spells", (Flag)new StringFlag(null));
    public static SetFlag<String> ALLOWED_SPELL_CATEGORIES = new SetFlag("allowed-spell-categories", (Flag)new StringFlag(null));
    public static SetFlag<String> BLOCKED_SPELL_CATEGORIES = new SetFlag("blocked-spell-categories", (Flag)new StringFlag(null));

    public WGCustomFlagsManager(Plugin wgCustomFlags) {
        this.customFlags = (WGCustomFlagsPlugin)wgCustomFlags;
        this.customFlags.addCustomFlag(ALLOWED_SPELLS);
        this.customFlags.addCustomFlag(BLOCKED_SPELLS);
        this.customFlags.addCustomFlag(ALLOWED_SPELL_CATEGORIES);
        this.customFlags.addCustomFlag(BLOCKED_SPELL_CATEGORIES);
    }

    public Boolean getCastPermission(RegionAssociable source, ApplicableRegionSet checkSet, SpellTemplate spell) {
        String spellKey = spell.getSpellKey().getBaseKey();
        SpellCategory category = spell.getCategory();
        Set blocked = (Set)checkSet.queryValue(source, BLOCKED_SPELLS);
        if (blocked != null && blocked.contains(spellKey)) {
            return false;
        }
        Set blockedCategories = (Set)checkSet.queryValue(source, BLOCKED_SPELL_CATEGORIES);
        if (blockedCategories != null && category != null && blockedCategories.contains(category.getKey())) {
            return false;
        }
        Set allowed = (Set)checkSet.queryValue(source, ALLOWED_SPELLS);
        if (allowed != null && (allowed.contains("*") || allowed.contains(spellKey))) {
            return true;
        }
        Set allowedCategories = (Set)checkSet.queryValue(source, ALLOWED_SPELL_CATEGORIES);
        if (allowedCategories != null && category != null && allowedCategories.contains(category.getKey())) {
            return true;
        }
        if (blocked != null && blocked.contains("*")) {
            return false;
        }
        return null;
    }
}

