/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.magic.Automaton;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.maps.URLMap;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.RunnableJob;
import com.elmakers.mine.bukkit.utility.TimedRunnable;
import com.elmakers.mine.bukkit.wand.WandCleanupRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockVector;

public class MagicCommandExecutor
extends MagicTabExecutor {
    private RunnableJob runningTask = null;

    public MagicCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (args.length == 0) {
            if (!this.api.hasPermission(sender, "Magic.commands.magic")) {
                this.sendNoPermission(sender);
                return true;
            }
            sender.sendMessage("Magic " + MagicCommandExecutor.getMagicVersion());
            return true;
        }
        String subCommand = args[0];
        if (sender instanceof Player && !this.api.hasPermission(sender, "Magic.commands.magic." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("save")) {
            this.api.save();
            sender.sendMessage("Data saved.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("load")) {
            this.api.reload();
            sender.sendMessage("Configuration reloaded.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("clearcache")) {
            this.api.clearCache();
            sender.sendMessage("Image map and schematic caches cleared.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("commit")) {
            if (this.api.commit()) {
                sender.sendMessage("All changes committed");
            } else {
                sender.sendMessage("Nothing to commit");
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell") || subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("check") || subCommand.equalsIgnoreCase("debug")) {
            player = null;
            int argStart = 1;
            if (sender instanceof Player) {
                if (args.length > 1) {
                    player = Bukkit.getPlayer((String)args[1]);
                }
                if (player == null) {
                    player = (Player)sender;
                } else {
                    argStart = 2;
                }
            } else {
                if (args.length <= 1) {
                    sender.sendMessage("Must specify a player name");
                    return true;
                }
                argStart = 2;
                player = Bukkit.getPlayer((String)args[1]);
                if (player == null) {
                    sender.sendMessage("Can't find player " + args[1]);
                    return true;
                }
                if (!player.isOnline()) {
                    sender.sendMessage("Player " + args[1] + " is not online");
                    return true;
                }
            }
            String[] args2 = Arrays.copyOfRange(args, argStart, args.length);
            if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell")) {
                boolean showWorth = subCommand.equalsIgnoreCase("sell");
                return this.onMagicGive(sender, player, subCommand, args2);
            }
            if (subCommand.equalsIgnoreCase("check")) {
                return this.onMagicCheck(sender, player, args2);
            }
            if (subCommand.equalsIgnoreCase("debug")) {
                return this.onMagicDebug(sender, player, args2);
            }
            if (subCommand.equalsIgnoreCase("describe")) {
                return this.onMagicDescribe(sender, player, args2);
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                return this.onMagicConfigure(sender, player, args2);
            }
        }
        if (subCommand.equalsIgnoreCase("worth")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command may only be used in-game");
                return true;
            }
            player = (Player)sender;
            ItemStack item = player.getItemInHand();
            if (item == null || item.getType() == Material.AIR) {
                player.sendMessage("You must be holding an item");
                return true;
            }
            this.showWorth((CommandSender)player, item);
            return true;
        }
        if (subCommand.equalsIgnoreCase("list")) {
            String usage = "Usage: magic list <wands [player]|maps [keyword]|automata|tasks>";
            String listCommand = "";
            if (args.length > 1) {
                listCommand = args[1];
                if (!this.api.hasPermission(sender, "Magic.commands.magic." + subCommand + "." + listCommand)) {
                    this.sendNoPermission(sender);
                    return false;
                }
            } else {
                sender.sendMessage(ChatColor.GRAY + "For more specific information, add 'tasks', 'wands', 'maps' or 'automata' parameter.");
                Collection<Mage> mages = this.api.getMages();
                sender.sendMessage(ChatColor.AQUA + "Registered blocks (" + UndoList.getModified().size() + "): ");
                sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active mages: " + mages.size());
                Collection<Mage> pending = this.api.getMagesWithPendingBatches();
                sender.sendMessage(ChatColor.AQUA + "Pending batches (" + pending.size() + "): ");
                for (Mage mage : pending) {
                    int n = 0;
                    int totalRemaining = 0;
                    Collection<Batch> pendingBatches = mage.getPendingBatches();
                    String names = "";
                    if (pendingBatches.size() > 0) {
                        for (Batch batch : pendingBatches) {
                            if (batch instanceof SpellBatch) {
                                names = names + ((SpellBatch)batch).getSpell().getName() + " ";
                            }
                            n += batch.size();
                            totalRemaining = batch.remaining();
                        }
                    }
                    sender.sendMessage(ChatColor.AQUA + mage.getName() + ChatColor.GRAY + " has " + ChatColor.WHITE + "" + pendingBatches.size() + "" + ChatColor.GRAY + " pending (" + ChatColor.WHITE + "" + totalRemaining + "/" + n + "" + ChatColor.GRAY + ") (" + names + ")");
                }
                return true;
            }
            if (listCommand.equalsIgnoreCase("tasks")) {
                String pluginName;
                List tasks = Bukkit.getScheduler().getPendingTasks();
                HashMap<String, Integer> pluginCounts = new HashMap<String, Integer>();
                HashMap taskCounts = new HashMap();
                for (BukkitTask bukkitTask : tasks) {
                    Integer count;
                    pluginName = bukkitTask.getOwner().getName();
                    HashMap<String, Integer> pluginTaskCounts = (HashMap<String, Integer>)taskCounts.get(pluginName);
                    if (pluginTaskCounts == null) {
                        pluginTaskCounts = new HashMap<String, Integer>();
                        taskCounts.put(pluginName, pluginTaskCounts);
                    }
                    String className = "(Unknown)";
                    Runnable taskRunnable = CompatibilityUtils.getTaskRunnable(bukkitTask);
                    if (taskRunnable != null) {
                        if (taskRunnable instanceof TimedRunnable) {
                            TimedRunnable timed = (TimedRunnable)taskRunnable;
                            long count2 = timed.getCount();
                            long totalTime = timed.getTotalTime();
                            long avg = count2 == 0L ? 0L : totalTime / count2;
                            className = timed.getName() + "(" + totalTime + ", " + count2 + ", " + avg + ")";
                        } else {
                            Class<?> taskClass = taskRunnable.getClass();
                            if (taskClass != null) {
                                className = taskClass.getName();
                            }
                        }
                    }
                    if ((count = (Integer)pluginTaskCounts.get(className)) == null) {
                        count = 0;
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    pluginTaskCounts.put(className, count);
                    Integer totalCount = (Integer)pluginCounts.get(pluginName);
                    if (count == null) {
                        count = 0;
                    }
                    n2 = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    pluginCounts.put(pluginName, count);
                }
                sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active tasks: " + tasks.size());
                for (Map.Entry entry : taskCounts.entrySet()) {
                    pluginName = (String)entry.getKey();
                    sender.sendMessage(" " + ChatColor.DARK_PURPLE + pluginName + ": " + ChatColor.LIGHT_PURPLE + pluginCounts.get(pluginName));
                    for (Map.Entry taskEntry : ((HashMap)entry.getValue()).entrySet()) {
                        sender.sendMessage("  " + ChatColor.DARK_PURPLE + (String)taskEntry.getKey() + ": " + ChatColor.LIGHT_PURPLE + taskEntry.getValue());
                    }
                }
                return true;
            }
            if (listCommand.equalsIgnoreCase("wands")) {
                String owner = "";
                if (args.length > 2) {
                    owner = args[2];
                }
                Collection<LostWand> lostWands = this.api.getLostWands();
                int shown = 0;
                for (LostWand lostWand : lostWands) {
                    Location location = lostWand.getLocation();
                    if (location == null || owner.length() > 0 && !owner.equalsIgnoreCase(lostWand.getOwner())) continue;
                    ++shown;
                    sender.sendMessage(ChatColor.AQUA + lostWand.getName() + ChatColor.WHITE + " (" + lostWand.getOwner() + ") @ " + ChatColor.BLUE + location.getWorld().getName() + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
                }
                sender.sendMessage(shown + " lost wands found" + (owner.length() > 0 ? " for " + owner : ""));
                return true;
            }
            if (listCommand.equalsIgnoreCase("automata")) {
                Collection<Automaton> automata = this.api.getAutomata();
                for (Automaton automaton : automata) {
                    BlockVector location = automaton.getPosition();
                    String string = automaton.getWorldName();
                    boolean isOnline = false;
                    World world = Bukkit.getWorld((String)string);
                    if (string != null) {
                        Location automatonLocation = new Location(world, location.getX(), location.getY(), location.getZ());
                        Chunk chunk = world.getChunkAt(automatonLocation);
                        isOnline = chunk.isLoaded();
                    }
                    ChatColor nameColor = isOnline ? ChatColor.AQUA : ChatColor.GRAY;
                    sender.sendMessage(nameColor + automaton.getName() + ChatColor.WHITE + " @ " + ChatColor.BLUE + string + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
                }
                sender.sendMessage(automata.size() + " automata active");
                return true;
            }
            if (listCommand.equalsIgnoreCase("maps")) {
                String keyword = "";
                if (args.length > 2) {
                    keyword = args[2];
                }
                int shown = 0;
                MageController apiController = this.api.getController();
                Collection<URLMap> maps = this.api.getController().getMaps().getAll();
                for (URLMap map : maps) {
                    Short mapId = map.getId();
                    if (map == null || mapId == null || !map.matches(keyword)) continue;
                    ++shown;
                    String name = map.getName();
                    name = name == null ? "(None)" : name;
                    sender.sendMessage(ChatColor.AQUA + "" + mapId + ChatColor.WHITE + ": " + name + " => " + ChatColor.GRAY + map.getURL());
                }
                if (shown == 0) {
                    sender.sendMessage("No maps found" + (keyword.length() > 0 ? " matching " + keyword : "") + ", use /castp <player> camera [url|player] [...]");
                } else {
                    sender.sendMessage(shown + " maps found matching " + keyword);
                }
                return true;
            }
            sender.sendMessage(usage);
            return true;
        }
        if (subCommand.equalsIgnoreCase("cancel")) {
            this.checkRunningTask();
            if (this.runningTask != null) {
                this.runningTask.cancel();
                this.runningTask = null;
                sender.sendMessage("Job cancelled");
            } else {
                sender.sendMessage("There is no job running");
            }
            int stoppedPending = 0;
            for (Mage mage : this.api.getMages()) {
                while (mage.cancelPending() != null) {
                    ++stoppedPending;
                }
            }
            sender.sendMessage("Stopped " + stoppedPending + " pending construction batches");
            return true;
        }
        if (subCommand.equalsIgnoreCase("clean")) {
            String ownerName;
            this.checkRunningTask();
            if (this.runningTask != null) {
                sender.sendMessage("Cancel current job first");
                return true;
            }
            World world = null;
            String owner = null;
            if (args.length > 1) {
                owner = args[1];
            }
            if (sender instanceof Player) {
                world = ((Player)sender).getWorld();
            } else if (args.length > 2) {
                String worldName = args[2];
                world = Bukkit.getWorld((String)worldName);
            }
            boolean check = false;
            if (owner != null && owner.equals("check")) {
                check = true;
                owner = "ALL";
            }
            String description = check ? "Checking for" : "Cleaning up";
            String string = ownerName = owner == null ? "(Unowned)" : owner;
            if (world == null) {
                sender.sendMessage(description + " lost wands in all worlds for owner: " + ownerName);
            } else if (ownerName.equals("ALL")) {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for ALL owners");
            } else {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for owner " + ownerName);
            }
            this.runningTask = new WandCleanupRunnable(this.api, world, owner, check);
            this.runningTask.runTaskTimer(this.api.getPlugin(), 5L, 5L);
            return true;
        }
        sender.sendMessage("Unknown magic command: " + subCommand);
        return true;
    }

    protected boolean onMagicGive(CommandSender sender, Player player, String command, String[] args) {
        String playerCommand = sender instanceof Player ? "" : "<player> ";
        String usageString = "Usage: /magic give " + playerCommand + "<spellname|'material'|'upgrade'|'wand'> [materialname|wandname]";
        if (args.length == 0) {
            sender.sendMessage(usageString);
            return true;
        }
        String key = "";
        boolean isMaterial = false;
        boolean isWand = false;
        boolean isUpgrade = false;
        if (!(args.length <= 1 || args[0].equals("material") || args[0].equals("wand") || args[0].equals("upgrade"))) {
            sender.sendMessage(usageString);
            return true;
        }
        if (args[0].equals("wand")) {
            isWand = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("upgrade")) {
            isUpgrade = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("material")) {
            if (args.length < 2) {
                sender.sendMessage(usageString);
                return true;
            }
            isMaterial = true;
            key = args[1];
        } else {
            key = args[0];
        }
        boolean giveItem = command.equals("give") || command.equals("sell");
        boolean showWorth = command.equals("worth") || command.equals("sell");
        boolean giveValue = command.equals("sell");
        if (isWand) {
            this.giveWand(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isMaterial) {
            this.onGiveBrush(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isUpgrade) {
            this.onGiveUpgrade(sender, player, key, false, giveItem, giveValue, showWorth);
        } else {
            this.onGive(sender, player, key, giveItem, giveValue, showWorth);
        }
        return true;
    }

    protected void onGive(CommandSender sender, Player player, String key, boolean giveItem, boolean giveValue, boolean showWorth) {
        if (!(this.onGiveSpell(sender, player, key, true, giveItem, giveValue, showWorth) || this.onGiveBrush(sender, player, key, true, giveItem, giveValue, showWorth) || this.giveWand(sender, player, key, true, giveItem, giveValue, showWorth))) {
            sender.sendMessage("Failed to create a spell, brush or wand item for " + key);
        }
    }

    protected boolean onGiveSpell(CommandSender sender, Player player, String spellKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createSpellItem(spellKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create spell item for " + spellKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave spell " + spellKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveBrush(CommandSender sender, Player player, String materialKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createBrushItem(materialKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create material item for " + materialKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave brush " + materialKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveUpgrade(CommandSender sender, Player player, String wandKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        Wand wand;
        Mage mage = this.api.getMage((CommandSender)player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if ((wand = this.api.createWand(wandKey)) != null) {
            wand.makeUpgrade();
            if (giveItem) {
                this.api.giveItemToPlayer(player, wand.getItem());
                if (sender != player && !quiet) {
                    sender.sendMessage("Gave upgrade " + wand.getName() + " to " + player.getName());
                }
            }
            if (showWorth) {
                this.showWorth(sender, wand.getItem());
            }
        } else {
            if (!quiet) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandKey));
            }
            return false;
        }
        return true;
    }

    protected void checkRunningTask() {
        if (this.runningTask != null && this.runningTask.isFinished()) {
            this.runningTask = null;
        }
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "clean");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "clearcache");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "cancel");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "load");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "save");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "commit");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "give");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "worth");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "sell");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "list");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "describe");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "configure");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "check");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "debug");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("list")) {
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "maps");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "wands");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "automata");
            }
            if (args[0].equalsIgnoreCase("configure") || args[0].equalsIgnoreCase("describe") || args[0].equalsIgnoreCase("check") || args[0].equalsIgnoreCase("debug")) {
                options.addAll(this.api.getPlayerNames());
            } else if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("worth") || args[0].equalsIgnoreCase("sell")) {
                options.add("wand");
                options.add("material");
                options.add("upgrade");
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates();
                for (SpellTemplate spell : spellList) {
                    options.add(spell.getKey());
                }
                Collection<String> allWands = this.api.getWandKeys();
                for (String wandKey : allWands) {
                    options.add(wandKey);
                }
                options.addAll(this.api.getBrushes());
            }
        } else if (args.length == 3) {
            Player player;
            if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("sell")) {
                if (args[1].equalsIgnoreCase("upgrade") || args[1].equalsIgnoreCase("wand")) {
                    Collection<String> allWands = this.api.getWandKeys();
                    for (String wandKey : allWands) {
                        options.add(wandKey);
                    }
                } else if (args[1].equalsIgnoreCase("material")) {
                    options.addAll(this.api.getBrushes());
                }
            } else if ((args[0].equalsIgnoreCase("configure") || args[0].equalsIgnoreCase("describe")) && (player = Bukkit.getPlayer((String)args[1])) != null) {
                Mage mage = this.api.getMage((CommandSender)player);
                ConfigurationSection data = mage.getData();
                options.addAll(data.getKeys(false));
            }
        }
        return options;
    }

    public static String formatBoolean(Boolean flag) {
        if (flag == null) {
            return ChatColor.GRAY + "none";
        }
        return flag != false ? ChatColor.GREEN + "true" : ChatColor.RED + "false";
    }

    public boolean onMagicCheck(CommandSender sender, Player player, String[] args) {
        Mage mage = this.api.getMage((CommandSender)player);
        Wand wand = mage.getActiveWand();
        Location location = player.getLocation();
        MageController controller = this.api.getController();
        Spell spell = wand == null ? null : wand.getActiveSpell();
        sender.sendMessage(ChatColor.GOLD + "Permission check for " + ChatColor.AQUA + player.getDisplayName());
        sender.sendMessage(ChatColor.GOLD + " at " + ChatColor.AQUA + location.getWorld().getName() + "|" + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + ChatColor.GOLD + ": ");
        sender.sendMessage(ChatColor.AQUA + " Has bypass: " + MagicCommandExecutor.formatBoolean(player.hasPermission("Magic.bypass")));
        sender.sendMessage(ChatColor.AQUA + " Has PVP bypass: " + MagicCommandExecutor.formatBoolean(player.hasPermission("Magic.bypass_pvp")));
        sender.sendMessage(ChatColor.AQUA + " Has Build bypass: " + MagicCommandExecutor.formatBoolean(player.hasPermission("Magic.bypass_build")));
        sender.sendMessage(ChatColor.AQUA + " Can build: " + MagicCommandExecutor.formatBoolean(mage.hasBuildPermission(location.getBlock())));
        sender.sendMessage(ChatColor.AQUA + " Can pvp: " + MagicCommandExecutor.formatBoolean(mage.isPVPAllowed(location)));
        if (spell != null) {
            sender.sendMessage(ChatColor.AQUA + " Has pnode " + ChatColor.GOLD + spell.getName() + ChatColor.AQUA + ": " + MagicCommandExecutor.formatBoolean(spell.hasCastPermission((CommandSender)player)));
            sender.sendMessage(ChatColor.AQUA + " Region override: " + MagicCommandExecutor.formatBoolean(controller.getRegionCastPermission(mage.getPlayer(), spell, location)));
            sender.sendMessage(ChatColor.AQUA + " Field override: " + MagicCommandExecutor.formatBoolean(controller.getPersonalCastPermission(mage.getPlayer(), spell, location)));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires build: " + MagicCommandExecutor.formatBoolean(spell.requiresBuildPermission()));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires pvp: " + MagicCommandExecutor.formatBoolean(spell.isPvpRestricted()));
            if (spell instanceof BaseSpell) {
                boolean buildPermission = ((BaseSpell)spell).hasBuildPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has build: " + MagicCommandExecutor.formatBoolean(buildPermission));
            }
            sender.sendMessage(ChatColor.AQUA + " Can cast " + ChatColor.GOLD + spell.getName() + ChatColor.AQUA + ": " + MagicCommandExecutor.formatBoolean(spell.canCast(location)));
        }
        return true;
    }

    public boolean onMagicDebug(CommandSender sender, Player player, String[] args) {
        Mage mage = this.api.getMage((CommandSender)player);
        if (args.length > 0) {
            try {
                int level = Integer.parseInt(args[0]);
                mage.setDebugLevel(level);
                sender.sendMessage(ChatColor.GOLD + "Setting debug level for  " + ChatColor.AQUA + player.getDisplayName() + ChatColor.GOLD + " to " + ChatColor.GREEN + Integer.toString(level));
            }
            catch (Exception ex) {
                sender.sendMessage("Expecting integer, got: " + args[0]);
            }
            return true;
        }
        if (mage.getDebugLevel() > 0) {
            sender.sendMessage(ChatColor.GOLD + "Disabling debug for  " + ChatColor.AQUA + player.getDisplayName());
            mage.setDebugLevel(0);
        } else {
            sender.sendMessage(ChatColor.AQUA + "Enabling debug for  " + ChatColor.AQUA + player.getDisplayName());
            mage.setDebugLevel(1);
        }
        return true;
    }

    public boolean onMagicDescribe(CommandSender sender, Player player, String[] args) {
        Mage mage = this.api.getMage((CommandSender)player);
        ConfigurationSection data = mage.getData();
        if (args != null && args.length > 0) {
            if (args[0].equals("*")) {
                sender.sendMessage(ChatColor.GOLD + "Mage data for " + ChatColor.AQUA + player.getDisplayName() + ChatColor.GOLD + ": ");
                Collection<Spell> spells = mage.getSpells();
                if (spells.size() == 0) {
                    sender.sendMessage(ChatColor.RED + "No spell casts!");
                    return true;
                }
                for (Spell spell : spells) {
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + spell.getName() + ChatColor.AQUA + " Cast Count: " + ChatColor.GOLD + spell.getCastCount());
                }
                return true;
            }
            MageSpell spell = mage.getSpell(args[0]);
            if (spell != null) {
                sender.sendMessage(ChatColor.GOLD + "Mage data for " + ChatColor.AQUA + player.getDisplayName() + ChatColor.GOLD + ": " + ChatColor.LIGHT_PURPLE + spell.getName());
                sender.sendMessage(ChatColor.AQUA + " Cast Count: " + ChatColor.GOLD + spell.getCastCount());
                return true;
            }
            ConfigurationSection subSection = data.getConfigurationSection(args[0]);
            if (subSection == null) {
                sender.sendMessage(ChatColor.RED + "Unknown subsection: " + args[0]);
                return true;
            }
            data = subSection;
        }
        Set keys = data.getKeys(false);
        sender.sendMessage(ChatColor.GOLD + "Mage data for " + ChatColor.AQUA + player.getDisplayName());
        for (String key : keys) {
            if (data.isConfigurationSection(key)) {
                ConfigurationSection subSection = data.getConfigurationSection(key);
                sender.sendMessage(ChatColor.AQUA + " " + key + ChatColor.DARK_AQUA + " (" + subSection.getKeys(true).size() + " items)");
                continue;
            }
            String value = data.getString(key);
            if (value != null) {
                sender.sendMessage(ChatColor.AQUA + " " + key + ChatColor.DARK_AQUA + " (" + value + ")");
                continue;
            }
            sender.sendMessage(ChatColor.AQUA + " " + key);
        }
        return true;
    }

    public boolean onMagicConfigure(CommandSender sender, Player player, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(ChatColor.RED + "Usage: " + ChatColor.AQUA + "magic configure <player> <key> <value>");
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        if (args[0].equals("*")) {
            long value = 0L;
            try {
                value = Long.parseLong(args[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Cast count must be a number");
                return true;
            }
            Collection<Spell> spells = mage.getSpells();
            for (Spell spell : spells) {
                spell.setCastCount(value);
            }
            sender.sendMessage(ChatColor.GOLD + "Set all spell cast counts to " + ChatColor.AQUA + value + ChatColor.GOLD + " for " + ChatColor.DARK_AQUA + player.getDisplayName());
            return true;
        }
        MageSpell spell = mage.getSpell(args[0]);
        if (spell != null) {
            long value = 0L;
            try {
                value = Long.parseLong(args[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Cast count must be a number");
                return true;
            }
            spell.setCastCount(value);
            sender.sendMessage(ChatColor.GOLD + "Set " + ChatColor.AQUA + spell.getName() + ChatColor.GOLD + " cast count to " + ChatColor.AQUA + value + ChatColor.GOLD + " for " + ChatColor.DARK_AQUA + player.getDisplayName());
            return true;
        }
        ConfigurationSection data = mage.getData();
        String key = args[0];
        String value = args[1];
        data.set(key, (Object)value);
        sender.sendMessage(ChatColor.GOLD + "Set " + ChatColor.AQUA + key + ChatColor.GOLD + " to " + ChatColor.AQUA + value + ChatColor.GOLD + " for " + ChatColor.DARK_AQUA + player.getDisplayName());
        return true;
    }
}

