/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.MagicController;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class PhysicsHandler
implements Listener {
    private final MagicController controller;
    private long timeout = 0L;

    public PhysicsHandler(MagicController controller) {
        this.controller = controller;
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.allowPhysics(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    protected boolean allowPhysics(Block block) {
        if (this.timeout == 0L) {
            this.controller.unregisterPhysicsHandler(this);
            return true;
        }
        if (System.currentTimeMillis() > this.timeout) {
            this.controller.unregisterPhysicsHandler(this);
            this.timeout = 0L;
        }
        return false;
    }

    public void setInterval(long interval) {
        this.timeout = System.currentTimeMillis() + interval;
    }
}

