/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.ref.WeakReference;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.BlockVector;

public class BlockData
extends MaterialAndData
implements com.elmakers.mine.bukkit.api.block.BlockData {
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] SIDES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST};
    protected com.elmakers.mine.bukkit.api.block.BlockData nextState;
    protected com.elmakers.mine.bukkit.api.block.BlockData priorState;
    protected BlockVector location;
    protected String worldName;
    protected WeakReference<UndoList> undoList = null;

    public static long getBlockId(Block block) {
        return BlockData.getBlockId(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public static long getBlockId(String world, int x, int y, int z) {
        return (long)((world.hashCode() & 0xF) << 56) | ((long)x & 0xFFFFFFL) << 32 | ((long)z & 0xFFFFFFL) << 8 | (long)y & 0xFFL;
    }

    @Override
    public int hashCode() {
        return (int)this.getId();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BlockData) {
            return this.getId() == ((BlockData)other).getId();
        }
        return super.equals(other);
    }

    @Override
    public long getId() {
        return BlockData.getBlockId(this.worldName, this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    public static BlockFace getReverseFace(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case EAST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.DOWN;
            }
            case DOWN: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    public BlockData() {
    }

    public BlockData(Block block) {
        super(block);
        this.location = new BlockVector(block.getX(), block.getY(), block.getZ());
        this.worldName = block.getWorld().getName();
    }

    public BlockData(com.elmakers.mine.bukkit.api.block.BlockData copy) {
        super(copy);
        this.location = copy.getPosition();
        this.worldName = copy.getWorldName();
    }

    public BlockData(Location location, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.worldName = location.getWorld().getName();
    }

    public BlockData(int x, int y, int z, String world, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(x, y, z);
        this.worldName = world;
    }

    public BlockData(ConfigurationSection node) {
        this(ConfigurationUtils.getLocation(node, "location"), ConfigurationUtils.getMaterial(node, "material"), (byte)node.getInt("data", 0));
    }

    public void save(ConfigurationSection node) {
        node.set("material", (Object)ConfigurationUtils.fromMaterial(this.material));
        node.set("data", (Object)this.data);
        Location location = new Location(Bukkit.getWorld((String)this.worldName), this.location.getX(), this.location.getY(), this.location.getZ());
        node.set("location", (Object)ConfigurationUtils.fromLocation(location));
    }

    protected boolean checkBlock() {
        return this.getBlock() != null;
    }

    public void setPosition(BlockVector location) {
        this.location = location;
    }

    @Override
    public void unlink() {
        if (this.priorState != null) {
            this.priorState.setNextState(this.nextState);
        }
        if (this.nextState != null) {
            this.nextState.setPriorState(this.priorState);
        }
        this.priorState = null;
        this.nextState = null;
    }

    @Override
    public boolean undo() {
        return this.undo(false);
    }

    @Override
    public boolean undo(boolean applyPhysics) {
        Block block = this.getBlock();
        if (block == null) {
            return true;
        }
        Chunk chunk = block.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load();
            return false;
        }
        if (this.nextState != null) {
            this.nextState.updateFrom(this);
        } else if (this.isDifferent(block)) {
            this.modify(block, applyPhysics);
        }
        this.unlink();
        return true;
    }

    @Override
    public void commit() {
        if (this.nextState != null) {
            this.nextState.setPriorState(null);
            this.nextState.updateFrom(this.getBlock());
            this.nextState = null;
        }
        if (this.priorState != null) {
            this.priorState.setNextState(null);
            this.priorState.updateFrom(this.getBlock());
            this.priorState.commit();
            this.priorState = null;
        }
    }

    public String toString() {
        return this.location.getBlockX() + "," + this.location.getBlockY() + "," + this.location.getBlockZ() + "," + this.worldName + "|" + this.getMaterial().getId() + ":" + this.getData();
    }

    public static BlockData fromString(String s) {
        BlockData result = null;
        if (s == null) {
            return null;
        }
        try {
            String[] pieces = StringUtils.split((String)s, (char)'|');
            String[] locationPieces = StringUtils.split((String)pieces[0], (char)',');
            int x = Integer.parseInt(locationPieces[0]);
            int y = Integer.parseInt(locationPieces[1]);
            int z = Integer.parseInt(locationPieces[2]);
            String world = locationPieces[3];
            String[] materialPieces = StringUtils.split((String)pieces[1], (char)':');
            int materialId = Integer.parseInt(materialPieces[0]);
            byte dataId = Byte.parseByte(materialPieces[1]);
            return new BlockData(x, y, z, world, Material.getMaterial((int)materialId), dataId);
        }
        catch (Exception exception) {
            return result;
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.BlockData getNextState() {
        return this.nextState;
    }

    @Override
    public void setNextState(com.elmakers.mine.bukkit.api.block.BlockData next) {
        this.nextState = next;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.BlockData getPriorState() {
        return this.priorState;
    }

    @Override
    public void setPriorState(com.elmakers.mine.bukkit.api.block.BlockData prior) {
        this.priorState = prior;
    }

    @Override
    public void restore() {
        this.restore(false);
    }

    @Override
    public void restore(boolean applyPhysics) {
        this.modify(this.getBlock(), applyPhysics);
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public BlockVector getPosition() {
        return this.location;
    }

    @Override
    public World getWorld() {
        if (this.worldName == null || this.worldName.length() == 0) {
            return null;
        }
        return Bukkit.getWorld((String)this.worldName);
    }

    @Override
    public Block getBlock() {
        World world;
        Block block = null;
        if (this.location != null && (world = this.getWorld()) != null) {
            block = world.getBlockAt(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
        }
        return block;
    }

    @Override
    public boolean isDifferent() {
        return this.isDifferent(this.getBlock());
    }

    @Override
    public UndoList getUndoList() {
        return this.undoList != null ? (UndoList)this.undoList.get() : null;
    }

    @Override
    public void setUndoList(UndoList list) {
        if (list == null) {
            this.undoList = null;
            return;
        }
        this.undoList = new WeakReference<UndoList>(list);
    }

    @Override
    public BlockVector getLocation() {
        return this.location;
    }
}

