/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpellShopAction
extends BaseShopAction {
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    private boolean showRequired = false;
    private boolean autoUpgrade = false;
    private boolean showFree = false;
    private Map<String, Double> spells = new HashMap<String, Double>();

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.spells.clear();
        if (parameters.contains("spells")) {
            ConfigurationSection spellSection = parameters.getConfigurationSection("spells");
            Set spellKeys = spellSection.getKeys(false);
            for (String spellKey : spellKeys) {
                this.spells.put(spellKey, spellSection.getDouble(spellKey));
            }
        }
    }

    @Override
    public void deactivated() {
    }

    @Override
    protected void onPurchase(CastContext context) {
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath nextPath;
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        if (wand == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
        if (nextPath != null && this.autoUpgrade && path.checkUpgradeRequirements(wand, null) && !path.canEnchant(wand)) {
            path.upgrade(wand, mage);
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requiredPath = parameters.getString("path", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.showRequired = parameters.getBoolean("show_required", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", false);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Wand wand = mage.getActiveWand();
        if (wand == null) {
            context.sendMessage("no_wand");
            return SpellResult.FAIL;
        }
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                context.sendMessage(context.getMessage("no_path").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath) || this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = WandUpgradePath.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.sendMessage(context.getMessage("no_required_path").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath pathUpgrade = path.getUpgrade();
                if (pathUpgrade == null) {
                    context.sendMessage(context.getMessage("no_upgrade").replace("$wand", wand.getName()));
                    return SpellResult.FAIL;
                }
                if (path.canEnchant(wand)) {
                    context.sendMessage(context.getMessage("no_path_end").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        HashMap<String, Double> spellPrices = new HashMap<String, Double>();
        if (this.spells.size() > 0) {
            spellPrices.putAll(this.spells);
        } else {
            if (path == null) {
                context.sendMessage(context.getMessage("no_path").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            Collection<String> pathSpells = path.getSpells();
            for (String string : pathSpells) {
                spellPrices.put(string, null);
            }
            if (this.showRequired) {
                Collection<String> requiredSpells = path.getRequiredSpells();
                for (String requiredSpell : requiredSpells) {
                    spellPrices.put(requiredSpell, null);
                }
            }
        }
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        for (Map.Entry entry : spellPrices.entrySet()) {
            String spellKey = (String)entry.getKey();
            if (wand.hasSpell(spellKey)) continue;
            SpellTemplate spell = controller.getSpellTemplate(spellKey);
            Double worth = (Double)entry.getValue();
            if (worth == null) {
                worth = spell.getWorth();
                spellPrices.put(spellKey, worth);
            }
            if (worth <= 0.0 && !this.showFree) continue;
            ItemStack spellItem = controller.createSpellItem(spellKey);
            shopItems.add(new BaseShopAction.ShopItem(this, spellItem, worth));
        }
        return this.showItems(context, shopItems);
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("show_free");
        parameters.add("show_required");
        parameters.add("auto_upgrade");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else if (parameterKey.equals("show_free") || parameterKey.equals("show_required") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

