/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class LineAction
extends CompoundAction {
    private static final int DEFAULT_SIZE = 16;
    private boolean incrementData;
    private int size;
    private int startDistance;
    private boolean reverse;
    private boolean startAtTarget;
    private boolean requireBlock;
    private int destination;
    private int current;
    private Vector direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.incrementData = parameters.getBoolean("increment_data", false);
        this.size = parameters.getInt("size", 16);
        this.startDistance = parameters.getInt("start", 2);
        this.startAtTarget = parameters.getBoolean("start_at_target", false);
        this.reverse = parameters.getBoolean("reverse", false);
        this.requireBlock = parameters.getBoolean("require_block", false);
        Mage mage = context.getMage();
        this.size = (int)(mage.getConstructionMultiplier() * (float)this.size);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
        this.current = 0;
        Location startLocation = context.getEyeLocation();
        Location targetLocation = context.getTargetLocation();
        if (startLocation == null || targetLocation == null) {
            return;
        }
        Vector targetLoc = new Vector(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
        Vector playerLoc = startLocation.toVector();
        this.direction = targetLoc.clone();
        this.direction.subtract(playerLoc);
        this.direction.normalize();
        if (this.startAtTarget && !this.reverse) {
            this.destination = this.size;
        } else {
            if (this.startDistance > 0) {
                playerLoc.add(this.direction.clone().multiply(this.startDistance));
            }
            this.destination = (int)playerLoc.distance(targetLoc);
            if (this.destination <= 0) {
                return;
            }
            this.destination = Math.min(this.destination, this.size);
            if (this.reverse) {
                this.direction = this.direction.multiply(-1);
            } else {
                targetLocation.setX(playerLoc.getX());
                targetLocation.setY(playerLoc.getY());
                targetLocation.setZ(playerLoc.getZ());
                this.actionContext.setTargetLocation(targetLocation);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        MaterialBrush brush = context.getBrush();
        SpellResult result = SpellResult.NO_ACTION;
        while (this.current < this.destination) {
            Block lowerBlock;
            Block currentTarget = this.actionContext.getTargetBlock();
            if (this.incrementData) {
                short data = this.current > 15 ? (short)15 : (short)this.current;
                brush.setData(data);
            }
            if (this.requireBlock && ((lowerBlock = currentTarget.getRelative(BlockFace.DOWN)).getType() == Material.AIR || lowerBlock.getType() == brush.getMaterial())) {
                this.advance(context);
                this.skippedActions(context);
                continue;
            }
            SpellResult actionResult = super.perform(this.actionContext);
            result = result.min(actionResult);
            if (actionResult == SpellResult.PENDING) break;
            context.playEffects("iterate");
            this.advance(context);
        }
        return result;
    }

    protected void advance(CastContext context) {
        ++this.current;
        Location target = this.actionContext.getTargetLocation();
        target.add(this.direction);
        this.actionContext.setTargetLocation(target);
        super.reset(context);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("size");
        parameters.add("increment_data");
        parameters.add("require_block");
        parameters.add("reverse");
        parameters.add("start");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("increment_data") || parameterKey.equals("reverse") || parameterKey.equals("require_block")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("size") || parameterKey.equals("start")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public int getActionCount() {
        return this.destination * this.actions.getActionCount();
    }
}

