/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ItemShopAction
extends BaseShopAction {
    private Map<String, Double> items = new HashMap<String, Double>();

    @Override
    public void initialize(ConfigurationSection parameters) {
        super.initialize(parameters);
        this.items.clear();
        if (parameters.contains("items")) {
            ConfigurationSection itemSection = parameters.getConfigurationSection("items");
            Set itemKeys = itemSection.getKeys(false);
            for (String itemKey : itemKeys) {
                this.items.put(itemKey, itemSection.getDouble(itemKey));
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        MageController controller = context.getController();
        for (Map.Entry<String, Double> itemValue : this.items.entrySet()) {
            String itemKey = itemValue.getKey();
            double worth = this.items.get(itemKey);
            ItemStack item = controller.createItem(itemKey);
            if (item == null) continue;
            shopItems.add(new BaseShopAction.ShopItem(this, item, worth));
        }
        return this.showItems(context, shopItems);
    }
}

