/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveItemAction
extends BaseSpellAction {
    private ItemStack item = null;
    private ItemStack requireItem = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String costKey;
        super.prepare(context, parameters);
        MageController controller = context.getController();
        String itemKey = parameters.getString("item");
        this.item = controller.createItem(itemKey);
        if (this.item == null) {
            context.getLogger().warning("Invalid item: " + itemKey);
        }
        if ((costKey = parameters.getString("requires")) != null && !costKey.isEmpty()) {
            this.requireItem = controller.createItem(costKey);
            if (this.requireItem == null) {
                context.getLogger().warning("Invalid required item: " + costKey);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.item == null) {
            return SpellResult.FAIL;
        }
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.requireItem != null) {
            boolean foundItem = false;
            ItemStack[] contents = player.getInventory().getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!controller.itemsAreEqual(item, this.requireItem)) continue;
                player.getInventory().setItem(i, null);
                foundItem = true;
                break;
            }
            if (!foundItem) {
                Bukkit.getLogger().info("Not found");
                context.sendMessage("insufficient_resources");
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
        }
        Bukkit.getLogger().info("CAST");
        mage.giveItem(InventoryUtils.getCopy(this.item));
        return SpellResult.CAST;
    }

    @Override
    public String transformMessage(String message) {
        MagicAPI api = MagicPlugin.getAPI();
        if (this.requireItem != null) {
            message = message.replace("$requires", api.describeItem(this.requireItem));
        }
        if (this.item != null) {
            message = message.replace("$item", api.describeItem(this.item));
        }
        return message;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("item");
        parameters.add("require");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("item") || parameterKey.equals("require")) {
            MagicAPI api = MagicPlugin.getAPI();
            Collection<SpellTemplate> spellList = api.getSpellTemplates();
            for (SpellTemplate spell : spellList) {
                examples.add(spell.getKey());
            }
            Collection<String> allWands = api.getWandKeys();
            for (String wandKey : allWands) {
                examples.add(wandKey);
            }
            examples.addAll(api.getBrushes());
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

