/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class FreezeAction
extends BaseSpellAction {
    private boolean freezeWater;
    private boolean freezeLava;
    private boolean freezeFire;
    private Material iceMaterial;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.freezeWater = parameters.getBoolean("freeze_water", true);
        this.freezeLava = parameters.getBoolean("freeze_lava", true);
        this.freezeFire = parameters.getBoolean("freeze_fire", true);
        this.iceMaterial = ConfigurationUtils.getMaterial(parameters, "ice", Material.ICE);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        Material material = Material.SNOW;
        if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
            if (!this.freezeWater) {
                return SpellResult.NO_TARGET;
            }
            material = this.iceMaterial;
        } else if (block.getType() == Material.LAVA) {
            if (!this.freezeLava) {
                return SpellResult.NO_TARGET;
            }
            material = Material.COBBLESTONE;
        } else if (block.getType() == Material.STATIONARY_LAVA) {
            if (!this.freezeLava) {
                return SpellResult.NO_TARGET;
            }
            material = Material.OBSIDIAN;
        } else if (block.getType() == Material.FIRE) {
            if (!this.freezeFire) {
                return SpellResult.NO_TARGET;
            }
            material = Material.AIR;
        } else if (block.getType() == Material.SNOW) {
            material = Material.SNOW;
        } else {
            if (context.isTransparent(block.getType())) {
                return SpellResult.NO_TARGET;
            }
            if ((block = block.getRelative(BlockFace.UP)).getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                if (!this.freezeWater) {
                    return SpellResult.NO_TARGET;
                }
                material = this.iceMaterial;
            } else if (block.getType() == Material.LAVA) {
                if (!this.freezeLava) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                if (!this.freezeLava) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                if (!this.freezeFire) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.AIR;
            }
        }
        if (!context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        context.registerForUndo(block);
        MaterialAndData applyMaterial = new MaterialAndData(material);
        if (block.getType() == Material.SNOW && material == Material.SNOW) {
            short data = block.getData();
            if (data < 7) {
                data = (short)(data + 1);
            }
            applyMaterial.setData(data);
        }
        applyMaterial.modify(block);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("freeze_water");
        parameters.add("ice");
        parameters.add("freeze_lava");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("ice")) {
            examples.add("ice");
            examples.add("packed_ice");
        } else if (parameterKey.equals("freeze_water") || parameterKey.equals("freeze_lava") || parameterKey.equals("freeze_fire")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

