/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BrushSelectAction
extends BaseSpellAction
implements GUIAction {
    private CastContext context;
    private List<ItemStack> schematics = new ArrayList<ItemStack>();
    private Map<Material, List<ItemStack>> variants = new HashMap<Material, List<ItemStack>>();

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.context != null) {
            Mage mage = this.context.getMage();
            ItemStack item = event.getCurrentItem();
            String set = InventoryUtils.getMeta(item, "brush_set", null);
            if (set != null) {
                if (set.equals("schematics")) {
                    String inventoryTitle = this.context.getMessage("schematics_title", "Schematics");
                    int invSize = (this.schematics.size() + 9) / 9 * 9;
                    Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
                    for (ItemStack schematicItem : this.schematics) {
                        displayInventory.addItem(new ItemStack[]{schematicItem});
                    }
                    mage.deactivateGUI();
                    mage.activateGUI(this);
                    mage.getPlayer().openInventory(displayInventory);
                    return;
                }
                if (set.equals("variants")) {
                    MaterialAndData baseMaterial = new MaterialAndData(item);
                    String baseName = baseMaterial.getBaseName();
                    String inventoryTitle = this.context.getMessage("variants_title", "$variant Types").replace("$variant", baseName);
                    List<ItemStack> variantList = this.variants.get(baseMaterial.getMaterial());
                    int invSize = (variantList.size() + 9) / 9 * 9;
                    Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
                    for (ItemStack variantItem : variantList) {
                        displayInventory.addItem(new ItemStack[]{variantItem});
                    }
                    mage.deactivateGUI();
                    mage.activateGUI(this);
                    mage.getPlayer().openInventory(displayInventory);
                    return;
                }
            }
            mage.deactivateGUI();
            com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
            if (wand != null && Wand.isBrush(item)) {
                String brushKey = Wand.getBrush(item);
                wand.setActiveBrush(brushKey);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        this.schematics.clear();
        this.variants.clear();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (wand == null) {
            return SpellResult.FAIL;
        }
        ArrayList<String> brushKeys = new ArrayList<String>(wand.getBrushes());
        Collections.sort(brushKeys);
        ArrayList<Object> brushes = new ArrayList<Object>();
        ArrayList<ItemStack> specials = new ArrayList<ItemStack>();
        MaterialAndData previous = null;
        for (String brushKey : brushKeys) {
            ItemStack brushItem = Wand.createBrushItem(brushKey, controller, null, false);
            if (MaterialBrush.isSchematic(brushKey)) {
                this.schematics.add(brushItem);
                continue;
            }
            if (MaterialBrush.isSpecialMaterialKey(brushKey)) {
                specials.add(brushItem);
                continue;
            }
            if (brushItem == null) continue;
            MaterialAndData material = new MaterialAndData(brushItem);
            if (previous != null && material.getMaterial() == previous.getMaterial()) {
                List<ItemStack> variantList = this.variants.get(material.getMaterial());
                ItemStack itemStack = (ItemStack)brushes.get(brushes.size() - 1);
                if (variantList == null) {
                    String baseName = material.getBaseName();
                    variantList = new ArrayList<ItemStack>();
                    variantList.add(itemStack);
                    brushes.remove(brushes.size() - 1);
                    ItemStack category = InventoryUtils.getCopy(itemStack);
                    ItemMeta meta = category.getItemMeta();
                    String name = context.getMessage("variant_name", "" + ChatColor.AQUA + "$variant");
                    meta.setDisplayName(name.replace("$variant", baseName));
                    ArrayList<String> lore = new ArrayList<String>();
                    String description = context.getMessage("variant_description", "Choose a type of $variant");
                    lore.add(description.replace("$variant", baseName));
                    meta.setLore(lore);
                    category.setItemMeta(meta);
                    InventoryUtils.setMeta(category, "brush_set", "variants");
                    this.variants.put(material.getMaterial(), variantList);
                    brushes.add(category);
                }
                variantList.add(brushItem);
            } else {
                brushes.add(brushItem);
            }
            previous = material;
        }
        ItemStack schematicItem = null;
        if (this.schematics.size() == 1) {
            schematicItem = this.schematics.get(0);
        } else if (this.schematics.size() > 0) {
            schematicItem = InventoryUtils.getCopy(this.schematics.get(0));
            ItemMeta meta = schematicItem.getItemMeta();
            meta.setDisplayName(context.getMessage("schematics_name", "" + ChatColor.AQUA + "Schematics"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(context.getMessage("schematics_description", "Choose a schematic"));
            meta.setLore(lore);
            schematicItem.setItemMeta(meta);
            InventoryUtils.setMeta(schematicItem, "brush_set", "schematics");
        }
        if (schematicItem != null) {
            brushes.add(schematicItem);
        }
        brushes.addAll(specials);
        String inventoryTitle = context.getMessage("title", "Brushes");
        int invSize = (brushes.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (ItemStack itemStack : brushes) {
            displayInventory.addItem(new ItemStack[]{itemStack});
        }
        mage.activateGUI(this);
        mage.getPlayer().openInventory(displayInventory);
        return SpellResult.CAST;
    }
}

