/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.RegenerateBatch;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RegenerateSpell
extends BlockSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.targetLocation2 != null) {
            this.targetBlock = this.targetLocation2.getBlock();
        }
        if (this.targetBlock != null || this.getTargetType() == TargetType.BLOCK) {
            Block secondBlock = this.getTargetType() == TargetType.BLOCK ? targetBlock : this.targetBlock;
            RegenerateBatch batch = new RegenerateBatch(this, secondBlock.getLocation(), targetBlock.getLocation());
            int maxDimension = parameters.getInt("max_dimension", 128);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                return SpellResult.FAIL;
            }
            batch.setExpand(parameters.getBoolean("expand", false));
            boolean success = this.mage.addBatch(batch);
            this.deactivate();
            return success ? SpellResult.CAST : SpellResult.FAIL;
        }
        this.targetBlock = targetBlock;
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }
}

